/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPNullCellDecoration;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.MDXAncestor;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXNumericOperator;
import com.cognos.xqe.ast.olap.MDXOrder;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXRank;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateTupleClause;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5MemberAnalyticFunction;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5OrderedValueExpression;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public class ConvertV5MemberAnalyticFunctionsToMDXExpressions
extends AbstractV5ToCogMDXTransformation {
    public static final int QUARTILE_BUCKETS = 4;
    public static final int CHILD_HIERARCHY = 3;
    public static final String STRING_NAME = "name";

    public ConvertV5MemberAnalyticFunctionsToMDXExpressions() {
        this.mName = "Converts a V5 Member Analytic Function (rank, quantile, etc.)  to a MDX expression.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201034};
    }

    public static void generateDecorationNullCell(IXQEQueryNode node, IXQENodeFactory nodeFactory, MDXRank rankNode) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        V5ValueSet valueSet = (V5ValueSet)node.getAncestorOfType(101057);
        if (valueSet != null) {
            int edgeNum;
            RSAPIDataItem rsapiRefDataItem = valueSet.getRSAPIDataItem();
            RSAPIEdgeRowset rsapiRowset = valueSet.getRSAPIEdgeRowset();
            OLAPNullCellDecoration cellDeco = (OLAPNullCellDecoration)nodeFactory.createNode(601015);
            V5Edge v5Edge = (V5Edge)node.getAncestorOfType(101049);
            String sEdge = v5Edge.getPropertyValue(STRING_NAME).toString();
            for (edgeNum = 0; edgeNum < rsapiDataset.getNumEdges() && !rsapiDataset.getEdge(edgeNum).getName().equals(sEdge); ++edgeNum) {
            }
            String v5Name = null;
            String v5NameRef = null;
            V5MemberFunction v5MemberFunction = (V5MemberFunction)node.getAncestorOfType(201085);
            if (v5MemberFunction != null) {
                if (v5MemberFunction.getNumberChildren() > 1 && v5MemberFunction.getChild(1) != null) {
                    v5Name = ((MDXStringConstant)v5MemberFunction.getChild(1)).getConstantValue();
                }
                if (v5MemberFunction.getNumberChildren() > 2 && v5MemberFunction.getChild(2) != null) {
                    v5NameRef = ((MDXStringConstant)v5MemberFunction.getChild(2)).getConstantValue();
                }
                if (v5Name == null || v5NameRef == null) {
                    node.throwInternalError("Unexpected parameters for V5MemberFunction");
                }
                if (v5MemberFunction.isQueryCalculation()) {
                    cellDeco.setIsQueryCalculation();
                }
            }
            cellDeco.setEdgeOrdinal(edgeNum);
            cellDeco.setRSAPIRowsetProperty(rsapiRowset);
            cellDeco.setDataItemProperty(rsapiRefDataItem);
            cellDeco.setV5NameProperty(v5Name);
            cellDeco.setV5NameRefProperty(v5NameRef);
            rankNode.setNullCellDecoration(cellDeco);
            mdxQuery.insertParent(cellDeco);
        }
    }

    public static MDXNumericIIF generateRankIFexpr(IXQEQueryNode node, MDXRank rankNode, AbstractMDXSet rankSet, IHierarchy dfHierarchy, int solveOrder, IXQENodeFactory nodeFactory) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        int functionType = ((V5MemberAnalyticFunction)node).getSubType();
        MDXCalculatedMemberReference rankCalcMember = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, dfHierarchy, "_AG", rankNode, solveOrder);
        rankCalcMember.setCopyDefinition(false);
        AbstractMDXNumericValueExpression rankCalc = MDXBuilder.coerceToNumericValueExpression(rankCalcMember, nodeFactory);
        ConvertV5MemberAnalyticFunctionsToMDXExpressions.generateDecorationNullCell(node, nodeFactory, rankNode);
        MDXNumericConstant rank0 = MDXBuilder.buildMDXNumericConstant(nodeFactory, XQEIntegerPool.getInteger(0));
        MDXComparisonOperator rankCond = MDXBuilder.buildMDXComparisonExpr(nodeFactory, 3, (AbstractMDXNumericValueExpression)nodeFactory.deepCopyNode(rankCalc), rank0);
        if (functionType == 16 || functionType == 17 || functionType == 18) {
            AbstractMDXValueExpression nTile = null;
            if (functionType == 18) {
                nTile = MDXBuilder.buildMDXNumericConstant(nodeFactory, XQEIntegerPool.getInteger(4));
            }
            if (functionType == 17) {
                V5OrderedValueExpression childOrderValue = (V5OrderedValueExpression)node.getChild(1);
                nTile = (AbstractMDXValueExpression)childOrderValue.detachChild(0);
            }
            MDXCount countRankSet = MDXBuilder.buildMDXCountExpr(nodeFactory, (AbstractMDXSet)nodeFactory.deepCopyNode(rankSet), true);
            MDXCalculatedMemberReference rankCountMember = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, dfHierarchy, "_AG", countRankSet, solveOrder);
            AbstractMDXNumericValueExpression rankCount = MDXBuilder.coerceToNumericValueExpression(rankCountMember, nodeFactory);
            rankCalc = MDXBuilder.buildMDXNumericOperator(nodeFactory, 0, rankCalc, MDXBuilder.buildMDXNumericConstant(nodeFactory, XQEIntegerPool.getInteger(1)));
            if (functionType != 16) {
                rankCalc = MDXBuilder.buildMDXNumericOperator(nodeFactory, 3, (AbstractMDXValueExpression)rankCalc, nTile);
            }
            rankCalc = MDXBuilder.buildMDXNumericOperator(nodeFactory, 2, rankCalc, rankCount);
            int operator = 1;
            if (functionType == 16) {
                operator = 0;
            }
            rankCalc = MDXBuilder.buildMDXNumericOperator(nodeFactory, operator, MDXBuilder.buildMDXNumericConstant(nodeFactory, XQEIntegerPool.getInteger(1)), rankCalc);
            if (functionType != 16) {
                rankCalc = MDXBuilder.buildMDXScalarFunction(nodeFactory, 3, rankCalc);
            }
        }
        return MDXBuilder.buildMDXNumericIIFExprWithNull(nodeFactory, rankCond, rankCalc);
    }

    public static void generateRankTuple(IXQEQueryNode node, AbstractMDXSet rankSet, MDXTuple rankTuple, V5AggregateTupleClause childTuple, IXQENodeFactory nodeFactory) {
        if (rankSet.getType() == 1057) {
            ConvertV5MemberAnalyticFunctionsToMDXExpressions.generateRankTuple(node, (AbstractMDXSet)rankSet.getChild(1), rankTuple, childTuple, nodeFactory);
            return;
        }
        if (rankSet.getType() == 1030) {
            ConvertV5MemberAnalyticFunctionsToMDXExpressions.generateRankTuple(node, (AbstractMDXSet)rankSet.getChild(0), rankTuple, childTuple, nodeFactory);
            ConvertV5MemberAnalyticFunctionsToMDXExpressions.generateRankTuple(node, (AbstractMDXSet)rankSet.getChild(1), rankTuple, childTuple, nodeFactory);
            return;
        }
        AbstractMDXNode childRankTuple = null;
        MDXHierInfo childHierInfo = rankSet.getHierarchyInfo();
        for (int j = 0; j < childTuple.getNumberChildren(); ++j) {
            AbstractMDXNode member = (AbstractMDXNode)childTuple.getChild(j);
            if (!childHierInfo.compareProjectedHierarchies(member.getHierarchyInfo())) continue;
            childRankTuple = (AbstractMDXNode)childTuple.detachChild(member);
            break;
        }
        if (childRankTuple == null && ((V5MemberAnalyticFunction)node).getSubType() != 15) {
            childRankTuple = MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, childHierInfo.getProjectedHierarchy(0));
        }
        if (childRankTuple != null) {
            rankTuple.addChild(childRankTuple);
        }
    }

    public static AbstractMDXNumericValueExpression generateRankOrderValue(IXQEQueryNode node, AbstractMDXSet rankSet, AbstractMDXValueExpression childMeasure, V5AggregateTupleClause childTuple, IHierarchy dfHierarchy, int solveOrder, IXQENodeFactory nodeFactory) {
        MDXTuple rankOrder = null;
        if (childMeasure.getType() == 1059 && childMeasure.getChild(0).isOfCategory(1068)) {
            rankOrder = (MDXTuple)childMeasure.detachChild(0);
        } else {
            rankOrder = (MDXTuple)nodeFactory.createNode(1069);
            rankOrder.addChild(childMeasure);
        }
        for (int j = 0; j < childTuple.getNumberChildren(); ++j) {
            rankOrder.addChild(childTuple.detachChild(j));
        }
        return MDXBuilder.coerceToNumericValueExpression(rankOrder, nodeFactory);
    }

    public static void adjustCurrentMemberInRankSet(AbstractMDXSet rankSet, IXQENodeFactory nodeFactory) {
        if (rankSet.getType() != 1052) {
            return;
        }
        AbstractMDXNode cmChild = (AbstractMDXNode)rankSet.getChild(0);
        AbstractMDXNode cmParentDepth = (AbstractMDXNode)rankSet.getChild(1);
        if (cmChild.getType() != 1076 || !cmParentDepth.isOfCategory(1062)) {
            return;
        }
        MDXAncestor mdxAncestor = (MDXAncestor)nodeFactory.createNode(1043);
        mdxAncestor.addChild(nodeFactory.deepCopyNode(cmChild));
        mdxAncestor.addChild(nodeFactory.deepCopyNode(cmParentDepth));
        rankSet.exchangeChildNode(cmChild, mdxAncestor, false);
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXRank rankNode = null;
        MDXTuple rankTuple = (MDXTuple)nodeFactory.createNode(1069);
        AbstractMDXSet rankSet = null;
        int childCount = node.getNumberChildren();
        V5OrderedValueExpression childOrderValue = (V5OrderedValueExpression)node.getChild(0);
        boolean bASCsort = childOrderValue.isASCsort();
        AbstractMDXValueExpression childMeasure = (AbstractMDXValueExpression)childOrderValue.detachChild(0);
        V5AggregateWithinClause childWithinSet = (V5AggregateWithinClause)node.getChild(childCount - 1);
        V5AggregateTupleClause childTuple = null;
        childTuple = (V5AggregateTupleClause)node.getFirstChildByType(201038);
        if (childTuple == null) {
            childTuple = (V5AggregateTupleClause)nodeFactory.createNode(201038);
        }
        V5MemberFunction ancestorMemberFunction = (V5MemberFunction)node.getAncestorOfType(201085);
        int solveOrder = SolveOrderUtil.getUndefinedV5DataItemRefSolveOrder();
        if (ancestorMemberFunction != null && ancestorMemberFunction.getSolveOrder() != null) {
            solveOrder = ancestorMemberFunction.getSolveOrder();
        }
        for (int j = 0; j < childTuple.getNumberChildren(); ++j) {
            AbstractMDXNode member = (AbstractMDXNode)childTuple.getChild(j);
            if (!member.getHierarchyInfo().getProjectedHierarchy(0).getDimension().isMeasuresDimension()) continue;
            childTuple.detachChild(member);
            break;
        }
        IHierarchy dfHierarchy = null;
        if (childTuple.getNumberChildren() > 0) {
            dfHierarchy = ((AbstractMDXNode)childTuple.getChild(0)).getHierarchyInfo().getProjectedHierarchy(0);
        } else if (ancestorMemberFunction != null && ancestorMemberFunction.getNumberChildren() > 3 && ancestorMemberFunction.getChild(3) != null) {
            dfHierarchy = ((BaseHierarchy)ancestorMemberFunction.getChild(3)).getHierarchy();
        } else {
            MDXHierInfo hierInfo = childMeasure.getHierarchyInfo();
            if (hierInfo.getProjectedHierarchies() != null && hierInfo.getProjectedHierarchies().size() > 0) {
                dfHierarchy = hierInfo.getProjectedHierarchy(0);
            } else {
                dfHierarchy = mdxQuery.getMeasuresHierarchy();
                childMeasure = MDXBuilder.coerceToNumericValueExpression(MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, dfHierarchy, "_CM", childMeasure, solveOrder), nodeFactory);
            }
        }
        rankSet = (AbstractMDXSet)childWithinSet.detachChild(0);
        ConvertV5MemberAnalyticFunctionsToMDXExpressions.generateRankTuple(node, rankSet, rankTuple, childTuple, nodeFactory);
        AbstractMDXNumericValueExpression rankOrderValue = ConvertV5MemberAnalyticFunctionsToMDXExpressions.generateRankOrderValue(node, rankSet, childMeasure, childTuple, dfHierarchy, solveOrder, nodeFactory);
        if (((V5MemberAnalyticFunction)node).getSubType() == 15) {
            AbstractMDXNode childNode = rankOrderValue;
            if (((AbstractMDXNode)childNode).getType() == 1059 && childNode.getChild(0).isOfCategory(1068)) {
                childNode = (AbstractMDXNode)childNode.getChild(0);
            }
            for (int j = 0; j < childNode.getNumberChildren(); ++j) {
                rankTuple.addChild(nodeFactory.deepCopyNode(childNode.getChild(j)), -1);
            }
            AbstractMDXNumericValueExpression rankTupleValue = MDXBuilder.coerceToNumericValueExpression(rankTuple, nodeFactory);
            MDXSummaryFunction totalExpr = MDXBuilder.buildMDXSummaryFunctionExpr(nodeFactory, MDXSummaryFunctionTypeEnum.SUM, rankSet, rankOrderValue);
            MDXTuple rankOrder = (MDXTuple)nodeFactory.createNode(1069);
            MDXCalculatedMemberReference totalExprMember = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, dfHierarchy, "_AG", totalExpr, solveOrder);
            rankOrder.addChild(totalExprMember);
            rankOrderValue = MDXBuilder.coerceToNumericValueExpression(rankOrder, nodeFactory);
            MDXNumericOperator numOp = MDXBuilder.buildMDXNumericOperator((IXQENodeFactory)nodeFactory, 2, rankTupleValue, rankOrderValue);
            node.getParent().exchangeChildNode(node, numOp, false);
            numOp.setPropertyValue("FORMAT_STRING", "Percent");
            return;
        }
        ConvertV5MemberAnalyticFunctionsToMDXExpressions.adjustCurrentMemberInRankSet(rankSet, nodeFactory);
        if (mdxQuery.olympicRankSupported()) {
            rankNode = MDXBuilder.buildMDXOlympicRankExpr(nodeFactory, rankTuple, rankSet, rankOrderValue, bASCsort, mdxQuery.olympicRankSortSupported());
        } else {
            MDXOrder orderSet = MDXBuilder.buildMDXOrderExpr(nodeFactory, rankSet, rankOrderValue, bASCsort, false);
            rankNode = MDXBuilder.buildMDXSerialRankExpr(nodeFactory, rankTuple, orderSet);
        }
        MDXNumericIIF iffExp = ConvertV5MemberAnalyticFunctionsToMDXExpressions.generateRankIFexpr(node, rankNode, rankSet, dfHierarchy, solveOrder, nodeFactory);
        int functionType = ((V5MemberAnalyticFunction)node).getSubType();
        if (functionType == 14 || functionType == 17 || functionType == 18) {
            iffExp.setPropertyValue("FORMAT_STRING", "#");
        } else if (functionType == 16) {
            iffExp.setPropertyValue("FORMAT_STRING", "Percent");
        }
        node.getParent().exchangeChildNode(node, iffExp, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        int functionType = ((V5MemberAnalyticFunction)node).getSubType();
        if (functionType != 14 && functionType != 15 && functionType != 16 && functionType != 17 && functionType != 18) {
            this.traceNodeCondition(false, "The type of the V5MemberAnalyticFunction is unsupported or invalid.", trace);
            return false;
        }
        int childCount = node.getNumberChildren();
        if (childCount < 2 || childCount <= 2 && functionType == 17) {
            this.traceNodeCondition(false, "Incorrect number of children for V5MemberAnalyticFunction", trace);
            return false;
        }
        V5OrderedValueExpression childMeasure = (V5OrderedValueExpression)node.getChild(0);
        if (!childMeasure.getChild(0).isOfCategory(1061)) {
            this.traceNodeCondition(false, "The first argument of the analytic function is not a value expression.", trace);
            return false;
        }
        int countMeasures = node.getChildrenOfType(201114).length;
        if (countMeasures > 2 || countMeasures > 1 && functionType != 17) {
            this.traceNodeCondition(false, "The first argument of the analytic function has to be a single measure.", trace);
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_AnalyticFunctionsSupportOneMeasureOnly);
        }
        if (functionType == 17 && !(childMeasure = (V5OrderedValueExpression)node.getChild(1)).getChild(0).isOfCategory(1061)) {
            this.traceNodeCondition(false, "The second argument for QUANTILE function is not a value expression.", trace);
            return false;
        }
        V5AggregateWithinClause childSet = (V5AggregateWithinClause)node.getChild(childCount - 1);
        if (childSet.getWithinClauseType() == 2) {
            this.traceNodeCondition(false, "The last argument of the analytic function is not WITHIN set.", trace);
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppWithinAggregate, node.getNodeTypeName());
        }
        if (childSet.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The within set summary function has more than one specified set, which must be handled by another transformation first.", trace);
            return false;
        }
        if (!childSet.getChild(0).isOfCategory(1021)) {
            this.traceNodeCondition(false, "The argument WITHIN SET is not a set expression.", trace);
            return false;
        }
        IXQEQueryNode childTuple = null;
        childTuple = node.getFirstChildByType(201038);
        if (childTuple != null && !childTuple.getChild(0).isOfCategory(1022)) {
            this.traceNodeCondition(false, "The argument TUPLE is not a member expression.", trace);
            return false;
        }
        V5MemberFunction v5MemberFunction = (V5MemberFunction)node.getAncestorOfType(201085);
        if (v5MemberFunction != null) {
            if (v5MemberFunction.getNumberChildren() > 1 && v5MemberFunction.getChild(1).getType() != 1127) {
                this.traceNodeCondition(false, "The member function wrapping the rank has a second child which is not a MDX string constant.", trace);
                return false;
            }
            if (v5MemberFunction.getNumberChildren() > 2 && v5MemberFunction.getChild(2).getType() != 1127) {
                this.traceNodeCondition(false, "The member function wrapping the rank has a third child which is not a MDX string constant.", trace);
            }
        }
        this.traceNodeCondition(true, "The target V5MemberAnalyticFunction node can be converted to an MDX expression node.", trace);
        return true;
    }
}

