/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.v5Exp.V5NullIfFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class ConvertV5NullIfFunctionToMDXIIF
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5NullIfFunctionToMDXIIF() {
        this.mName = "Convert the V5NullIfFunction function to the MDXIIF function.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201089};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5NullIfFunction v5NullIfFunction = (V5NullIfFunction)node;
        IDataType dataType = v5NullIfFunction.getDataTypeProperty();
        int iifType = 0;
        if (dataType.getSubType() == DataSubType.NUMERICTYPE) {
            iifType = 1085;
        } else if (dataType.getSubType() == DataSubType.TEXTTYPE) {
            iifType = 1086;
        } else if (dataType.getSubType() == DataSubType.DATETIMETYPE) {
            iifType = 1168;
        } else {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_Unsupported_IIF_FunctionArgument);
        }
        AbstractMDXNode mdxIIF = (AbstractMDXNode)nodeFactory.createNode(iifType);
        mdxIIF.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        node.insertParent(mdxIIF);
        MDXComparisonOperator mdxComparison = (MDXComparisonOperator)nodeFactory.createNode(1070);
        mdxComparison.setOperatorType(1);
        node.exchange(mdxComparison, true);
        IXQEQueryNode mdxNull = nodeFactory.createNode(1089);
        mdxIIF.addChild(mdxNull);
        mdxIIF.addChild(nodeFactory.deepCopyNode(mdxComparison.getChild(0)));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int maxNumchildren = 2;
        V5NullIfFunction v5NullIfFunction = (V5NullIfFunction)node;
        if (node.getNumberChildren() == 2 && v5NullIfFunction.getDataTypeProperty() != null) {
            status = true;
            this.traceNodeCondition(status, "The V5NullIfFunction function has 2 valid arguments.", trace);
        } else {
            this.traceNodeCondition(status, "The V5NullIfFunction function does not have 2 valid arguments.", trace);
        }
        return status;
    }
}

