/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXHierarchy;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public final class ConvertV5RootMember
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5RootMember() {
        this.mName = "Convert V5 RootMember function to MDXTupleItem(MDXSetItem(MDXMembers(hierarchy.LEVEL(0)),0),0).";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201099};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode mdxMembers = nodeFactory.createNode(1040);
        boolean transferDescendants = true;
        node.getParent().exchangeChildNode(node, mdxMembers, transferDescendants);
        IXQEQueryNode mdxLevels = nodeFactory.createNode(1066);
        mdxMembers.getChild(0).insertParent(mdxLevels);
        MDXNumericConstant mdxNumericValue = (MDXNumericConstant)nodeFactory.createNode(1064);
        mdxNumericValue.setConstantValue(XQEIntegerPool.getInteger(0));
        mdxLevels.addChild(mdxNumericValue);
        IXQEQueryNode mdxSetItem = nodeFactory.createNode(1054);
        mdxMembers.insertParent(mdxSetItem);
        mdxNumericValue = (MDXNumericConstant)nodeFactory.deepCopyNode(mdxNumericValue);
        mdxSetItem.addChild(mdxNumericValue);
        IXQEQueryNode mdxTupleItem = nodeFactory.createNode(1055);
        mdxSetItem.insertParent(mdxTupleItem);
        mdxNumericValue = (MDXNumericConstant)nodeFactory.deepCopyNode(mdxNumericValue);
        mdxTupleItem.addChild(mdxNumericValue);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 1) {
            if (node.getChild(0).isOfCategory(1072)) {
                if (((AbstractMDXHierarchy)node.getChild(0)).getHierarchy().isMultiRoot()) {
                    status = false;
                    StringBuilder errMsg = new StringBuilder("The V5RootMember function is not supported for multi-root hierarchy arguments.");
                    errMsg.append(". Use instead V5RootMembers.");
                    this.traceNodeCondition(status, errMsg.toString(), trace);
                    throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsuppV5RootMemberOfMultiRootHierarchy, ((AbstractMDXHierarchy)node.getChild(0)).getHierarchy().getUniqueName());
                }
                status = true;
                this.traceNodeCondition(status, "The V5RootMember function is valid and could be converted.", trace);
            } else {
                this.traceNodeCondition(status, "The argument is of an invalid type.", trace);
            }
        } else {
            this.traceNodeCondition(status, "The V5RootMember has an invalid number of arguments.", trace);
        }
        return status;
    }
}

