/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.CogMDXScalarFunction;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5ScalarFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public class ConvertV5ScalarFunctionToCogMDXScalarFunction
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5ScalarFunctionToCogMDXScalarFunction() {
        this.mName = "Convert V5 Scalar functions to CogMDX Scalar functions.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201040};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXNumericValueExpression numericValueExpressionNode = null;
        int scalarFunctionType = -1;
        int subType = ((V5ScalarFunction)node).getSubType();
        switch (subType) {
            case 0: {
                scalarFunctionType = 1;
                break;
            }
            case 8: {
                scalarFunctionType = 2;
                break;
            }
            case 4: {
                if (this.isUsingLocalMDXEngine(node)) {
                    scalarFunctionType = 19;
                    break;
                }
                numericValueExpressionNode = this.createIIF4CeilFloorOnNegativeValues(subType, node, environment);
                break;
            }
            case 9: {
                scalarFunctionType = 4;
                break;
            }
            case 7: {
                scalarFunctionType = 5;
                break;
            }
            case 1: 
            case 2: {
                if (this.isUsingLocalMDXEngine(node)) {
                    scalarFunctionType = 20;
                    break;
                }
                numericValueExpressionNode = this.createIIF4CeilFloorOnNegativeValues(subType, node, environment);
                break;
            }
            case 3: {
                scalarFunctionType = 7;
                break;
            }
            case 5: {
                scalarFunctionType = 8;
                break;
            }
            case 10: {
                scalarFunctionType = 9;
                break;
            }
            case 11: {
                scalarFunctionType = 10;
                break;
            }
            case 12: {
                scalarFunctionType = 11;
                break;
            }
            case 13: {
                scalarFunctionType = 12;
                break;
            }
            case 14: {
                scalarFunctionType = 13;
                break;
            }
            case 15: {
                scalarFunctionType = 14;
                break;
            }
            case 16: {
                scalarFunctionType = 15;
                break;
            }
            case 17: {
                scalarFunctionType = 16;
                break;
            }
            case 18: {
                scalarFunctionType = 17;
                break;
            }
            case 19: {
                scalarFunctionType = 18;
                break;
            }
            default: {
                scalarFunctionType = -1;
            }
        }
        if (scalarFunctionType != -1 && numericValueExpressionNode == null) {
            CogMDXScalarFunction scalarFunctionNode = (CogMDXScalarFunction)nodeFactory.createNode(1144);
            scalarFunctionNode.setOperatorType(scalarFunctionType);
            numericValueExpressionNode = scalarFunctionNode;
        }
        numericValueExpressionNode.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        node.getParent().exchangeChildNode(node, numericValueExpressionNode, true);
    }

    private boolean isUsingLocalMDXEngine(IXQEQueryNode node) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        return mdxQuery.getUseLocalQueryProcessing() || !mdxQuery.isRemoteDatasourceOLAP();
    }

    private AbstractMDXNumericValueExpression createIIF4CeilFloorOnNegativeValues(int subType, IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        AbstractMDXNumericValueExpression valueExpr = (AbstractMDXNumericValueExpression)node.detachFirstChild();
        MDXComparisonOperator geqExpr = MDXBuilder.buildMDXComparisonExpr(factory, 6, valueExpr, MDXBuilder.buildMDXNumericConstant((IXQENodeFactory)factory, 0));
        AbstractMDXNumericValueExpression numValueExprIf = null;
        AbstractMDXNumericValueExpression numValueExprElse = null;
        switch (subType) {
            case 1: 
            case 2: {
                numValueExprIf = this.createCogMDXScalarFunction(factory, 6, valueExpr);
                numValueExprElse = this.createCogMDXScalarFunction(factory, 3, valueExpr);
                break;
            }
            case 4: {
                numValueExprIf = this.createCogMDXScalarFunction(factory, 3, valueExpr);
                numValueExprElse = this.createCogMDXScalarFunction(factory, 6, valueExpr);
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid Scalar Function Type");
            }
        }
        return MDXBuilder.buildMDXNumericIIFExpr(factory, geqExpr, numValueExprIf, numValueExprElse);
    }

    private AbstractMDXNumericValueExpression createCogMDXScalarFunction(IXQENodeFactory factory, int scalarFunctionType, AbstractMDXNumericValueExpression valueExpr) {
        return MDXBuilder.buildMDXScalarFunction(factory, scalarFunctionType, (AbstractMDXNumericValueExpression)factory.deepCopyNode(valueExpr));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int nbrArguments = node.getNumberChildren();
        String scalarFunctionName = ((V5ScalarFunction)node).getNodeSubTypeName();
        String invalidNumberOfArguments = " function has invalid number of arguments.";
        switch (((V5ScalarFunction)node).getSubType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (nbrArguments == 1) {
                    if (!V5ToCogMDXUtilities.isCoercableToNumericValueExpression(node.getChild(0))) {
                        this.traceNodeCondition(status, scalarFunctionName + " function has an argument that is not a numeric value expression.", trace);
                        break;
                    }
                    status = true;
                    this.traceNodeCondition(status, scalarFunctionName + " function has single valid argument.", trace);
                    break;
                }
                this.traceNodeCondition(status, scalarFunctionName + invalidNumberOfArguments, trace);
                break;
            }
            case 7: 
            case 8: {
                if (nbrArguments == 2) {
                    if (!V5ToCogMDXUtilities.isCoercableToNumericValueExpression(node.getChild(0)) || !V5ToCogMDXUtilities.isCoercableToNumericValueExpression(node.getChild(1))) {
                        this.traceNodeCondition(status, "One of the arguments of " + scalarFunctionName + " function is not a numeric value expression.", trace);
                        break;
                    }
                    status = true;
                    this.traceNodeCondition(status, scalarFunctionName + " function has two valid arguments.", trace);
                    break;
                }
                this.traceNodeCondition(status, scalarFunctionName + invalidNumberOfArguments, trace);
                break;
            }
            default: {
                status = false;
            }
        }
        return status;
    }
}

