/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.function;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ConvertV5TupleToCogMDXTuple
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5TupleToCogMDXTuple() {
        this.mName = "Convert V5 Tuple to CogMDX Tuple.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201110, 201056};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode newNode = null;
        if (node.getType() == 201110) {
            newNode = nodeFactory.createNode(1069);
        } else {
            newNode = nodeFactory.createNode(1099);
            newNode.setPropertyValue("FromV5CompleteTuple", Boolean.TRUE);
        }
        node.exchange(newNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getType() == 201110 && node.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "The V5TupleFunction node must have at least one child node.", trace);
            return false;
        }
        if (node.getNumberChildren() != node.getChildrenOfCategory(1022).length) {
            if (node.getNumberChildren() != node.getChildrenOfCategory(201085).length && node.getParent().getType() == 201113 && node.getParent().getParent().getType() == 1009) {
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedValueExpressionInSlicer, node);
                throw new XQEOlapUnsupportedQueryException(message);
            }
            this.traceNodeCondition(false, "At least one of the children of the target node is not an AbstractMDXMember instance.", trace);
            return false;
        }
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            MDXHierInfo hierInfo = ((AbstractMDXMember)node.getChild(i)).getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() != 1) {
                this.traceNodeCondition(false, "The child node does not project a single hierarchy.", trace);
                return false;
            }
            for (int j = i - 1; j >= 0; --j) {
                MDXHierInfo prevHierInfo = ((AbstractMDXMember)node.getChild(j)).getHierarchyInfo();
                if (!hierInfo.compareProjectedHierarchies(prevHierInfo)) continue;
                String dataItemName = null;
                IXQEQueryNode v5DataItem = node.getAncestorOfType(101003);
                if (v5DataItem != null) {
                    dataItemName = ((V5DataItem)v5DataItem).getNameProperty();
                } else {
                    IXQEQueryNode v5ValueSet = node.getAncestorOfType(101057);
                    if (v5ValueSet != null) {
                        dataItemName = ((V5ValueSet)v5ValueSet).getRefDataItemProperty();
                    }
                }
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_InvalidTupleFunctionParametersSameHierarchy, ((V5SimpleNode)node).getNativeName(), dataItemName, node);
                throw new XQERuntimeException(message);
            }
        }
        return true;
    }
}

