/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.rsapicompensation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.CogMDXReportSummaryExpr;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;

public final class UpdateRSAPIDataTypeForListCountSummary
extends Transformation {
    public static final String RSAPI_DATA_TYPE_AND_USAGE_UPDATED = "rsapiDataTypeAndUsageUpdated";

    public UpdateRSAPIDataTypeForListCountSummary() {
        this.mName = "Update RSAPI expression usage to fact for list report count summary.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{1028};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXReportSummaryExpr summaryExpr = (CogMDXReportSummaryExpr)node;
        CogMDXReportSummary summary = (CogMDXReportSummary)summaryExpr.getAncestorOfCategory(1080);
        RSAPIDataItem rsapiDataItem = summary.getRSAPIDataItem(summaryExpr);
        rsapiDataItem.setDataType(IntegerType.INTEGERTYPE);
        rsapiDataItem.setUsage(RSAPIUsage.FACT);
        node.setPropertyValue(RSAPI_DATA_TYPE_AND_USAGE_UPDATED, "true");
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXReportSummaryExpr summaryExpr;
        CogMDXReportSummary summary;
        RSAPIDataItem rsapiDataItem;
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(RSAPI_DATA_TYPE_AND_USAGE_UPDATED) != null) {
            this.traceQueryCondition(false, "The transformation already applied.", trace);
            return false;
        }
        IXQEQueryNode aggrExp = node.getChild(0);
        if (aggrExp.getType() == 1012) {
            V5RollupAggregateEnum rollupAggregate;
            if (aggrExp.getNumberChildren() == 2 && (rollupAggregate = ((AbstractMDXNode)aggrExp.getChild(1)).getRollupAggregate()) != V5RollupAggregateEnum.COUNT && rollupAggregate != V5RollupAggregateEnum.COUNT_DISTINCT) {
                this.traceQueryCondition(false, "The summary is not about something that will resolve count(distinct).", trace);
                return false;
            }
        } else if (node.getChild(0).getType() != 1087) {
            this.traceQueryCondition(false, "The summary is not about count.", trace);
            return false;
        }
        if ((rsapiDataItem = (summary = (CogMDXReportSummary)(summaryExpr = (CogMDXReportSummaryExpr)node).getAncestorOfCategory(1080)).getRSAPIDataItem(summaryExpr)) == null) {
            this.traceQueryCondition(false, "The related RSAPI data item is missing.", trace);
            return false;
        }
        if (rsapiDataItem.getUsage() == RSAPIUsage.FACT && rsapiDataItem.getDataType() == IntegerType.INTEGERTYPE) {
            this.traceQueryCondition(false, "The related RSAPI usage already set has fact of integer data type.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (!mdxQuery.isListReport()) {
            this.traceQueryCondition(false, "It is not a list report, but an crosstab.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The RSAPI usage and data type need to be updated for this count summary.", trace);
        return true;
    }
}

