/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5exptomdxexp.summary.ConvertV5ValueCountToIfThenElse;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class CollapseV5ValueSummaryFunctionOnValueExpression
extends AbstractV5ToCogMDXTransformation {
    public static final String PROP_CHILD_COLLAPSED = "ChildV5ValueSummaryFunctionCollapsed";

    public CollapseV5ValueSummaryFunctionOnValueExpression() {
        this.mName = "Collapse the V5 Value Summary Function (total, average, etc.) when having a numeric value expression as single argument.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201031};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getParent().getType() == 201031) {
            node.getParent().setPropertyValue(PROP_CHILD_COLLAPSED, Boolean.TRUE);
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (node.getNumberChildren() != 1 || !node.getChild(0).isOfCategory(1061)) {
            this.traceNodeCondition(false, "The target V5ValueSummaryFunction node has more than one argument.", trace);
            return false;
        }
        int v5SummaryType = ((V5ValueSummaryFunction)node).getSubType();
        if (!(v5SummaryType != 2 && v5SummaryType != 3 || mdxQuery.isRelationalStyleQuery() || (query = DMRUtilities.findQuery(node)) != null && query.isDMR() || ConvertV5ValueCountToIfThenElse.isValidCountMeasure((V5ValueSummaryFunction)node))) {
            this.traceNodeCondition(false, "The target V5ValueSummaryFunction node requires a calculation.", trace);
            return false;
        }
        if (!mdxQuery.isDMR()) {
            MDXSummaryFunctionTypeEnum summaryType = MDXSummaryFunctionTypeEnum.convertV5SummaryFunctionTypeToMDXSummaryFunctionType(v5SummaryType);
            switch (summaryType) {
                case STANDARD_DEVIATION: 
                case STANDARD_DEVIATION_POPULATION: 
                case VARIANCE: 
                case VARIANCE_POPULATION: {
                    this.traceNodeCondition(false, "The target V5ValueSummaryFunction node will NOT return the measure value.", trace);
                    return false;
                }
            }
        }
        this.traceNodeCondition(true, "The target V5ValueSummaryFunction node has only one argument and will return the measure value.", trace);
        return true;
    }
}

