/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5ListReportSummary;
import com.cognos.xqe.ast.localprocessing.v5.V5ListReportSummaryRule;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIUsage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import java.util.List;

public final class ConvertV5GroupHeaderFooterToLocalProcessing
extends AbstractV5ToCogMDXTransformation {
    public ConvertV5GroupHeaderFooterToLocalProcessing() {
        this.mName = "Convert V5 Group Footer to V5ListReportSummary for local processing.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101052};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        String refQuery = mdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        V5ValueSet valueSet = (V5ValueSet)node.getParent();
        V5DataItemRef v5DataItemRef = (V5DataItemRef)node.getChild(0);
        V5DataItem v5DataItemRefv5DataItem = v5Query.getV5Selection().getDataItemByRefName(v5DataItemRef.getDataItemRefProperty());
        int[] types = new int[]{1026, 1027};
        List<IXQEQueryNode> nests = valueSet.getDescendantsOfTypesOrdered(types, false);
        RSAPIEdgeRowset valueSetRowset = valueSet.getRSAPIEdgeRowset();
        RSAPIDataItem valueSetDataItem = valueSet.getRSAPIDataItem();
        nests.addAll(mdxQuery.getDescendantsOfTypeOrdered(101057, false));
        IXQEQueryNode lpNodeLocation = mdxQuery.getParent();
        while (lpNodeLocation.isOfCategory(601008) && lpNodeLocation.getParent().isOfCategory(601008)) {
            lpNodeLocation = lpNodeLocation.getParent();
        }
        IXQEQueryNode[] v5DataItemRefs = node.getChildren();
        for (int i = 0; i < v5DataItemRefs.length; ++i) {
            v5DataItemRef = (V5DataItemRef)v5DataItemRefs[i];
            v5DataItemRefv5DataItem = v5Query.getV5Selection().getDataItemByRefName(v5DataItemRef.getDataItemRefProperty());
            IXQEQueryNode identifier = v5DataItemRefv5DataItem.getChild(0);
            String identifierName = null;
            identifierName = identifier.getType() == 101003 ? ((V5DataItem)identifier).getNameProperty() : v5DataItemRefv5DataItem.getNameProperty();
            RSAPIEdgeRowset rowset = null;
            RSAPIDataItem dataItem = null;
            for (int idx = 0; idx < nests.size(); ++idx) {
                IXQEQueryNode nest = nests.get(idx);
                String refDataItem = (String)nest.getPropertyValue("refDataItem");
                if (identifierName.compareTo(refDataItem) != 0) continue;
                if (nest.getType() == 1026) {
                    rowset = ((CogMDXNest)nest).getRSAPIEdgeRowset();
                    dataItem = ((CogMDXNest)nest).getFirstRSAPIDataItem();
                    break;
                }
                if (nest.getType() == 1027) {
                    rowset = ((CogMDXGroup)nest).getRSAPIEdgeRowset();
                    dataItem = ((CogMDXGroup)nest).getFirstRSAPIDataItem();
                    break;
                }
                rowset = ((V5ValueSet)nest).getRSAPIEdgeRowset();
                dataItem = ((V5ValueSet)nest).getRSAPIDataItem();
                break;
            }
            if (rowset == null) continue;
            V5ListReportSummary lpSummary = (V5ListReportSummary)nodeFactory.createNode(601019);
            V5ListReportSummaryRule lpSummaryRule = (V5ListReportSummaryRule)nodeFactory.createNode(601020);
            lpSummaryRule.setDetailRSAPIRowset(rowset);
            lpSummaryRule.setDetailDataItem(dataItem);
            rowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
            dataItem = (RSAPIDataItem)v5DataItemRef.getPropertyValue("RSAPIRefDataItem");
            if (dataItem.isCustomProperty()) {
                dataItem.setPropertyDataType(DoubleType.DOUBLETYPE);
            } else {
                dataItem.setDataType(DoubleType.DOUBLETYPE);
            }
            dataItem.setUsage(RSAPIUsage.FACT);
            lpSummaryRule.setRSAPIRowset(rowset);
            lpSummaryRule.setDataItem(dataItem);
            V5RollupAggregateEnum rollupAggregate = this.setLocalSummaryAggregationType(v5DataItemRefv5DataItem, lpSummaryRule, dataItem);
            lpSummaryRule.setSummaryForRSAPIRowset(valueSetRowset);
            lpSummaryRule.setSummaryForDataItem(valueSetDataItem);
            lpSummaryRule.setDistinctProperty(this.isDistinctRequired(rollupAggregate, v5DataItemRef));
            lpNodeLocation.insertParent(lpSummary);
            lpSummary.addChild(lpSummaryRule);
        }
        node.detach();
    }

    private V5RollupAggregateEnum setLocalSummaryAggregationType(V5DataItem v5DataItemRefv5DataItem, V5ListReportSummaryRule lpSummaryRule, RSAPIDataItem rsapiRefDataItem) {
        V5RollupAggregateEnum rollupAggregate = V5RollupAggregateEnum.valueOfV5String(v5DataItemRefv5DataItem.getRollupAggregateProperty());
        switch (rollupAggregate) {
            case MAXIMUM: {
                lpSummaryRule.setSummaryFunction("max");
                break;
            }
            case MINIMUM: {
                lpSummaryRule.setSummaryFunction("min");
                break;
            }
            case AVERAGE: {
                lpSummaryRule.setSummaryFunction("avg");
                break;
            }
            case COUNT_DISTINCT: 
            case COUNT: {
                if (rsapiRefDataItem.isCustomProperty()) {
                    rsapiRefDataItem.setPropertyDataType(IntegerType.INTEGERTYPE);
                } else {
                    rsapiRefDataItem.setDataType(IntegerType.INTEGERTYPE);
                }
                rsapiRefDataItem.setUsage(RSAPIUsage.FACT);
                lpSummaryRule.setSummaryFunction("count");
                break;
            }
            default: {
                lpSummaryRule.setSummaryFunction("sum");
            }
        }
        return rollupAggregate;
    }

    private boolean isDistinctRequired(V5RollupAggregateEnum rollupAggregate, V5DataItemRef v5DataItemRef) {
        boolean bDistinct = false;
        if (rollupAggregate == V5RollupAggregateEnum.COUNT_DISTINCT) {
            bDistinct = true;
        } else if (rollupAggregate == V5RollupAggregateEnum.COUNT && v5DataItemRef.getChild(0).isOfCategory(1021)) {
            bDistinct = true;
        }
        return bDistinct;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("summaryType") == null) {
            this.traceNodeCondition(false, "This node is not ready for summary generation.", trace);
            return false;
        }
        String key = "summaryType";
        if (node.getPropertyValue("summaryType") == "summaryMDX") {
            this.traceNodeCondition(false, "This node will be transformed to a MDX summary.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This node will be transformed to a local summary.", trace);
        return true;
    }
}

