/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.ArrayList;

public final class ConvertV5WithinDetailSummaryFunctionToMDXSummaryFunction
extends Transformation {
    public ConvertV5WithinDetailSummaryFunctionToMDXSummaryFunction() {
        this.mName = "ConvertV5WithinDetailSummaryFunctionToMDXSummaryFunction";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201032};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
        messageContext.add(node);
        V5ValueSet valueSet = (V5ValueSet)node.getAncestorOfType(101057);
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node.getChild(1);
        String refDataItemName = (String)withinClause.getPropertyValue("refDataItemName");
        CogMDXGroup matchingGroup = (CogMDXGroup)V5ToCogMDXUtilities.getReferencedSiblingOfType(1027, valueSet, refDataItemName, true);
        messageContext.add(matchingGroup);
        boolean isDetailItemMeasure = false;
        if (withinClause.getWithinClauseType() == 1) {
            AbstractMDXNode child = (AbstractMDXNode)withinClause.getChild(0);
            MDXHierInfo hierInfo = null;
            hierInfo = child.isOfCategory(1061) && !this.isSummaryExpression((AbstractMDXValueExpression)child) ? ((AbstractMDXValueExpression)child).getResolvedHierarchyInfo(child) : child.getHierarchyInfo();
            isDetailItemMeasure = hierInfo.projectsMeasures();
        }
        if (isDetailItemMeasure) {
            String summaryDataItemName = (String)valueSet.getPropertyValue("refDataItem");
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedWithinDetailReferenceMeasure, summaryDataItemName, refDataItemName, messageContext);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        if (!matchingGroup.getDetailProperty().equals("true")) {
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_AggregateWithinNonDetail, refDataItemName, messageContext);
            throw new XQEOlapUnsupportedQueryException(message);
        }
        valueSet.setIsReportSummary(refDataItemName);
        matchingGroup = (CogMDXGroup)nodeFactory.deepCopyNode(matchingGroup);
        V5ToCogMDXUtilities.removeGroupBodyMeasureGroupsFromDescendant(matchingGroup);
        AbstractMDXSet tNodeRemoveNonDetails = (AbstractMDXSet)nodeFactory.createNode(1139);
        withinClause.exchangeChildNode(withinClause.getChild(0), tNodeRemoveNonDetails);
        withinClause.extract();
        tNodeRemoveNonDetails.addChild(matchingGroup);
        MDXSummaryFunction summaryFunction = null;
        int v5SummaryFunctionType = ((V5MemberSummaryFunction)node).getSubType();
        MDXSummaryFunctionTypeEnum summaryType = MDXSummaryFunctionTypeEnum.convertV5SummaryFunctionTypeToMDXSummaryFunctionType(v5SummaryFunctionType);
        if (summaryType != MDXSummaryFunctionTypeEnum.AGGREGATE) {
            summaryFunction = (MDXSummaryFunction)nodeFactory.createNode(1060);
            summaryFunction.setSummaryType(summaryType);
        } else {
            summaryFunction = (MDXSummaryFunction)nodeFactory.createNode(1012);
        }
        summaryFunction.setIsWithinDetailCalc(true);
        node.getChild(1).move(summaryFunction);
        node.getChild(0).move(summaryFunction);
        summaryFunction.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        node.getParent().exchangeChildNode(node, summaryFunction, false);
        IXQEQueryNode[] cogMDXGroupNodes = summaryFunction.getChild(0).getDescendantsOfType(1027, true);
        for (int i = 0; i < cogMDXGroupNodes.length; ++i) {
            ((CogMDXGroup)cogMDXGroupNodes[i]).setProjectDetailsOnly();
        }
    }

    private boolean isSummaryExpression(AbstractMDXValueExpression valueExpr) {
        IXQEQueryNode[] children = valueExpr.getChildren();
        switch (valueExpr.getType()) {
            case 1060: {
                return true;
            }
            case 1084: {
                for (IXQEQueryNode child : children) {
                    if (this.isSummaryExpression((AbstractMDXValueExpression)child)) continue;
                    return false;
                }
                return true;
            }
            case 1085: {
                for (IXQEQueryNode child : children) {
                    if (child == children[0] || this.isSummaryExpression((AbstractMDXValueExpression)child)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5ValueSet valueSet = (V5ValueSet)node.getAncestorOfType(101057);
        if (node.getAncestorOfType(1002) != null && valueSet != null) {
            status = true;
            this.traceQueryCondition(status, "The V5 Value Expression is within a CogMDX query and a V5ValueSet.", trace);
        } else {
            this.traceQueryCondition(status, "The V5 Value Expression is not within a CogMDX query or a V5ValueSet.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int v5SummaryFunctionType = ((V5MemberSummaryFunction)node).getSubType();
        MDXSummaryFunctionTypeEnum summaryType = MDXSummaryFunctionTypeEnum.convertV5SummaryFunctionTypeToMDXSummaryFunctionType(v5SummaryFunctionType);
        if (summaryType == MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE) {
            this.traceNodeCondition(false, "The V5MemberSummaryFunction node type is either invalid or cannot beconverted to an MDXSummaryFunction type.", trace);
            return false;
        }
        if (V5ToCogMDXUtilities.isCoercableToNumericValueExpression(node.getChild(0)) && node.getChild(1).getType() == 201039) {
            V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node.getChild(1);
            V5ValueSet valueSet = (V5ValueSet)node.getAncestorOfType(101057);
            if (withinClause.getWithinClauseType() == 1) {
                IXQEQueryNode groupBody = node.getAncestorOfType(101051);
                if (groupBody == null) {
                    String refDataItemName = (String)withinClause.getPropertyValue("refDataItemName");
                    if (V5ToCogMDXUtilities.getReferencedSiblingOfType(1027, valueSet, refDataItemName, true) != null) {
                        status = true;
                        this.traceNodeCondition(status, "The expression is a within detail expression.", trace);
                    }
                } else {
                    String refDataItemName = (String)withinClause.getPropertyValue("refDataItemName");
                    ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
                    messageContext.add(groupBody);
                    XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedUseOfWithinDetailSummary, refDataItemName, groupBody);
                    throw new XQERuntimeException(message);
                }
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "It is not a supported within detail expression.", trace);
        }
        return status;
    }
}

