/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public final class ConvertV5WithinSetSummaryFunctionToMDXSummaryFunction
extends Transformation {
    public ConvertV5WithinSetSummaryFunctionToMDXSummaryFunction() {
        this.mName = "Convert V5MemberSummaryFunction with 'within set' to MDXSummaryFunction.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201032};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node.getChild(1);
        Object detailPaths = withinClause.getPropertyValue("detailPaths");
        node.getChild(1).extract();
        MDXSummaryFunction summaryFunction = null;
        int v5SummaryFunctionType = ((V5MemberSummaryFunction)node).getSubType();
        MDXSummaryFunctionTypeEnum summaryType = MDXSummaryFunctionTypeEnum.convertV5SummaryFunctionTypeToMDXSummaryFunctionType(v5SummaryFunctionType);
        if (summaryType != MDXSummaryFunctionTypeEnum.AGGREGATE) {
            summaryFunction = (MDXSummaryFunction)factory.createNode(1060);
            summaryFunction.setSummaryType(summaryType);
        } else {
            summaryFunction = (MDXSummaryFunction)factory.createNode(1012);
        }
        if (detailPaths != null) {
            summaryFunction.setPropertyValue("detailPaths", detailPaths);
        }
        node.getChild(1).move(summaryFunction);
        node.getChild(0).move(summaryFunction);
        summaryFunction.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        node.getParent().exchangeChildNode(node, summaryFunction, false);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getAncestorOfType(1002) != null) {
            this.traceQueryCondition(true, "The node is a descendant of an MDXQuery node.", environment.getTrace());
            return true;
        }
        this.traceQueryCondition(false, "The node is a not a descendant of an MDXQuery node.", environment.getTrace());
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "Invalid number of children for the member function.", trace);
            return false;
        }
        if (!V5ToCogMDXUtilities.isCoercableToNumericValueExpression(node.getChild(0))) {
            this.traceNodeCondition(false, "Invalid first argument expression type.", trace);
            return false;
        }
        V5AggregateWithinClause withinClause = (V5AggregateWithinClause)node.getChild(1);
        if (node.getChild(1).getType() != 201039 || withinClause.getWithinClauseType() != 0) {
            this.traceNodeCondition(false, "The second child of the member function is not within set.", trace);
            return false;
        }
        if (withinClause.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The within set summary function has more than one specified set, which must be handled by another transformation first.", trace);
            return false;
        }
        if (!withinClause.getChild(0).isOfCategory(1021)) {
            this.traceNodeCondition(false, "Invalid argument expression type.", trace);
            return false;
        }
        int v5SummaryType = ((V5MemberSummaryFunction)node).getSubType();
        MDXSummaryFunctionTypeEnum summaryType = MDXSummaryFunctionTypeEnum.convertV5SummaryFunctionTypeToMDXSummaryFunctionType(v5SummaryType);
        if (summaryType == MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE) {
            this.traceNodeCondition(false, "The type of the V5MemberSummaryFunction is unsupported or invalid.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The within set summary function can be replaced.", trace);
        return true;
    }
}

