/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.handlingreplicas.RemoveReplicasFromGroupBodyHeaderFooter;
import com.cognos.xqe.transformation.v5exptomdxexp.summary.IdentifyV5SummaryTypeforLocalSummary;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.List;

public class IdentifyV5GroupHeaderFooterTypes
extends AbstractV5ToCogMDXTransformation {
    public static final String PROPERTY_SUMMARY_TYPE = "summaryType";
    public static final String PROPERTY_SUMMARY_LOCAL = "summaryLocal";
    public static final String PROPERTY_SUMMARY_MDX = "summaryMDX";

    public IdentifyV5GroupHeaderFooterTypes() {
        this.mName = "Identify V5 Group Header/Footer reday for summary generation, local or mdx.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101053, 101052};
    }

    private boolean isSupportedRollupAggregate(V5DataItemRef v5DataItemRef, V5DataItem v5DataItem, boolean localSummary) {
        IMember iMember;
        IXQEQueryNode theDataItemRef = v5DataItemRef.getChild(0);
        String rollupAggregateProperty = v5DataItem.getRollupAggregateProperty();
        if (null == rollupAggregateProperty) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "header or footer item has no rollupAggregate");
        }
        V5RollupAggregateEnum rollupAggregate = V5RollupAggregateEnum.valueOfV5String(rollupAggregateProperty);
        MDXQuery mdxQuery = (MDXQuery)v5DataItemRef.getAncestorOfType(1002);
        if (this.requiresLocalAggr(mdxQuery) && rollupAggregate == V5RollupAggregateEnum.CALCULATED) {
            IXQEQueryNode detailNode = v5DataItemRef.getChild(0);
            if (!detailNode.isOfCategory(1022)) {
                return false;
            }
            rollupAggregate = IdentifyV5SummaryTypeforLocalSummary.getRollupAggregate(mdxQuery, v5DataItemRef, v5DataItem);
        }
        if (!theDataItemRef.isOfCategory(1062) && !V5ToCogMDXUtilities.isCoercableToNumericValueExpression(theDataItemRef)) {
            if (rollupAggregate != V5RollupAggregateEnum.COUNT && rollupAggregate != V5RollupAggregateEnum.COUNT_DISTINCT) {
                return false;
            }
            if (theDataItemRef.isOfCategory(1116)) {
                BaseProperty baseProperty = (BaseProperty)theDataItemRef.getChild(1);
                if (baseProperty.getPropertyMetadata() != null) {
                    IQueryItem property = baseProperty.getPropertyMetadata();
                    if (localSummary && property.isBusinessKey()) {
                        return true;
                    }
                }
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedAggregateAttribute, rollupAggregate.getName(), (String)v5DataItemRef.getPropertyValue("refDataItem"));
            }
        }
        return theDataItemRef.getType() != 1067 || null == (iMember = ((BaseMember)theDataItemRef).getMember()) || iMember.getDataType().isNumeric() || rollupAggregate == V5RollupAggregateEnum.COUNT;
    }

    public boolean requiresLocalAggr(MDXQuery mdxQuery) {
        return DataSourceTypeEnum.isEssbase(mdxQuery.getMDXFrom().getDataSourceType()) || DataSourceTypeEnum.isSAPBW(mdxQuery.getMDXFrom().getDataSourceType());
    }

    private boolean isSupportedLocalProcessingFooter(IXQEQueryNode node, PlanningEnvironment environment, MDXQuery mdxQuery) {
        RSAPIEdgeRowset rowSet;
        String refQuery = mdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        IXQEQueryNode valueSet = node.getParent();
        boolean unhandledCase = false;
        RSAPIEdgeRowset headerRowset = rowSet.getHeaderRowset();
        for (rowSet = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset"); !(rowSet == null || headerRowset != null && headerRowset.isEmpty()); rowSet = rowSet.getParentRowset()) {
            headerRowset = rowSet.getHeaderRowset();
        }
        boolean bl = unhandledCase = headerRowset != null && headerRowset.isEmpty();
        if (unhandledCase) {
            List<IXQEQueryNode> sets = valueSet.getDescendantsOfCategory(1021, false);
            for (IXQEQueryNode set : sets) {
                MDXHierInfo hierInfo = ((AbstractMDXSet)set).getHierarchyInfo();
                if (hierInfo == null || hierInfo.getNumberOfNonMeasureHierarchiesProjected() <= 0) continue;
                unhandledCase = false;
                break;
            }
        }
        if (unhandledCase) {
            IXQEQueryNode[] headerFooters;
            for (IXQEQueryNode headerFooter : headerFooters = mdxQuery.getDescendantsOfTypes(new int[]{101053, 101052}, false)) {
                if (headerFooter == node) continue;
                headerFooter.setPropertyValue(PROPERTY_SUMMARY_TYPE, PROPERTY_SUMMARY_MDX);
            }
            return false;
        }
        int[] types = new int[]{1026, 1027};
        List<IXQEQueryNode> nests = valueSet.getDescendantsOfTypesOrdered(types, false);
        nests.addAll(mdxQuery.getDescendantsOfTypeOrdered(101057, false));
        boolean localSummary = IdentifyV5GroupHeaderFooterTypes.doLocalV5Summary(mdxQuery, environment);
        for (IXQEQueryNode v5DataItemRef : node.getChildren()) {
            V5DataItem v5DataItem = v5Query.getV5Selection().getDataItemByRefName(((V5DataItemRef)v5DataItemRef).getDataItemRefProperty());
            if (!this.isSupportedRollupAggregate((V5DataItemRef)v5DataItemRef, v5DataItem, localSummary)) {
                return false;
            }
            IXQEQueryNode theDataItemRef = v5DataItem.getChild(0);
            String identifierName = null;
            identifierName = theDataItemRef.getType() == 101003 ? ((V5DataItem)theDataItemRef).getNameProperty() : v5DataItem.getNameProperty();
            boolean isProjectedDetail = false;
            for (int idx = 0; idx < nests.size(); ++idx) {
                String refDataItem = (String)nests.get(idx).getPropertyValue("refDataItem");
                if (refDataItem == null || identifierName.compareTo(refDataItem) != 0) continue;
                isProjectedDetail = true;
                break;
            }
            if (isProjectedDetail) continue;
            return false;
        }
        return true;
    }

    public static boolean doLocalV5Summary(IXQEQueryNode cogMDXQueryNode, PlanningEnvironment environment) {
        IDataSourceCapabilities capabilities = ((MDXQuery)cogMDXQueryNode).getCapabilities();
        if (!capabilities.isSupported("v5.summary.local")) {
            return false;
        }
        String location = capabilities.getStringValue("v5.summary.location", "remote");
        return location.equals("balance") || location.equals("local");
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        boolean supportedLocalProcessingFooter = this.isSupportedLocalProcessingFooter(node, environment, mdxQuery);
        if (node.getType() == 101052 && mdxQuery.hasSupportedRollupTypeOnly().equals(Boolean.TRUE) && supportedLocalProcessingFooter) {
            node.setPropertyValue(PROPERTY_SUMMARY_TYPE, PROPERTY_SUMMARY_LOCAL);
        } else {
            node.setPropertyValue(PROPERTY_SUMMARY_TYPE, PROPERTY_SUMMARY_MDX);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROPERTY_SUMMARY_TYPE) != null) {
            this.traceNodeCondition(false, "The transformation was already applied.", trace);
            return false;
        }
        if (RemoveReplicasFromGroupBodyHeaderFooter.queryCondition(node, environment, null) && RemoveReplicasFromGroupBodyHeaderFooter.nodeCondition(node, null)) {
            this.traceNodeCondition(false, "Apply first RemoveReplicasFromGroupBodyHeaderFooter.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.hasSupportedRollupTypeOnly() == null) {
            this.traceNodeCondition(false, "Need to resolve the v5 summary type firt.", trace);
            return false;
        }
        IXQEQueryNode valueSet = node.getParent();
        if (valueSet.getType() != 101057) {
            this.traceNodeCondition(false, "The parent node is not a V5 Value Set.", trace);
            return false;
        }
        IXQEQueryNode grandParent = valueSet.getParent();
        if (grandParent.getType() == 101058) {
            this.traceNodeCondition(false, "The grandparent node is V5 Sort.", trace);
            return false;
        }
        if (valueSet.getDescendantsOfTypeOrdered(101057, false).size() > 0) {
            this.traceNodeCondition(false, "There is nested detail valueSet to be processed.", trace);
            return false;
        }
        if (node.getNumberChildren() == 0) {
            this.traceQueryCondition(false, "This node has no child.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This node is ready for summary generation, as a local or mdx summary.", trace);
        return true;
    }
}

