/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5exptomdxexp.summary.IdentifyV5GroupHeaderFooterTypes;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class IdentifyV5SummaryTypeforLocalSummary
extends AbstractV5ToCogMDXTransformation {
    public IdentifyV5SummaryTypeforLocalSummary() {
        this.mName = "Identify V5 Group Header/Footer reday for summary generation, local or mdx localSummary.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1002};
    }

    public static V5RollupAggregateEnum getRollupAggregate(MDXQuery mdxQuery, V5DataItemRef v5DataItemRef, V5DataItem v5DataItem) {
        String rollupAggregateProperty = v5DataItem.getRollupAggregateProperty();
        if (null == rollupAggregateProperty) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "header or footer item has no rollupAggregate");
        }
        V5RollupAggregateEnum rollupAggregate = V5RollupAggregateEnum.valueOfV5String(rollupAggregateProperty);
        AbstractMDXMember measure = null;
        IXQEQueryNode detailNode = v5DataItemRef.getChild(0);
        if (IdentifyV5SummaryTypeforLocalSummary.requiresLocalAggr(mdxQuery) && rollupAggregate == V5RollupAggregateEnum.CALCULATED && detailNode.isOfCategory(1022)) {
            MDXSummaryFunctionTypeEnum aggregateTypeOfThisMeasure;
            measure = (AbstractMDXMember)detailNode;
            IXQEQueryNode headerfooter = v5DataItemRef.getParent();
            IXQEQueryNode headerFooterValueSet = headerfooter.getParent();
            IXQEQueryNode outerValueSet = headerFooterValueSet.getAncestorOfType(101057);
            MDXHierInfo hierInfo = null;
            IXQEQueryNode detail = null;
            if (outerValueSet == null) {
                outerValueSet = headerFooterValueSet;
            }
            for (IXQEQueryNode child : outerValueSet.getChildren()) {
                if (child.getType() == 101053 || child.getType() == 101052 || child.getType() == 101056) continue;
                detail = child;
                break;
            }
            hierInfo = ((AbstractMDXNode)detail).getHierarchyInfo();
            if (measure.getType() == 1067 && ((aggregateTypeOfThisMeasure = ((BaseMember)measure).getSummaryFunctionType(hierInfo)) == MDXSummaryFunctionTypeEnum.SUM || aggregateTypeOfThisMeasure == MDXSummaryFunctionTypeEnum.MAXIMUM || aggregateTypeOfThisMeasure == MDXSummaryFunctionTypeEnum.MINIMUM)) {
                return IdentifyV5SummaryTypeforLocalSummary.convertMDXSummaryFunctionTypeToRollupAggregate(aggregateTypeOfThisMeasure);
            }
        }
        return rollupAggregate;
    }

    public static boolean requiresLocalAggr(MDXQuery mdxQuery) {
        return DataSourceTypeEnum.isEssbase(mdxQuery.getMDXFrom().getDataSourceType()) || DataSourceTypeEnum.isSAPBW(mdxQuery.getMDXFrom().getDataSourceType());
    }

    public static V5RollupAggregateEnum convertMDXSummaryFunctionTypeToRollupAggregate(MDXSummaryFunctionTypeEnum rollupSummaryType) {
        V5RollupAggregateEnum summaryType = V5RollupAggregateEnum.UNDEFINED;
        switch (rollupSummaryType) {
            case AGGREGATE: {
                summaryType = V5RollupAggregateEnum.UNDEFINED;
                break;
            }
            case SUM: {
                summaryType = V5RollupAggregateEnum.TOTAL;
                break;
            }
            case MINIMUM: {
                summaryType = V5RollupAggregateEnum.MINIMUM;
                break;
            }
            case MAXIMUM: {
                summaryType = V5RollupAggregateEnum.MAXIMUM;
                break;
            }
            case AVERAGE: {
                summaryType = V5RollupAggregateEnum.AVERAGE;
                break;
            }
            case MEDIAN: {
                summaryType = V5RollupAggregateEnum.MEDIAN;
                break;
            }
            case STANDARD_DEVIATION: {
                summaryType = V5RollupAggregateEnum.STANDARD_DEVIATION;
                break;
            }
            case VARIANCE: {
                summaryType = V5RollupAggregateEnum.VARIANCE;
                break;
            }
            default: {
                summaryType = V5RollupAggregateEnum.CALCULATED;
            }
        }
        return summaryType;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5RollupAggregateEnum rollupAggregate;
        V5DataItem v5DataItem;
        IXQEQueryNode v5DataItemRef;
        int j;
        IXQEQueryNode[] v5DataItemRefs;
        IXQEQueryNode currentFooterHeader;
        int i;
        MDXQuery mdxQuery = (MDXQuery)node;
        String refQuery = mdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        boolean isSupportedRollupAggregate = IdentifyV5GroupHeaderFooterTypes.doLocalV5Summary(mdxQuery, environment);
        int[] v5NodeTypes = new int[]{101053, 101052};
        IXQEQueryNode[] footersAndHeaders = mdxQuery.getDescendantsOfTypes(v5NodeTypes, false);
        if (mdxQuery.isSuppressNulls() || mdxQuery.getSuppressNulls() == null && mdxQuery.getSuppressNullsProviderDefault()) {
            for (i = 0; i < footersAndHeaders.length && !isSupportedRollupAggregate; ++i) {
                currentFooterHeader = footersAndHeaders[i];
                v5DataItemRefs = currentFooterHeader.getChildren();
                for (j = 0; j < v5DataItemRefs.length && !isSupportedRollupAggregate; ++j) {
                    v5DataItemRef = v5DataItemRefs[j];
                    v5DataItem = v5Query.getV5Selection().getDataItemByRefName(((V5DataItemRef)v5DataItemRef).getDataItemRefProperty());
                    rollupAggregate = IdentifyV5SummaryTypeforLocalSummary.getRollupAggregate(mdxQuery, (V5DataItemRef)v5DataItemRef, v5DataItem);
                    if (rollupAggregate != V5RollupAggregateEnum.COUNT && rollupAggregate != V5RollupAggregateEnum.COUNT_DISTINCT) continue;
                    V5ExpressionTypeEnum exprType = V5ExpressionCheck.getExpressionType(v5DataItem);
                    isSupportedRollupAggregate = exprType == V5ExpressionTypeEnum.SET || exprType == V5ExpressionTypeEnum.HIERARCHY || exprType == V5ExpressionTypeEnum.LEVEL || exprType == V5ExpressionTypeEnum.MEMBER;
                }
            }
        }
        if (v5Query.getPropertyValue("queryUsesBridge") == Boolean.TRUE) {
            isSupportedRollupAggregate = true;
        }
        for (i = 0; i < footersAndHeaders.length && isSupportedRollupAggregate; ++i) {
            currentFooterHeader = footersAndHeaders[i];
            v5DataItemRefs = currentFooterHeader.getChildren();
            for (j = 0; j < v5DataItemRefs.length && isSupportedRollupAggregate; ++j) {
                v5DataItemRef = v5DataItemRefs[j];
                v5DataItem = v5Query.getV5Selection().getDataItemByRefName(((V5DataItemRef)v5DataItemRef).getDataItemRefProperty());
                rollupAggregate = IdentifyV5SummaryTypeforLocalSummary.getRollupAggregate(mdxQuery, (V5DataItemRef)v5DataItemRef, v5DataItem);
                isSupportedRollupAggregate = rollupAggregate == V5RollupAggregateEnum.TOTAL || rollupAggregate == V5RollupAggregateEnum.MAXIMUM || rollupAggregate == V5RollupAggregateEnum.MINIMUM || rollupAggregate == V5RollupAggregateEnum.AVERAGE || rollupAggregate == V5RollupAggregateEnum.COUNT || rollupAggregate == V5RollupAggregateEnum.COUNT_DISTINCT;
            }
        }
        mdxQuery.setSupportedRollupTypeOnly(isSupportedRollupAggregate);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.hasSupportedRollupTypeOnly() != null) {
            this.traceNodeCondition(false, "The v5 summary type is already solved.", trace);
            return false;
        }
        int[] v5NodeTypes = new int[]{101053, 101052};
        IXQEQueryNode[] footersAndHeaders = mdxQuery.getDescendantsOfTypes(v5NodeTypes, false);
        if (footersAndHeaders.length == 0) {
            this.traceNodeCondition(false, "There is no footer or header in the MDXQuery.", trace);
            return false;
        }
        String refQuery = mdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        for (int i = 0; i < footersAndHeaders.length; ++i) {
            IXQEQueryNode currentFooterHeader = footersAndHeaders[i];
            IXQEQueryNode valueSet = currentFooterHeader.getParent();
            IXQEQueryNode detailExpr = valueSet.getChild(0);
            int nodeType = detailExpr.getType();
            if (nodeType == 101053 || nodeType == 1080) {
                if (valueSet.getNumberChildren() <= 1) continue;
                detailExpr = valueSet.getChild(1);
                nodeType = detailExpr.getType();
            }
            if (nodeType == 101052 || nodeType == 1080) continue;
            if (!detailExpr.isOfCategory(1021)) {
                this.traceNodeCondition(false, "The V5ValueSet node has invalid child node expression.", trace);
                return false;
            }
            for (IXQEQueryNode v5DataItemRef : currentFooterHeader.getChildren()) {
                if (v5DataItemRef.getNumberChildren() != 1) {
                    this.traceNodeCondition(false, "The target node has a V5DataItemRef child node without a single child node.", trace);
                    return false;
                }
                if (!v5DataItemRef.getChild(0).isOfCategory(1001)) {
                    this.traceNodeCondition(false, "The target node has a V5DataItemRef child node whose child is not an AbstractMDXNode.", trace);
                    return false;
                }
                V5DataItem v5DataItem = v5Query.getV5Selection().getDataItemByRefName(((V5DataItemRef)v5DataItemRef).getDataItemRefProperty());
                if (v5DataItem != null && v5DataItem.getNumberChildren() != 0) continue;
                this.traceNodeCondition(false, "The target node has a V5DataItemRef that refers no data item.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "This node is ready for summary generation, as a local or mdx summary.", trace);
        return true;
    }
}

