/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public final class RemoveIsReportSummaryOnV5ValueSet
extends Transformation {
    public RemoveIsReportSummaryOnV5ValueSet() {
        this.mName = "Remove is report summary on V5 value set when matching group cannot be identified.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5ValueSet valueSet = (V5ValueSet)node;
        valueSet.clearIsReportSummary();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status = true;
        V5ValueSet valueSet = (V5ValueSet)node;
        boolean bl = status = valueSet.isReportSummary() != null;
        if (!status) {
            this.traceQueryCondition(status, "The V5ValueSet node is not a report summary.", environment.getTrace());
            return status;
        }
        this.traceQueryCondition(status, "The V5ValueSet node is as a report summary.", environment.getTrace());
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode matchingValueSet;
        boolean status = true;
        XQETrace trace = environment.getTrace();
        boolean bl = status = node.getDescendantsOfCategory(101064, false).size() == 0;
        if (!status) {
            this.traceNodeCondition(false, "The V5ValueSet contains unresolved descendant V5 nodes.", trace);
            return status;
        }
        IXQEQueryNode firstExpression = V5ToCogMDXUtilities.getChildOverSet(node.getChild(0), 1039);
        if (firstExpression.getType() == 1013) {
            boolean bl2 = status = !((MDXCalculatedMemberReference)firstExpression).getHierarchy().isShell();
            if (!status) {
                this.traceNodeCondition(false, "The summary's hierarchy have not been resolved yet.", trace);
                return status;
            }
        }
        V5ValueSet valueSet = (V5ValueSet)node;
        String refDataItemName = valueSet.isReportSummary();
        boolean bl3 = status = node.getNumberChildren() >= 1;
        if (!status) {
            node.throwInternalError("The V5ValueSet does not define an expression.");
        }
        boolean bl4 = status = (matchingValueSet = V5ToCogMDXUtilities.getReferencedSiblingOfType(101057, valueSet, refDataItemName, false)) == null;
        if (status) {
            matchingValueSet = V5ToCogMDXUtilities.getReferencedNodeOfType(101057, valueSet, refDataItemName, false);
            boolean bl5 = status = matchingValueSet == null;
        }
        if (!status) {
            this.traceNodeCondition(status, "The referenced valueset has not been converted to a group yet.", trace);
            return status;
        }
        IXQEQueryNode matchingGroup = V5ToCogMDXUtilities.getReferencedSiblingOfType(1027, valueSet, refDataItemName, false);
        boolean bl6 = status = matchingGroup == null;
        if (!status) {
            this.traceNodeCondition(status, "The V5ValueSet has isReportSummary and the referenced group or valueset can be identified.", trace);
            return status;
        }
        this.traceNodeCondition(status, "The V5ValueSet has isReportSummary and referenced group cannot be identified.", trace);
        return status;
    }
}

