/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.summary.todeprecate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.util.ASTUtil;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import java.util.ArrayList;

public final class ConvertMultipleWithinSetOperandsFromSameHierToSingleSet
extends Transformation {
    public ConvertMultipleWithinSetOperandsFromSameHierToSingleSet() {
        this.mName = "Convert multiple 'within set' operands from the same hierarchy to a single set.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201039};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem dataItem = (V5DataItem)ASTUtil.getFirstNodeOfTypeFromAncestorQueryLineage(node, 101003);
        String param = null;
        param = dataItem == null ? "unknown" : dataItem.getNameProperty();
        throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_WithinSetMultipleOperands, param);
    }

    IHierarchy getSameHierarchy(IXQEQueryNode node, XQETrace trace) {
        IXQEQueryNode[] children = node.getChildren();
        IHierarchy hierarchy = null;
        ArrayList<IHierarchy> hierarchies = new ArrayList<IHierarchy>();
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode child = children[i];
            if (!child.isOfCategory(1021)) {
                if (trace != null) {
                    this.traceNodeCondition(false, "One of the child nodes cannot be coerced to an AbstractMDXSet node.", trace);
                }
                return null;
            }
            AbstractMDXNode set = (AbstractMDXNode)child;
            MDXHierInfo hierInfo = set.getHierarchyInfo();
            if (hierInfo.getNumProjectedHierarchies() != 1) {
                if (trace != null) {
                    this.traceNodeCondition(false, "One of the child nodes does not project 1 hierarchy.", trace);
                }
                return null;
            }
            if (hierarchies.contains(hierInfo.getProjectedHierarchy(0))) {
                hierarchy = hierInfo.getProjectedHierarchy(0);
            }
            hierarchies.add(hierInfo.getProjectedHierarchy(0));
        }
        return hierarchy;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The V5AggregateWithinClause does not have an ancestor MDXQuery node.", trace);
            return false;
        }
        if (node.getNumberChildren() <= 1) {
            this.traceNodeCondition(false, "The V5AggregateWithinClause has 1 or less children.", trace);
            return false;
        }
        IHierarchy hierarchy = this.getSameHierarchy(node, trace);
        if (hierarchy == null) {
            this.traceNodeCondition(true, "All children of the within set clause are from different hierarchies.", trace);
            return false;
        }
        this.traceNodeCondition(true, "An MDXSet node can be wrapped around children of the WITHIN SET node.", trace);
        return true;
    }
}

