/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5exptomdxexp.validation;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public final class ValidateSecondArgForV5RoleValueFunction
extends Transformation {
    public ValidateSecondArgForV5RoleValueFunction() {
        this.mName = "Validate the second argument for roleValue function.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{201098};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidArgumentForRoleValueFunction);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() != 2) {
            this.traceQueryCondition(false, "The V5RoleValueFunction does not have 2 arguments.", trace);
            return false;
        }
        MDXHierInfo hierInfo = ((V5SimpleNode)node).getHierarchyInfo();
        List<IHierarchy> hierarchies = hierInfo.getProjectedHierarchies();
        for (IHierarchy hierarchy : hierarchies) {
            if (!hierarchy.getDimension().isMeasuresDimension()) continue;
            if (((V5RoleValueFunction)node).getRoleType() == RoleTypeEnum.MEMBER_CAPTION) {
                if (V5ExpressionCheck.isMemberExpression(node.getChild(1))) continue;
                this.traceQueryCondition(true, "The V5RoleValueFunction node has an invalid use of the measures dimension.", trace);
                return true;
            }
            this.traceQueryCondition(true, "The V5RoleValueFunction node is invalid.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The V5RoleValueFunction node is valid.", trace);
        return false;
    }
}

