/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5EmptySetFunction;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.data.types.LevelType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import java.util.ArrayList;
import java.util.List;

public final class CheckForNestedMembersResultingInEmptySet
extends AbstractV5ToCogMDXTransformation {
    public CheckForNestedMembersResultingInEmptySet() {
        this.mName = "Check for nested members from the same level that do not intersect.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean isOnlyChild;
        String dataItemName1 = ((V5ValueSet)node.getChild(0)).getRefDataItemProperty();
        String dataItemName2 = ((V5ValueSet)node.getParent().getChild(0)).getRefDataItemProperty();
        int aSeverity = 1;
        environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_EmptyNestingOnEdge, dataItemName2, dataItemName1));
        V5EdgeGroup currentGroup = (V5EdgeGroup)node;
        boolean bl = isOnlyChild = currentGroup.getParent().getChildrenOfType(101050).length == 1;
        while (isOnlyChild && currentGroup.getParent().getType() == 101050) {
            isOnlyChild = (currentGroup = (V5EdgeGroup)currentGroup.getParent()).getParent().getChildrenOfType(101050).length == 1;
        }
        if (!isOnlyChild) {
            currentGroup.detach();
        } else {
            IXQEQueryNode member;
            XQENodeFactory factory = environment.getNodeFactory();
            V5EmptySetFunction emptySet = (V5EmptySetFunction)factory.createNode(201063);
            V5BoundModelIdentifier hierarchyNode = (V5BoundModelIdentifier)factory.createNode(201116);
            V5ValueSet vs = (V5ValueSet)node.getChild(0);
            IXQEQueryNode childExpr = vs.getChild(0);
            if (childExpr.getType() == 101003) {
                childExpr = childExpr.getChild(0);
            }
            if ((member = childExpr.getChild(0)).getType() == 101003) {
                member = member.getChild(0);
            }
            IHierarchy hierarchy = ((V5BoundMemberUniqueName)member).getHierarchy();
            hierarchyNode.setMetadata(hierarchy);
            hierarchyNode.setIdentifier(hierarchy.getV5UniqueName());
            emptySet.addChild(hierarchyNode);
            currentGroup.exchange(emptySet, false);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean isOnlyChild;
        XQETrace trace = environment.getTrace();
        V5EdgeGroup group = (V5EdgeGroup)node;
        if (group.getParent() == null || group.getParent().getType() != 101050) {
            this.traceNodeCondition(false, "Group is not nested.", trace);
            return false;
        }
        if (group.getNumberChildren() < 1) {
            this.traceNodeCondition(false, "Group has no children.", trace);
            return false;
        }
        if (group.getAncestorOfType(101049) == null) {
            this.traceNodeCondition(false, "Group is not on an edge.", trace);
            return false;
        }
        if (group.getChild(0).getType() != 101057 || group.getChild(0).getNumberChildren() != 1) {
            this.traceNodeCondition(false, "Group does not consist of a value set with exactly one child.", trace);
            return false;
        }
        List<V5BoundMemberUniqueName> muns = this.getBoundMemberUniqueNamesInValueSet((V5ValueSet)group.getChild(0));
        if (muns == null) {
            this.traceNodeCondition(false, "Group does contain a set of MUNs from a single level", trace);
            return false;
        }
        if (group.getParent().getChild(0).getType() != 101057) {
            this.traceNodeCondition(false, "Parent group has no value set.", trace);
            return false;
        }
        List<V5BoundMemberUniqueName> parentMuns = this.getBoundMemberUniqueNamesInValueSet((V5ValueSet)group.getParent().getChild(0));
        if (parentMuns == null) {
            this.traceNodeCondition(false, "parent group does contain a set of MUNs from a single level", trace);
            return false;
        }
        if (!muns.get(0).getMetadata().equals(parentMuns.get(0).getMetadata())) {
            this.traceNodeCondition(false, "Parent MUNs are not from the same level.", trace);
            return false;
        }
        for (V5BoundMemberUniqueName parentMun : parentMuns) {
            for (V5BoundMemberUniqueName mun : muns) {
                if (!parentMun.isSameExpression(mun, false)) continue;
                this.traceNodeCondition(false, "The two sets of members intersect", trace);
                return false;
            }
        }
        V5EdgeGroup currentGroup = (V5EdgeGroup)node;
        boolean bl = isOnlyChild = currentGroup.getParent().getChildrenOfType(101050).length == 1;
        while (isOnlyChild && currentGroup.getParent().getType() == 101050) {
            isOnlyChild = (currentGroup = (V5EdgeGroup)currentGroup.getParent()).getParent().getChildrenOfType(101050).length == 1;
        }
        if (isOnlyChild && currentGroup.getParent().getType() != 101049) {
            this.traceNodeCondition(false, "There is something wrong with the edge nesting.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation should be applied.", trace);
        return true;
    }

    private List<V5BoundMemberUniqueName> getBoundMemberUniqueNamesInValueSet(V5ValueSet valueSet) {
        if (valueSet.getNumberChildren() != 1) {
            return null;
        }
        IXQEQueryNode childExpr = valueSet.getChild(0);
        if (childExpr.getType() == 101003) {
            if (childExpr.getNumberChildren() != 1) {
                return null;
            }
            childExpr = childExpr.getChild(0);
        }
        if (childExpr.getType() != 201101) {
            return null;
        }
        V5SetFunction set = (V5SetFunction)childExpr;
        ArrayList<V5BoundMemberUniqueName> munList = new ArrayList<V5BoundMemberUniqueName>();
        IMetadata metadata = null;
        for (IXQEQueryNode n : set.getChildren()) {
            IXQEQueryNode child = n;
            if (child.getType() == 101003) {
                child = child.getChild(0);
            }
            if (child.getType() != 201117) {
                return null;
            }
            IMetadata tmpMetadata = ((V5BoundMemberUniqueName)child).getMetadata();
            if (tmpMetadata.getDataType() != LevelType.LEVELTYPE) {
                return null;
            }
            if (metadata == null) {
                metadata = tmpMetadata;
            } else if (!metadata.equals(tmpMetadata)) {
                return null;
            }
            munList.add((V5BoundMemberUniqueName)child);
        }
        return munList;
    }
}

