/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.AbstractDataSource;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.TabStreamWrapper;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public final class CreateCogMDXQuery
extends Transformation {
    public CreateCogMDXQuery() {
        this.mName = "Convert QRD to CogMDX query";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] v5MemberSetReferences;
        RSAPIDataset parent;
        CubeWrapper cubeWrapper;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)nodeFactory.createNode(1002);
        MDXFromCube mdxFrom = (MDXFromCube)nodeFactory.createNode(1007);
        String refQuery = ((V5QueryResultDefinition)node).getRefQueryProperty();
        String qrdV5Name = (String)((V5QueryResultDefinition)node).getPropertyValue("name");
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        mdxQuery.setPropertyValue("isDMR", v5Query.isDMR());
        mdxQuery.setPropertyValue("shape", ((V5QueryResultDefinition)node).getShapeProperty());
        if (v5Query.getPropertyValue("REL_OVER_DMR") != null) {
            mdxQuery.setPropertyValue("REL_OVER_DMR", Boolean.TRUE);
        } else {
            mdxQuery.setPropertyValue("REL_OVER_DMR", Boolean.FALSE);
        }
        mdxQuery.setPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName(), v5Query.getPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName()));
        String dashboardHint = (String)v5Query.getPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName());
        if (dashboardHint != null) {
            mdxQuery.setGovernors(new Governors());
            mdxQuery.getGovernors().setInteractive();
        }
        int[] boundItemTypes = new int[]{201117, 201116};
        IXQEQueryNode[] boundItems = v5Query.getOriginalV5Query().getDescendantsOfTypes(boundItemTypes, false);
        IXQEQueryNode[] boundParameters = v5Query.getOriginalV5Query().getDescendantsOfType(201127, false);
        boolean hasNonLiteralParameter = false;
        for (IXQEQueryNode para : boundParameters) {
            if (((V5BoundParameter)para).isLiteral()) continue;
            hasNonLiteralParameter = true;
            break;
        }
        if (boundItems.length == 0 && !hasNonLiteralParameter) {
            mdxQuery.setIsConstantQuery();
        }
        ICube cube = null;
        V5Source source = (V5Source)v5Query.getFirstChildByType(101007);
        IXQEQueryNode[] sourceCubes = source.getChildrenOfType(1007);
        cube = sourceCubes.length > 0 ? ((MDXFromCube)sourceCubes[0]).getCube() : this.getCubeFromModelPath(nodeFactory, node, environment, mdxQuery);
        if (cube == null) {
            mdxFrom.bind(source.getModel());
        } else {
            mdxFrom.bind(cube);
        }
        if (cube instanceof CubeWrapper && (cubeWrapper = (CubeWrapper)cube).getGovernors() == null) {
            cubeWrapper.setGovernors(v5Query.getGovernors());
        }
        if ((parent = (RSAPIDataset)node.getAncestorOfType(401005)).isListReport()) {
            mdxQuery.setPropertyValue("isListReport", Boolean.TRUE);
        }
        parent.setForOLAPQuery(true);
        node.exchange(mdxQuery, true);
        mdxQuery.addChild(mdxFrom);
        mdxQuery.setRefQueryProperty(refQuery);
        mdxQuery.setV5NameProperty(qrdV5Name);
        if (!((V5QueryResultDefinition)node).isExecutionSupported()) {
            mdxQuery.setExecutionNotSupported();
        }
        if (v5Query.isSingleQueryMasterDetail()) {
            mdxQuery.setSingleQueryMasterDetail(true);
        }
        this.resolveDataSourceCapabilities(environment, mdxQuery, cube);
        if (cube != null && mdxQuery.getPropertyValue("useLocalQueryProcessing") == null) {
            if (!(cube instanceof CubeWrapper) && mdxQuery.isRemoteDatasourceOLAP()) {
                String providerCode = MetadataUtil.getProviderCode(cube);
                String queryProcessing = (String)v5Query.getPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName());
                boolean usesLocalEngine = true;
                if (DataSourceTypeEnum.isTM1(providerCode) && queryProcessing != null) {
                    XQEConfiguration config;
                    if (queryProcessing.equals("minimizeLocal")) {
                        v5Query.setPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName(), "limitedLocal");
                    }
                    boolean bl = usesLocalEngine = !(config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE)).getBooleanProperty("queryPlanning.enableTM1_101CompatibilityMode[@value]", false) || !queryProcessing.equals("databaseOnly");
                }
                if (usesLocalEngine) {
                    IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
                    mdxQuery.setUseLocalQueryProcessing(capabilities.isSupported("v5.useLocalOLAP"));
                }
            } else {
                mdxQuery.setUseLocalQueryProcessing(true);
            }
        }
        if ((v5MemberSetReferences = mdxQuery.getDescendantsOfType(201138, false)).length > 0) {
            mdxQuery.setPropertyValue("hasMemberSetReference", Boolean.TRUE);
        }
    }

    private void resolveDataSourceCapabilities(PlanningEnvironment environment, MDXQuery mdxQuery, ICube cube) {
        String queryDataSource = mdxQuery.getDataSourceType();
        IModelDataSource modelDS = cube.getModelDataSource();
        if (!modelDS.isDummy()) {
            MetadataConnection c = cube.getModelDataSource().getConnection();
            if (c == null) {
                c = environment.getMetadataConnection();
            }
            Locale locale = c.getContentLocale();
            RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
            ExecutionEnvironment executionEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
            IDataSource dataSource = executionEnv.getOrAddDataSource(modelDS);
            if (dataSource instanceof AbstractDataSource && cube instanceof CubeWrapper && (mdxQuery.isDMR() || mdxQuery.isRelationalStyleQuery() || mdxQuery.isRelationaCrosstab())) {
                try {
                    dataSource.getType();
                }
                catch (Exception e) {
                    ((AbstractDataSource)dataSource).setType(queryDataSource);
                }
            }
            IDataSourceCapabilities capabilities = null;
            if (DataSourceTypeEnum.isJDBC(dataSource.getType())) {
                try {
                    capabilities = ConnectionUtil.getCapabilitiesFromJDBCConnection(executionEnv, dataSource);
                }
                catch (Exception exception) {}
            } else {
                capabilities = ProviderCapabilites.getInstance().getOrAddDatasourceCapabilities(dataSource);
                if (capabilities == null) {
                    IDataProvider provider = ProviderManager.getInstance().getProvider(queryDataSource);
                    provider.resolveDataSourceCapabilities(executionEnv, dataSource, locale);
                }
            }
            if (capabilities != null) {
                dataSource.setCapabilities(capabilities);
            }
        } else {
            RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
            ExecutionEnvironment executionEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
            IDataSource dataSource = executionEnv.getOrAddDataSource(modelDS);
            ConnectionUtil.getCapabilitiesFromDummyDataSource(dataSource);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String refQuery = ((V5QueryResultDefinition)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = V5QuerySet.getRootQuerySet(environment, node);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        if (null == v5Query) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "CreateCogMDXQuery requires v5Query");
        }
        if (node.getNumberChildrenOfType(101049) > 1) {
            this.traceQueryCondition(true, "The QRD has more than one edge, planned as MDX query.", trace);
            return true;
        }
        V5Source source = (V5Source)v5Query.getChildrenOfType(101007)[0];
        Object o = source.getPropertyValue("relational");
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            this.traceQueryCondition(false, "Query is explicitly marked as being relational.", trace);
            return false;
        }
        if (!v5Query.isTabular()) {
            status = true;
            this.traceQueryCondition(status, "The MDX Query rely on a single cube, we could plan it.", trace);
        } else {
            this.traceQueryCondition(status, "The MDX Query belong to multiple cube, we need some query decomposition first or ...", trace);
        }
        return status;
    }

    private ICube getCubeFromModelPath(IXQENodeFactory nodeFactory, IXQEQueryNode node, PlanningEnvironment environment, MDXQuery mdxQuery) {
        ICube cube = null;
        String refQuery = ((V5QueryResultDefinition)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQuery);
        V5Source source = (V5Source)v5Query.getFirstChildByType(101007);
        Object flag = source.getPropertyValue("needTabularStream");
        if (flag != null && flag instanceof CubeWrapper) {
            cube = (ICube)flag;
            mdxQuery.setIsRelationalStyleQuery();
            source.removeProperty("needTabularStream");
        } else {
            boolean bUseTabStream = source.needQueryOverTabularStream();
            if (!bUseTabStream) {
                IMetadata metadata;
                IXQEQueryNode[] identifiers = v5Query.getOriginalV5Query().getDescendantsOfType(201116, false);
                IXQEQueryNode[] members = v5Query.getOriginalV5Query().getDescendantsOfType(201117, false);
                ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
                LinkedList<IMetadata> metadataRef = new LinkedList<IMetadata>();
                for (IXQEQueryNode identifier : identifiers) {
                    metadata = ((V5BoundModelIdentifier)identifier).getMetadata();
                    if (metadata == null) continue;
                    metadataRef.add(metadata);
                    messageContext.add(identifier);
                }
                for (IXQEQueryNode member : members) {
                    metadata = ((V5BoundMemberUniqueName)member).getMetadata();
                    if (metadata == null) continue;
                    metadataRef.add(metadata);
                    messageContext.add(member);
                }
                if (identifiers.length == 0 && members.length == 0) {
                    IXQEQueryNode[] parameters;
                    for (IXQEQueryNode parameter : parameters = v5Query.getOriginalV5Query().getDescendantsOfType(201127, false)) {
                        IMetadata metadata2 = ((V5BoundParameter)parameter).getMetadata();
                        if (metadata2 == null) continue;
                        metadataRef.add(metadata2);
                        messageContext.add(parameter);
                    }
                }
                for (IMetadata metadata3 : metadataRef) {
                    ICube metadataCube = MetadataUtil.getCube(metadata3);
                    if (metadataCube != null && cube == null) {
                        cube = metadataCube;
                        continue;
                    }
                    if (metadataCube == null || cube == null || cube == metadataCube) continue;
                    XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedQueryReferenceMultipleCubes, messageContext);
                    throw new XQERuntimeException(message);
                }
            } else if (mdxQuery.isConstantQuery()) {
                mdxQuery.setUseLocalQueryProcessing(true);
            }
            if (cube == null) {
                String modelPath = null;
                String modelType = null;
                IXQEQueryNode src = v5Query.getFirstChildByType(101007);
                boolean forceCreateCubeWrapper = bUseTabStream;
                if (!forceCreateCubeWrapper) {
                    int[] opTypes = new int[]{101018, 101019};
                    IXQEQueryNode[] ops = source.getChildrenOfTypes(opTypes);
                    boolean bl = forceCreateCubeWrapper = ops.length > 0;
                }
                if (src != null && (modelPath = (String)src.getPropertyValue("model")) != null && (modelPath = modelPath.trim()).length() == 0) {
                    modelPath = null;
                }
                if (modelPath == null && (modelPath = (String)v5QuerySet.getPropertyValue("modelPath")) != null && (modelPath = modelPath.trim()).length() == 0) {
                    modelPath = null;
                }
                modelType = (String)v5QuerySet.getPropertyValue("modelType");
                if (modelPath != null) {
                    ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
                    MetricsService.startCollectingMetric((RequestEnvironment)environment.getRequestEnvironment(), "mfwRequest");
                    MetadataConnection con = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(modelType, modelPath), modelPath, execEnv, true);
                    List<IModelDataSource> datasources = con.getModelDataSources();
                    boolean bl = forceCreateCubeWrapper = forceCreateCubeWrapper || v5Query.isDMR();
                    if (datasources.size() >= 1 && datasources.get(0).getCube() != null && !forceCreateCubeWrapper) {
                        cube = datasources.get(0).getCube();
                    } else {
                        cube = new CubeWrapper(con, node.getGovernors());
                        CubeWrapper theCubeWrapper = (CubeWrapper)cube;
                        theCubeWrapper.setDataSource(datasources.get(0));
                        mdxQuery.setIsRelationalStyleQuery();
                        if (bUseTabStream) {
                            TabStreamWrapper.updateV5DataItemsToWrapperLevels(environment, nodeFactory, v5QuerySet, (V5QueryResultDefinition)node, v5Query, theCubeWrapper, datasources);
                        }
                    }
                    MetricsService.endCollectingMetric((RequestEnvironment)environment.getRequestEnvironment(), "mfwRequest");
                }
            }
        }
        return cube;
    }
}

