/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class DisableDMRCubeReuseOnMDXQuery
extends Transformation {
    public DisableDMRCubeReuseOnMDXQuery() {
        this.mName = "Disable DMRCubeReuse through MDX Query based on dmr.properties, V5 queryhint and model governor.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        mdxQuery.setDMRCubeReuseEnabled(false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (!mdxQuery.isDMRCubeReuseEnabled()) {
            this.traceQueryCondition(false, "The DMRCubeReused has been disabled on this MDXQuery node.", trace);
            return false;
        }
        V5Query v5Query = this.getV5Query(node);
        if (v5Query == null) {
            this.traceQueryCondition(false, "Can't find V5Query.", trace);
            return false;
        }
        RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        if (requestEnvironment.getMaxSeverityLevel() == 3) {
            this.traceQueryCondition(true, "The user is requesting to view all the DMR Subqueries SQL.", trace);
            return true;
        }
        StringBuilder reason = new StringBuilder();
        boolean status = DisableDMRCubeReuseOnMDXQuery.isDMRCubeReuseDisabled(v5Query, environment, reason);
        this.traceQueryCondition(status, reason.toString(), trace);
        return status;
    }

    protected V5Query getV5Query(IXQEQueryNode node) {
        MDXQuery mdxQuery = (MDXQuery)node;
        String refQueryName = mdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        return v5QuerySet.getV5Query(refQueryName);
    }

    public static boolean isDMRCubeReuseDisabled(V5Query v5Query, PlanningEnvironment environment, StringBuilder reason) {
        IDataSourceCapabilities capabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        if (!capabilities.isSupported("enableDMRcubeReuse")) {
            reason.append("The provider property file specifies not to reuse DMR cube.");
            return true;
        }
        Boolean localCache = v5Query.getBooleanPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName());
        if (localCache != null && !localCache.booleanValue()) {
            reason.append("The V5Query specifies not to use a local cache.");
            return true;
        }
        if (!v5Query.getGovernors().isLocalCacheEnabled(environment).booleanValue()) {
            reason.append("The governor in model specifies not to use local cache.");
            return true;
        }
        reason.append("DMR Cube reuse is enabled.");
        return false;
    }
}

