/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5ResultCellUpdate;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateRule;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InsertNACellUpdateDecoration
extends AbstractV5ToCogMDXTransformation {
    public InsertNACellUpdateDecoration() {
        this.mName = "Insert V5 result cell update decoration to force NA value.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        V5DataItem v5DataItem = (V5DataItem)node;
        RSAPIDataItem v5RefDataItem = (RSAPIDataItem)v5DataItem.getParent().getPropertyValue("RSAPIRefDataItem");
        RSAPIEdge[] edges = rsapiDataset.getEdges();
        RSAPIEdgeRowset rsapiRowset = null;
        int dataItemId = -1;
        boolean foundIt = false;
        block0: for (int j = 0; j < edges.length && !foundIt; ++j) {
            RSAPIEdgeRowset[] rowsets = edges[j].getRowsets();
            block1: for (int i = 0; i < rowsets.length && !foundIt; ++i) {
                dataItemId = -1;
                rsapiRowset = rowsets[i];
                RSAPIDataItem refDataItem = rsapiRowset.getRefDataItem();
                if (refDataItem == v5RefDataItem) {
                    foundIt = true;
                    continue block0;
                }
                RSAPIDataItem[] dataItems = rsapiRowset.getDataItems();
                for (dataItemId = 0; dataItemId < dataItems.length; ++dataItemId) {
                    if (dataItems[dataItemId] != v5RefDataItem) continue;
                    foundIt = true;
                    continue block1;
                }
            }
        }
        V5ResultCellUpdate cellUpdateNode = null;
        int descendantType = 601014;
        IXQEQueryNode[] nodeCellUpdate = rsapiDataset.getDescendantsOfType(descendantType, false);
        if (nodeCellUpdate.length == 0) {
            cellUpdateNode = (V5ResultCellUpdate)nodeFactory.createNode(601014);
            rsapiDataset.getChild(0).insertParent(cellUpdateNode);
        } else {
            cellUpdateNode = (V5ResultCellUpdate)nodeCellUpdate[0];
        }
        String v5Name = null;
        V5MemberFunction v5MemberFunction = (V5MemberFunction)node.getFirstChildByType(201085);
        if (v5MemberFunction != null) {
            if (v5MemberFunction.getNumberChildren() > 1) {
                Value name = ((V5LiteralValue)v5MemberFunction.getChild(1)).getValue();
                v5Name = name.getString();
                if (v5MemberFunction.isQueryCalculation()) {
                    if (v5MemberFunction.getNumberChildren() > 2) {
                        name = ((V5LiteralValue)v5MemberFunction.getChild(2)).getValue();
                        v5Name = name.getString();
                    } else {
                        v5Name = null;
                    }
                }
            }
            if (v5Name == null || v5Name.length() == 0) {
                node.throwInternalError("Unexpected parameters for V5MemberFunction");
            }
        }
        int rowSetId = rsapiRowset.getRowsetId();
        int edgeOrdinal = rsapiRowset.getEdge().getPositionalOrdinal();
        XV5CellSpec nodeCellSpec = new XV5CellSpec(edgeOrdinal, rowSetId, dataItemId, v5Name);
        AbstractXV5CellUpdateRule cellUpdateRule = new AbstractXV5CellUpdateRule(nodeCellSpec){
            final ConcurrentMap<IDataType, Value> naValueCache;
            {
                this.naValueCache = new ConcurrentHashMap<IDataType, Value>();
            }

            @Override
            public boolean apply(ICell cell) {
                Value v = null;
                v = cell.getValue() instanceof ContextValue ? (Value)((ContextValue)cell.getValue()).getValue() : (Value)cell.getValue();
                IDataType dataType = v.getDataType();
                Value naValue = (Value)this.naValueCache.get(dataType);
                if (naValue == null) {
                    naValue = (Value)v.copy();
                    naValue.setState(ValueState.NOT_APPLICABLE);
                    Value valueFromMap = this.naValueCache.putIfAbsent(dataType, naValue);
                    if (valueFromMap != null) {
                        naValue = valueFromMap;
                    }
                }
                cell.setValue(naValue);
                return true;
            }
        };
        cellUpdateNode.addCellUpdateRule(cellUpdateRule);
        HashSet<RSAPIEdgeRowset> contextRowsets = new HashSet<RSAPIEdgeRowset>();
        V5ToCogMDXUtilities.collectSubTree(rsapiRowset, contextRowsets);
        for (int j = 0; j < edges.length; ++j) {
            RSAPIEdgeRowset[] rowsets = edges[j].getRowsets();
            for (int i = 0; i < rowsets.length; ++i) {
                rsapiRowset = rowsets[i];
                int edgeOrdinalCurrent = rsapiRowset.getEdge().getPositionalOrdinal();
                if (edgeOrdinalCurrent == edgeOrdinal && !contextRowsets.contains(rsapiRowset)) continue;
                nodeCellSpec = new XV5CellSpec(edgeOrdinalCurrent, rsapiRowset.getRowsetId(), -1, "AnyIntersectingDatabaseCalculationName");
                cellUpdateRule.addIntersectingCellSpec(nodeCellSpec);
                RSAPIDataItem[] dataItems = rsapiRowset.getDataItems();
                for (int k = 0; k < dataItems.length; ++k) {
                    nodeCellSpec = new XV5CellSpec(edgeOrdinalCurrent, rsapiRowset.getRowsetId(), k, "AnyIntersectingDatabaseCalculationName");
                    cellUpdateRule.addIntersectingCellSpec(nodeCellSpec);
                }
            }
        }
        mdxQuery.setMemberTypeRequested();
        v5DataItem.setBooleanPropertyValue("naInCalcMemberContext", "false");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem dataItem = (V5DataItem)node;
        if (!dataItem.getNaInCalcMemberContextProperty()) {
            this.traceNodeCondition(false, "The data item has a naInCalcMemberContext property set to false.", trace);
            return false;
        }
        if (dataItem.getParent().getType() != 101057) {
            this.traceNodeCondition(false, "The parent node is not a V5ValueSet node", trace);
            return false;
        }
        this.traceNodeCondition(true, "The data item can be used ofr cell update decoration.", trace);
        return true;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery != null && mdxQuery.isDMR()) {
            this.traceQueryCondition(false, "DMR query does not have this scenario.", trace);
            return false;
        }
        return true;
    }
}

