/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.v5.XV5Reform;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.querynormalization.ReformInfo;
import java.util.ArrayList;

public final class NormalizeQueryHierarchies
extends Transformation {
    public NormalizeQueryHierarchies() {
        this.mName = "Normalize query hierarchies.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query;
        ArrayList<IHierarchy> hierarchiesOnMultipleEdges;
        IXQEQueryNode[] edges = node.getChildrenOfTypeOrdered(101049);
        ReformInfo reformInfo = new ReformInfo((MDXQuery)node, edges);
        reformInfo.hasAdjacentHierarchyNesting(environment);
        MDXQuery theMdxQuery = (MDXQuery)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        String refQueryName = theMdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)theMdxQuery.getAncestorOfType(101002);
        V5Selection v5Selection = v5QuerySet.getV5Query(refQueryName).getV5Selection();
        if (reformInfo.hasEdgeWithPureCalculationsNoUnreferencedHierarchy()) {
            reformInfo.assignEdgeWithPureCalculationsToMeasure(theMdxQuery, nodeFactory);
        }
        reformInfo.resolveWithinDetail(nodeFactory);
        if (reformInfo.getEdgeHasMemeberSetReference() != null) {
            reformInfo.putEdgesWithMemeberSetInTargetEdge(nodeFactory, environment);
        }
        if (!(hierarchiesOnMultipleEdges = reformInfo.getHierarchiesOnMultipleEdges(theMdxQuery, false)).isEmpty()) {
            reformInfo.putSameHierarchyInSameEdge(nodeFactory, environment);
        }
        reformInfo.getPatternHierarchies();
        reformInfo.sortEdgeGroupsToPatternHierarchies();
        if (reformInfo.hasContextIndependentUpAndDownNestingNoSetAlias(environment)) {
            reformInfo.sortEdgeGroupsNoUpAndDownNesting(nodeFactory, environment);
        }
        if (reformInfo.getState() == 2) {
            return;
        }
        if (reformInfo.getReportMeasureDataItem() != null && (v5Query = v5QuerySet.getV5Query(refQueryName)).getPropertyValue(V5Query.QueryHint.REPORT_MEASURE.getPropertyName()) == null) {
            v5Query.setPropertyValue(V5Query.QueryHint.REPORT_MEASURE.getPropertyName(), reformInfo.getReportMeasureDataItem());
        }
        if (!(hierarchiesOnMultipleEdges.isEmpty() || hierarchiesOnMultipleEdges.size() <= 1 && hierarchiesOnMultipleEdges.get(0).getDimension().isMeasuresDimension())) {
            reformInfo.checkEdgeGroupsExceedLimit();
        }
        XV5Reform xNode = (XV5Reform)nodeFactory.createXNode(501096);
        theMdxQuery.insertParent(xNode);
        for (IXQEQueryNode aEdgeGroup : node.getDescendantsOfType(101050, false)) {
            for (IXQEQueryNode aGroupBody : aEdgeGroup.getDescendantsOfType(101051, false)) {
                for (IXQEQueryNode dataItemRef : aGroupBody.getChildrenOfType(101015)) {
                    String usage;
                    IMetadata metadataObj;
                    String refDataItemName = (String)dataItemRef.getPropertyValue("refDataItem");
                    V5DataItem v5DataItem = v5Selection.getDataItemByRefName(refDataItemName);
                    IXQEQueryNode expr = v5DataItem.getExpression(true);
                    if (expr.getType() != 201116 || (metadataObj = ((V5BoundModelIdentifier)expr).getMetadata()) == null || metadataObj.getObjectType() != MetadataType.QUERY_ITEM || !(usage = ((IQueryItem)metadataObj).getUsage()).equals("attribute")) continue;
                    xNode.setAttributeinGroupbody(true);
                }
            }
        }
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        RSAPIEdge[] rsapiEdges = rsapiDataset.getEdges();
        RSAPIDataset srcDataset = (RSAPIDataset)nodeFactory.createNode(401005);
        srcDataset.setReturnDataItemNameInPartialDataset(environment);
        srcDataset.setName(rsapiDataset.getName());
        srcDataset.setRefQueryName(rsapiDataset.getRefQueryName());
        srcDataset.setForOLAPQuery(true);
        xNode.addDataSet(srcDataset);
        ArrayList<RSAPIEdge> targetEdges = new ArrayList<RSAPIEdge>();
        ArrayList<RSAPIEdge> srcEdges = new ArrayList<RSAPIEdge>();
        reformInfo.setReformEdges(targetEdges, rsapiEdges);
        boolean emptyEdgeCreated = reformInfo.createSourceEdges(nodeFactory, srcDataset, srcEdges, rsapiEdges);
        reformInfo.resolveReportSummary();
        srcDataset.validateReportLayout();
        srcDataset.identifyEmptyEdges();
        RSAPIEdge[] targets = new RSAPIEdge[targetEdges.size()];
        System.arraycopy(targetEdges.toArray(), 0, targets, 0, targetEdges.size());
        xNode.addTargetSpec(targets, rsapiEdges);
        boolean[] bNeedCreate = new boolean[]{false};
        IMember[] measureMUN = new IMember[]{null};
        String[] v5MUN = new String[]{null};
        String[] v5Caption = new String[]{null};
        int reportMeasureEdgeId = reformInfo.getReportMeasureEdge(rsapiEdges, bNeedCreate, measureMUN, v5MUN, v5Caption);
        if (reportMeasureEdgeId != -1) {
            xNode.addReportMeasureSpec(reportMeasureEdgeId, bNeedCreate[0], measureMUN[0], v5MUN[0], v5Caption[0]);
        }
        RSAPIEdge[] sources = new RSAPIEdge[srcEdges.size()];
        System.arraycopy(srcEdges.toArray(), 0, sources, 0, srcEdges.size());
        if (!emptyEdgeCreated) {
            xNode.addSourceSpec(sources, srcDataset.getEdges());
        } else {
            xNode.addSourceSpec(sources, this.getNonEmptyEdges(srcDataset.getEdges()));
        }
    }

    private RSAPIEdge[] getNonEmptyEdges(RSAPIEdge[] edges) {
        RSAPIEdge[] newEdges = new RSAPIEdge[edges.length - 1];
        for (int i = 0; i < newEdges.length; ++i) {
            newEdges[i] = edges[i];
        }
        return newEdges;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode parentNode = node.getParent();
        if (parentNode.getType() == 501096) {
            this.traceNodeCondition(false, "done already.", trace);
            return false;
        }
        if (((MDXQuery)node).isListReport()) {
            this.traceQueryCondition(false, "This transformation just handles MDXQuery for xtab.", trace);
            return false;
        }
        IXQEQueryNode[] v5Groups = node.getDescendantsOfType(101050, false);
        for (int i = 0; i < v5Groups.length; ++i) {
            if (((V5EdgeGroup)v5Groups[i]).hasPropertyHierarchy()) continue;
            this.traceQueryCondition(false, "This transformation needs V5EdgeGroup property hierarchy.", trace);
            return false;
        }
        IXQEQueryNode[] edges = node.getChildrenOfTypeOrdered(101049);
        if (edges.length == 0) {
            this.traceQueryCondition(false, "No V5Edge nodes found for the query.", trace);
            return false;
        }
        ReformInfo reformInfo = new ReformInfo((MDXQuery)node, edges);
        MDXQuery mdxQuery = (MDXQuery)node;
        reformInfo.needReform(environment, mdxQuery);
        if (reformInfo.getState() > 0) {
            if (!mdxQuery.getCapabilities().isSupported("v5.reportermode.measureOnMultipleEdges") && reformInfo.measureOnEdges()) {
                this.traceNodeCondition(false, "The MXDQuery needs measures on mutple edges normalized first.", trace);
                return false;
            }
            this.traceNodeCondition(true, "The MXDQuery needs reform.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The MDXQuery does not need reform.", trace);
        return false;
    }
}

