/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.CoerceValueExpressionToV5MemberExpression;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public final class PropagateDataItemRollupAggregate
extends AbstractV5ToCogMDXTransformation {
    public PropagateDataItemRollupAggregate() {
        this.mName = "Propagate a data item's rollupAggregate property.";
        this.mPassNumbers = new int[]{4, 8};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode child;
        String rollupAggregateName = ((V5DataItem)node).getRollupAggregateProperty();
        V5RollupAggregateEnum rollupAggregateToPropagate = V5RollupAggregateEnum.valueOfV5String(rollupAggregateName);
        if (rollupAggregateToPropagate != V5RollupAggregateEnum.UNKNOWN && this.shouldPropagate(rollupAggregateToPropagate, ((V5SimpleNode)(child = V5ToCogMDXUtilities.getChildOverSet(node.getChild(0), 201101))).getRollupAggregate())) {
            ((V5SimpleNode)child).setRollupAggregate(rollupAggregateToPropagate);
            while (((V5SimpleNode)child).isCoercion() && child.getNumberChildren() == 1) {
                if (!this.shouldPropagate(rollupAggregateToPropagate, ((V5SimpleNode)(child = child.getChild(0))).getRollupAggregate())) continue;
                ((V5SimpleNode)child).setRollupAggregate(rollupAggregateToPropagate);
            }
        }
        node.removeProperty("rollupAggregate");
    }

    private boolean shouldPropagate(V5RollupAggregateEnum rollupAggregateToPropagate, V5RollupAggregateEnum nodeRollupAggregate) {
        if (rollupAggregateToPropagate == V5RollupAggregateEnum.CALCULATED) {
            V5RollupAggregateEnum[] enumsToPropagate;
            for (V5RollupAggregateEnum aEnum : enumsToPropagate = new V5RollupAggregateEnum[]{V5RollupAggregateEnum.UNDEFINED, V5RollupAggregateEnum.UNKNOWN, V5RollupAggregateEnum.CALCULATED}) {
                if (!nodeRollupAggregate.equals(aEnum)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        String rollupAggregate = v5DataItem.getRollupAggregateProperty();
        if (rollupAggregate == null) {
            this.traceNodeCondition(false, "The data item does not have a rollupAggregate property.", trace);
            return false;
        }
        if (rollupAggregate.length() > 0 && V5RollupAggregateEnum.valueOfV5String(rollupAggregate) == V5RollupAggregateEnum.UNKNOWN) {
            V5DataItem originalV5DataItem = v5DataItem.getOriginalV5DataItem();
            if (originalV5DataItem != null && V5RollupAggregateEnum.valueOfV5String(originalV5DataItem.getRollupAggregateProperty()) != V5RollupAggregateEnum.UNKNOWN) {
                v5DataItem.setRollupAggregateProperty(originalV5DataItem.getRollupAggregateProperty());
                this.traceNodeCondition(true, "The original data item has a rollupAggregate property that can be propagated.", trace);
                return true;
            }
            rollupAggregate = v5DataItem.getRollupAggregateProperty();
            node.throwInternalError("The rollupAggregate setting '" + rollupAggregate + "' is either unsupported or invalid.");
            return false;
        }
        if (node.getFirstDescendantOfTypeOrdered(101003, false) != null) {
            this.traceNodeCondition(false, "The data item contains unresolved V5DataItem nodes.", trace);
            return false;
        }
        if (CoerceValueExpressionToV5MemberExpression.willBeCoercedToMember((V5DataItem)node)) {
            this.traceNodeCondition(false, "The data item expression must first be coerced to a member function.", trace);
            return false;
        }
        if (node.getNumberChildren() == 0 || !node.getChild(0).isOfCategory(201120)) {
            this.traceNodeCondition(false, "The target V5DataItem node does not have a single SimpleNode child.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The data item has a rollupAggregate property that can be propagated.", trace);
        return true;
    }
}

