/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public final class RemoveForClauseWhenOnlyMeasuresInContext
extends Transformation {
    public RemoveForClauseWhenOnlyMeasuresInContext() {
        this.mName = "Remove for clause TNodes when only measures are in context.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{201037};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] v5ValueSets;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceQueryCondition(false, "The node is not under an MDXQuery node.", trace);
            return false;
        }
        if (mdxQuery.isListReport()) {
            this.traceQueryCondition(false, "List report will remove for clause during later optimization.", trace);
            return false;
        }
        for (IXQEQueryNode valueSet : v5ValueSets = mdxQuery.getDescendantsOfType(101057, false)) {
            MDXHierInfo hierInfo = ((V5ValueSet)valueSet).getHierarchyInfo();
            if (hierInfo == null) continue;
            List<IHierarchy> projHiers = hierInfo.getProjectedHierarchies();
            for (IHierarchy hierarchy : projHiers) {
                if (hierarchy.isShell() || hierarchy.getDimension().isMeasuresDimension()) continue;
                this.traceQueryCondition(false, "There is non measure in the context of the for clause.", trace);
                return false;
            }
        }
        this.traceQueryCondition(true, "There are only measures in the context of the for clause. Drop the for clause.", trace);
        return true;
    }
}

