/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class ResolveShortcutInV5BoundIdentifier
extends AbstractV5ToCogMDXTransformation {
    public ResolveShortcutInV5BoundIdentifier() {
        this.mName = "Replace the metadata of a shortcut with its target's.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201116, 201117, 201127, 201024};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IShortcut shortcut;
        V5BoundToMetadata v5BoundID = (V5BoundToMetadata)node;
        IMetadata metadata = ((V5BoundToMetadata)node).getMetadata();
        MetadataConnection connection = metadata.getConnection();
        if (connection.isTreatedAsAlias(shortcut = this.findShorcut(metadata), node.getGovernors())) {
            int severityOfMessage = 1;
            environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(severityOfMessage, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_doNotUseShortcutAsAlias, shortcut.getV5UniqueName().toString(), v5BoundID.getIdentifier().toString()));
        }
        IMetadata referenceObject = connection.getTargetOfReferenceShortcut(metadata);
        v5BoundID.setMetadata(referenceObject);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.isDMR()) {
            this.traceQueryCondition(false, "We only replace shortcut in non-DMR queries.", trace);
            return false;
        }
        IMetadata metadata = ((V5BoundToMetadata)node).getMetadata();
        if (metadata == null || !metadata.isMFW()) {
            this.traceQueryCondition(false, "The metadata is not OLAP type.", trace);
            return false;
        }
        IShortcut shortcut = this.findShorcut(metadata);
        if (shortcut != null) {
            this.traceQueryCondition(true, "The metadata contains shortcut that should be replaced with its target.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The metadata does not contain any shortcut.", trace);
        return false;
    }

    private IShortcut findShorcut(IMetadata metadataObj) {
        IDimension dimension = null;
        if (metadataObj != null) {
            MetadataType objectType = metadataObj.getObjectType();
            switch (objectType) {
                case HIERARCHY: {
                    dimension = ((IHierarchy)metadataObj).getDimension();
                    break;
                }
                case LEVEL: {
                    dimension = ((ILevel)metadataObj).getDimension();
                    break;
                }
                case MEMBER: {
                    dimension = ((IMember)metadataObj).getDimension();
                    break;
                }
                case DIMENSION: {
                    dimension = (IDimension)metadataObj;
                    break;
                }
                case CALCULATION: {
                    if (!((ICalculation)metadataObj).getCalcType().equals("namedSet")) break;
                    dimension = ((INamedSet)metadataObj).getDimension();
                    break;
                }
                case QUERY_ITEM: {
                    if (!(metadataObj instanceof IProperty)) break;
                    dimension = ((IProperty)metadataObj).getDimension();
                    break;
                }
            }
        }
        if (dimension != null && dimension instanceof IDimension) {
            if (((IAccessedViaShortcut)((Object)dimension)).isAccessedViaShortcut()) {
                return ((IAccessedViaShortcut)((Object)dimension)).getShortcut();
            }
            if (dimension.isUnderNamespaceShortcut()) {
                IMetadata namespace = dimension.getParentObjectSkipFolders();
                return ((IAccessedViaShortcut)namespace).getShortcut();
            }
        }
        return null;
    }
}

