/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class RetrieveDataItemRefExpression
extends AbstractV5ToCogMDXTransformation {
    public RetrieveDataItemRefExpression() {
        this.mName = "Retrieve referenced data items and copy it within the MDX query.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101015};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdQuerySpec = (MDXQuery)node.getAncestorOfType(1002);
        String refQueryName = mdQuerySpec.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Selection v5Selection = v5QuerySet.getV5Query(refQueryName).getV5Selection();
        String refDataItemName = (String)node.getPropertyValue("refDataItem");
        String errorMsg = "Failed to get referenced data item.";
        if (refDataItemName != null) {
            V5DataItem v5DataItem = v5Selection.getDataItemByRefName(refDataItemName);
            if (v5DataItem == null) {
                node.throwInternalError("Failed to get referenced data item.");
            }
            V5DataItem v5DataItemCopy = (V5DataItem)nodeFactory.deepCopyNode(v5DataItem);
            node.addChild(v5DataItemCopy);
            if (v5DataItemCopy.getSolveOrderProperty() == null) {
                v5DataItemCopy.setSolveOrderProperty(SolveOrderUtil.getUndefinedV5DataItemRefSolveOrder());
            }
        } else {
            node.throwInternalError("Failed to get referenced data item.");
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getNumberChildren() > 0) {
            this.traceNodeCondition(false, "The V5DataItemRef node has already been resolved", environment.getTrace());
            return false;
        }
        this.traceNodeCondition(true, "The V5DataItemRef node is a descendant of an MDXQuery node.", environment.getTrace());
        return true;
    }
}

