/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RetrieveQueryFlags
extends Transformation {
    public RetrieveQueryFlags() {
        this.mName = "Retrieve query property flags from the V5QuerySet.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ((MDXQuery)node).setIncludeCalculatedMembers();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((MDXQuery)node).getIncludeCalculatedMembers()) {
            this.traceQueryCondition(false, "The 'includeCalculatedMembers' flag is already set on the MDXQuery node.", trace);
            return false;
        }
        IXQEQueryNode querySet = node.getAncestorOfType(101002);
        if (querySet == null) {
            this.traceQueryCondition(false, "There is no ancestor V5QuerySet node.", trace);
            return false;
        }
        String includeCalcMembers = (String)querySet.getPropertyValue("includeCalculatedMembers");
        if (includeCalcMembers == null || includeCalcMembers.equals("false")) {
            this.traceQueryCondition(false, "The 'includeCalculatedMembers' flag is not set on the ancestor V5QuerySet node.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The ancestor V5QuerySet node has the 'includeCalculatedMembers' flag set to true.", trace);
        return true;
    }
}

