/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RetrieveQueryIntent
extends Transformation {
    public RetrieveQueryIntent() {
        this.mName = "Propergate the V5 query intent to MDX Query, when specified.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String refQueryName = ((MDXQuery)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName);
        String queryIntent = (String)v5Query.getPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName());
        ((MDXQuery)node).setQueryIntentProperty(queryIntent);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((MDXQuery)node).getQueryIntentProperty() != null) {
            this.traceQueryCondition(false, "The MDXQuery has already retrieved the query intent.", trace);
            return false;
        }
        String refQueryName = ((MDXQuery)node).getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName);
        if (v5Query == null) {
            this.traceQueryCondition(false, "Can't find V5Query.", trace);
            return false;
        }
        String queryIntent = (String)v5Query.getPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName());
        if (queryIntent == null) {
            this.traceQueryCondition(false, "The V5Query does not have a query intent specified.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The V5Query has a query intent specified.", trace);
        return true;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        String element = "element";
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", element);
        trace.attribute(element, "queryIntent");
        trace.endElement();
    }
}

