/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RetrieveQueryProcessingQueryHint
extends Transformation {
    private static final String RETRIEVE_QUERY_PROCESSING_QUERY_HINT_APPLIED = "RetrieveQueryProcessingQueryHint_Applied";

    public RetrieveQueryProcessingQueryHint() {
        this.mName = "This Transformation retrieves Query Processing Query Hint from V5Query and propagate it to MDXQuery.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        String refQueryName = mdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName);
        String queryProcessing = (String)v5Query.getPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName());
        mdxQuery.setQueryProcessingProperty(queryProcessing);
        if (mdxQuery.getDataSourceType().equals("BW")) {
            if (queryProcessing.equals("databaseOnly")) {
                mdxQuery.setforceLocalQueryProcessing(false);
            } else if (queryProcessing.equals("minimizeLocal")) {
                mdxQuery.setforceLocalQueryProcessing(true);
            }
        } else if (mdxQuery.getDataSourceType().equals("TMR")) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            if (config.getBooleanProperty("qsAllowDatabaseOnlyForPA", false) && queryProcessing.equals("databaseOnly")) {
                mdxQuery.setRequestProcessing(MultiRequestContext.RequestProcessing.DATABASEONLY);
                environment.getMultiRequestContext().setRequestProcessing(MultiRequestContext.RequestProcessing.DATABASEONLY);
            } else {
                mdxQuery.setRequestProcessing(MultiRequestContext.RequestProcessing.DEFAULT);
                environment.getMultiRequestContext().setRequestProcessing(MultiRequestContext.RequestProcessing.DEFAULT);
            }
        }
        v5Query.setPropertyValue(RETRIEVE_QUERY_PROCESSING_QUERY_HINT_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String refQueryName;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query v5Query = v5QuerySet.getV5Query(refQueryName = mdxQuery.getRefQueryProperty());
        if (v5Query == null) {
            this.traceQueryCondition(false, "Can't find V5Query.", trace);
            return false;
        }
        if (mdxQuery.getPropertyValue("queryProcessing") != null && v5Query.getPropertyValue(RETRIEVE_QUERY_PROCESSING_QUERY_HINT_APPLIED) != null) {
            this.traceQueryCondition(false, "The MDXQuery has already retrieved the 'queryProcessing' query hint.", trace);
            return false;
        }
        String queryProcessing = (String)v5Query.getPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName());
        if (queryProcessing == null) {
            this.traceQueryCondition(false, "There is no query processing hint specified.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The v5Query is found in V5QuerySet. Need to propagate the query processing query hint to the MDXQuery.", trace);
        return true;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        String element = "element";
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", element);
        trace.attribute(element, "queryProcessing");
        trace.endElement();
    }
}

