/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class RetrieveQuerySuppresNull
extends Transformation {
    public RetrieveQuerySuppresNull() {
        this.mName = "Retrieve the query null suppression and add it to the MDX Query.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        mdxQuery.setSuppressNullsQueryHint((String)this.getV5Query(node).getPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName()));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.getSuppressNullsQueryHint() != null) {
            this.traceQueryCondition(false, "The the query hint suppress nulls has been set on this MDXQuery node.", trace);
            return false;
        }
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (capabilities.isSupported("v5.suppress.queryhint.ignore")) {
            this.traceQueryCondition(false, "The provider property file marked to ignore the the suppress query hint.", trace);
            return false;
        }
        V5Query v5Query = this.getV5Query(node);
        if (v5Query == null) {
            this.traceQueryCondition(false, "Can't find V5Query.", trace);
            return false;
        }
        String suppress = (String)v5Query.getPropertyValue(V5Query.QueryHint.SUPPRESS.getPropertyName());
        if (suppress == null) {
            this.traceQueryCondition(false, "The V5Query does not have a null suppression specified.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Propagate the query hint suppress null.", trace);
        return true;
    }

    protected V5Query getV5Query(IXQEQueryNode node) {
        MDXQuery mdxQuery = (MDXQuery)node;
        String refQueryName = mdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        return v5QuerySet.getV5Query(refQueryName);
    }
}

