/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.transformation.v5.binding.BindIdentifierNotFoundException;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class RetrieveV5ValueSetExpression
extends AbstractV5ToCogMDXTransformation {
    public RetrieveV5ValueSetExpression() {
        this.mName = "Retrieve V5ValueSet data item expression to copy it within the MDX query.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdQuerySpec = (MDXQuery)node.getAncestorOfType(1002);
        String refQueryName = mdQuerySpec.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Selection v5Selection = v5QuerySet.getV5Query(refQueryName).getV5Selection();
        String refDataItemName = (String)node.getPropertyValue("refDataItem");
        if (refDataItemName != null) {
            V5DataItem v5DataItem = v5Selection.getDataItemByRefName(refDataItemName);
            V5DataItem v5DataItemCopy = (V5DataItem)nodeFactory.deepCopyNode(v5DataItem);
            node.addChild(v5DataItemCopy, 0);
            if (v5DataItemCopy.getSolveOrderProperty() == null) {
                v5DataItemCopy.setSolveOrderProperty(SolveOrderUtil.getUndefinedV5DataItemRefSolveOrder());
            }
            if (v5DataItem.getContextProperty() != null && v5DataItem.getContextProperty().length > 0) {
                ((V5ValueSet)node).setContextProperty(v5DataItem.getContextProperty());
            }
        } else if (node.getNumberChildrenOfType(101051) > 0) {
            V5GroupBody groupBody = (V5GroupBody)node.getChildrenOfType(101051)[0];
            IXQEQueryNode[] dataItemRefs = groupBody.getChildrenOfTypeOrdered(101015);
            for (int i = 0; i < dataItemRefs.length; ++i) {
                refDataItemName = (String)dataItemRefs[i].getPropertyValue("refDataItem");
                V5DataItem v5DataItem = v5Selection.getDataItemByRefName(refDataItemName);
                if (v5DataItem == null) {
                    throw new BindIdentifierNotFoundException(refDataItemName);
                }
                V5DataItem v5DataItemCopy = (V5DataItem)nodeFactory.deepCopyNode(v5DataItem);
                dataItemRefs[i].addChild(v5DataItemCopy, 0);
                if (v5DataItemCopy.getSolveOrderProperty() != null) continue;
                v5DataItemCopy.setSolveOrderProperty(SolveOrderUtil.getUndefinedV5DataItemRefSolveOrder());
            }
        }
        V5Edge edge = (V5Edge)node.getAncestorOfType(101049);
        String edgeName = (String)edge.getPropertyValue("name");
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        RSAPIEdge[] edges = rsapiDataset.getEdges();
        int edgeNum = 0;
        for (edgeNum = 0; !(edgeNum >= edges.length || edgeName != null && edges[edgeNum].getName().equals(edgeName)); ++edgeNum) {
        }
        IXQEQueryNode[] sortItems = node.getChildrenOfType(101056);
        for (int i = 0; i < sortItems.length; ++i) {
            refDataItemName = (String)sortItems[i].getPropertyValue("refDataItem");
            V5DataItem v5DataItem = v5Selection.getDataItemByRefName(refDataItemName);
            V5DataItem v5DataItemCopy = (V5DataItem)nodeFactory.deepCopyNode(v5DataItem);
            sortItems[i].addChild(v5DataItemCopy, 0);
            if (v5DataItemCopy.getSolveOrderProperty() == null) {
                v5DataItemCopy.setSolveOrderProperty(SolveOrderUtil.getUndefinedV5DataItemRefSolveOrder());
            }
            if (edgeName == null) continue;
            sortItems[i].setPropertyValue("edgeID", edgeNum);
        }
        node.setPropertyValue("retrieveV5ValueSetExpressionApplied", Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getPropertyValue("retrieveV5ValueSetExpressionApplied") != Boolean.TRUE) {
            this.traceNodeCondition(true, "The transformation already applied.", environment.getTrace());
            return true;
        }
        this.traceNodeCondition(false, "The transformation not already applied.", environment.getTrace());
        return false;
    }
}

