/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;

public class SetAllowNonNumericCellValue
extends Transformation {
    public SetAllowNonNumericCellValue() {
        this.mName = "Normalize query hierarchies.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        rsapiDataset.setAllowNonNumericCellValue(Boolean.TRUE);
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        RSAPIDataset rsapiDataset = (RSAPIDataset)node.getAncestorOfType(401005);
        if (rsapiDataset == null) {
            this.traceNodeCondition(false, "No RSAPIDataset ancestor was found.", trace);
            return false;
        }
        if (null != rsapiDataset.getAllowNonNumericCellValue()) {
            this.traceNodeCondition(false, "RSAPIDataset's allowNonNumericCellValues is set already.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        String providerCode = mdxQuery.getDataSourceType();
        if (!DataSourceTypeEnum.isTMR(providerCode)) {
            this.traceNodeCondition(false, "This transformation is not applicable for provider of type " + providerCode + ".", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation is applicable.", trace);
        return true;
    }
}

