/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public final class TransferNestedV5EdgeGroupsToParentV5ValueSetNodes
extends AbstractV5ToCogMDXTransformation {
    public TransferNestedV5EdgeGroupsToParentV5ValueSetNodes() {
        this.mName = "Transfer Nested V5EdgeGroups To Parent CogMDXGroup Nodes";
        this.mPassNumbers = new int[]{11};
        this.mTypes = new int[]{101050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode[] valueSetNodes = node.getChildrenOfType(101057);
        IXQEQueryNode[] edgeGroupNodes = node.getChildrenOfTypeOrdered(101050);
        for (int i = 0; i < valueSetNodes.length; ++i) {
            IXQEQueryNode newParent = valueSetNodes[i];
            if (edgeGroupNodes.length > 0) {
                V5EdgeGroup firstEdgeGroup = null;
                if (i == valueSetNodes.length - 1) {
                    firstEdgeGroup = (V5EdgeGroup)edgeGroupNodes[0].getParent().detachChild(edgeGroupNodes[0]);
                } else {
                    firstEdgeGroup = (V5EdgeGroup)nodeFactory.deepCopyNode(edgeGroupNodes[0]);
                    IXQEQueryNode[] orgValueSets = edgeGroupNodes[0].getChildrenOfType(101057);
                    IXQEQueryNode[] clonedValueSets = firstEdgeGroup.getChildrenOfType(101057);
                    for (int vsIdx = 0; vsIdx < clonedValueSets.length; ++vsIdx) {
                        ((V5ValueSet)clonedValueSets[vsIdx]).setClonedEdgeGroup(orgValueSets[vsIdx].getId());
                    }
                }
                newParent.addChild(firstEdgeGroup);
                newParent = firstEdgeGroup;
            }
            if (edgeGroupNodes.length <= 1) continue;
            for (int j = 1; j < edgeGroupNodes.length; ++j) {
                IXQEQueryNode[] valueSetNodes1 = edgeGroupNodes[j].getChildrenOfType(101057);
                for (int k = 0; k < valueSetNodes1.length; ++k) {
                    IXQEQueryNode childValueSet = null;
                    if (i == valueSetNodes.length - 1) {
                        childValueSet = valueSetNodes1[k].getParent().detachChild(valueSetNodes1[k]);
                    } else {
                        V5ValueSet clonedValueSet = (V5ValueSet)nodeFactory.deepCopyNode(valueSetNodes1[k]);
                        clonedValueSet.setClonedEdgeGroup(valueSetNodes1[k].getId());
                        childValueSet = clonedValueSet;
                    }
                    newParent.addChild(childValueSet);
                }
                if (i != valueSetNodes.length - 1) continue;
                node.detachChild(edgeGroupNodes[j]);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] edgeGroupNodes = node.getChildrenOfTypeOrdered(101050);
        String traceMsg = "";
        boolean status = true;
        if (edgeGroupNodes.length > 0 && node.getChildrenOfType(101057).length > 0) {
            traceMsg = "The target node has both V5EdgeGroup and V5ValueSet child nodes.";
            status = true;
            for (int j = 0; j < edgeGroupNodes.length; ++j) {
                if (edgeGroupNodes[j].getChildrenOfTypeOrdered(101050).length <= 0) continue;
                traceMsg = traceMsg + "The target node is nesting at least one other V5EdgeGroup node.";
                status = false;
                break;
            }
        } else {
            traceMsg = "The target node does not have both V5EdgeGroup and V5ValueSet child nodes.";
            status = false;
        }
        this.traceNodeCondition(status, traceMsg, trace);
        return status;
    }
}

