/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5exptomdxexp.ConvertDetailFilterCogMDXEqNeqToCogMDXIn;
import com.cognos.xqe.transformation.v5exptomdxexp.ConvertV5ComparisonOperatorToMDXComparisonOperator;
import java.util.Collection;

public class UnableToConvertCogMDXEqNeqToCogMDXIn
extends Transformation {
    public UnableToConvertCogMDXEqNeqToCogMDXIn() {
        this.mName = "Unable to Convert V5ComparisonExpression node of type '=' and '<>' to CogMDXIn node.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{201013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Collection<IXQEQueryNode> lineage = node.getLineage();
        if (lineage == null) {
            lineage = node.getParent().getLineage();
        }
        String filterExpression = null;
        if (lineage != null) {
            for (IXQEQueryNode linageNode : lineage) {
                switch (linageNode.getType()) {
                    case 101013: {
                        filterExpression = (String)linageNode.getPropertyValue("expression");
                        break;
                    }
                    case 101004: {
                        filterExpression = (String)linageNode.getPropertyValue("expression");
                        break;
                    }
                    default: {
                        filterExpression = null;
                    }
                }
                if (filterExpression == null) continue;
                break;
            }
        }
        if (filterExpression == null) {
            V5DataItemRef dataItem = (V5DataItemRef)node.getAncestorOfType(101015);
            if (dataItem != null) {
                MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
                StringBuilder exp = new StringBuilder("Query: ");
                exp.append(mdxQuery.getRefQueryProperty());
                exp.append(", Data item: ");
                exp.append(dataItem.getDataItemRefProperty());
                filterExpression = exp.toString();
            }
            if (filterExpression == null) {
                filterExpression = "";
            }
        }
        throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidComparisonExpression, filterExpression);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        boolean bl = status = mdxQuery != null;
        if (!status) {
            this.traceQueryCondition(status, "The target node is not within a MDXQuery node.", trace);
            return status;
        }
        IXQEQueryNode detailFilterNode = node.getAncestorOfType(1010);
        boolean bl2 = status = detailFilterNode == null;
        if (status) {
            this.traceQueryCondition(status, "The target node is not within a CogMDXDetailFilter node.", trace);
        } else {
            this.traceQueryCondition(status, "The target node is within a CogMDXDetailFilter node.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        IXQEQueryNode leftExpression = node.getChild(0);
        IXQEQueryNode rigthExpression = node.getChild(1);
        if (!leftExpression.isOfCategory(1001) || !rigthExpression.isOfCategory(1001)) {
            this.traceNodeCondition(false, "Comparison operands are not AbstractMDXNodes.", trace);
            return false;
        }
        boolean status = !ConvertV5ComparisonOperatorToMDXComparisonOperator.nodeCondition(node, traceMsg) || !ConvertDetailFilterCogMDXEqNeqToCogMDXIn.nodeCondition(node, traceMsg);
        this.traceNodeCondition(status, traceMsg.toString(), trace);
        return status;
    }
}

