/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.query.V5MemberSet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class V5ToCogMDXUtilities {
    private V5ToCogMDXUtilities() {
    }

    public static boolean isCoercableToNumericValueExpression(IXQEQueryNode node) {
        return node.isOfCategory(1022) && node.getType() != 1013 || node.isOfCategory(1068) || V5ToCogMDXUtilities.isNumericMDXValueExpression(node);
    }

    public static boolean isCoercableToValueExpression(IXQEQueryNode node) {
        return node.isOfCategory(1022) || node.isOfCategory(1068) || node.isOfCategory(1061);
    }

    public static IXQEQueryNode getReferencedSiblingOfType(int type, V5ValueSet valueSet, String refDataItemName, boolean throwWhenNotFound) {
        V5ValueSet vSet;
        RSAPIEdgeRowset rowSet;
        String summaryDataItemName = (String)valueSet.getPropertyValue("refDataItem");
        if (summaryDataItemName == null) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedWithinDetailReference, refDataItemName, valueSet.getNameProperty());
        }
        if (valueSet.getNumberChildren() >= 2 && valueSet.getChild(1).getType() == 101056 && summaryDataItemName.compareTo(refDataItemName) != 0) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedWithinDetailReference, refDataItemName, summaryDataItemName);
        }
        IXQEQueryNode parentToScanFrom = valueSet.getParent();
        if (parentToScanFrom.getType() == 101050 && parentToScanFrom.getNumberChildren() == 1) {
            parentToScanFrom = parentToScanFrom.getParent();
        }
        while (parentToScanFrom.getType() == 101057 && (rowSet = (vSet = (V5ValueSet)parentToScanFrom).getRSAPIEdgeRowset()) == null) {
            parentToScanFrom = vSet.getParent();
            if (parentToScanFrom.getType() != 101050 || parentToScanFrom.getNumberChildren() != 1) continue;
            parentToScanFrom = parentToScanFrom.getParent();
        }
        IXQEQueryNode matchingSibling = V5ToCogMDXUtilities.getReferencedSiblingOfType(type, parentToScanFrom, refDataItemName, summaryDataItemName, throwWhenNotFound);
        return matchingSibling;
    }

    public static IXQEQueryNode getReferencedSiblingOfType(int type, IXQEQueryNode parentToScanFrom, String refDataItemName, String summaryDataItemName, boolean throwWhenNotFound) {
        if (parentToScanFrom.getType() == 101050 && parentToScanFrom.getNumberChildren() == 1) {
            parentToScanFrom = parentToScanFrom.getParent();
        }
        int[] types = new int[]{type, 1117, 101050};
        IXQEQueryNode[] nodes = parentToScanFrom.getChildrenOfTypes(types);
        IXQEQueryNode referencedSibling = null;
        for (IXQEQueryNode node : nodes) {
            String groupRefDataItem;
            IXQEQueryNode[] childNodes;
            RSAPIEdgeRowset rowSet;
            IXQEQueryNode sibling = node;
            if (sibling.getType() == 101050) {
                sibling = sibling.getChild(0);
            }
            while ((sibling.getType() == 101057 || sibling.getType() == 1027) && (rowSet = V5ToCogMDXUtilities.getRSAPIEdgeRowset(sibling)) == null && (childNodes = sibling.getChildrenOfTypes(types)).length == 1) {
                sibling = childNodes[0];
                if (sibling.getType() != 101050) continue;
                sibling = sibling.getChild(0);
            }
            if (sibling.getType() != type || refDataItemName.compareTo(groupRefDataItem = (String)sibling.getPropertyValue("refDataItem")) != 0) continue;
            referencedSibling = sibling;
            break;
        }
        if (throwWhenNotFound && referencedSibling == null && parentToScanFrom.getChildrenOfType(101050).length == 1) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedWithinDetailReference, refDataItemName, summaryDataItemName);
        }
        return referencedSibling;
    }

    public static IXQEQueryNode getReferencedNodeOfType(int type, V5ValueSet valueSet, String refDataItemName, boolean throwWhenNotFound) {
        V5ValueSet vSet;
        RSAPIEdgeRowset rowSet;
        String summaryDataItemName = (String)valueSet.getPropertyValue("refDataItem");
        if (valueSet.getNumberChildren() >= 2 && valueSet.getChild(1).getType() == 101056 && summaryDataItemName.compareTo(refDataItemName) != 0) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedWithinDetailReference, refDataItemName, summaryDataItemName);
        }
        IXQEQueryNode parentToScanFrom = valueSet.getParent();
        if (parentToScanFrom.getType() == 101050 && parentToScanFrom.getNumberChildren() == 1) {
            parentToScanFrom = parentToScanFrom.getParent();
        }
        while (parentToScanFrom.getType() == 101057 && (rowSet = (vSet = (V5ValueSet)parentToScanFrom).getRSAPIEdgeRowset()) == null) {
            parentToScanFrom = vSet.getParent();
            if (parentToScanFrom.getType() != 101050 || parentToScanFrom.getNumberChildren() != 1) continue;
            parentToScanFrom = parentToScanFrom.getParent();
        }
        IXQEQueryNode matchingSibling = V5ToCogMDXUtilities.getReferencedNodeOfType(type, parentToScanFrom, refDataItemName, summaryDataItemName, throwWhenNotFound);
        return matchingSibling;
    }

    public static IXQEQueryNode getReferencedNodeOfType(int type, IXQEQueryNode parentToScanFrom, String refDataItemName, String summaryDataItemName, boolean throwWhenNotFound) {
        if (parentToScanFrom.getType() == 101050 && parentToScanFrom.getNumberChildren() == 1) {
            parentToScanFrom = parentToScanFrom.getParent();
        }
        IXQEQueryNode referencedSibling = null;
        int[] types = new int[]{type, 1117, 101050};
        while (parentToScanFrom != null) {
            IXQEQueryNode[] nodes;
            for (IXQEQueryNode node : nodes = parentToScanFrom.getChildrenOfTypes(types)) {
                String groupRefDataItem;
                IXQEQueryNode[] childNodes;
                RSAPIEdgeRowset rowSet;
                IXQEQueryNode sibling = node;
                if (sibling.getType() == 101050) {
                    sibling = sibling.getChild(0);
                }
                while ((sibling.getType() == 101057 || sibling.getType() == 1027) && (rowSet = V5ToCogMDXUtilities.getRSAPIEdgeRowset(sibling)) == null && (childNodes = sibling.getChildrenOfTypes(types)).length == 1) {
                    sibling = childNodes[0];
                    if (sibling.getType() != 101050) continue;
                    sibling = sibling.getChild(0);
                }
                if (sibling.getType() != type || refDataItemName.compareTo(groupRefDataItem = (String)sibling.getPropertyValue("refDataItem")) != 0) continue;
                referencedSibling = sibling;
                break;
            }
            if (referencedSibling != null || parentToScanFrom.getType() == 101049) break;
            if ((parentToScanFrom = parentToScanFrom.getParent()).getType() != 101050) continue;
            parentToScanFrom = parentToScanFrom.getParent();
        }
        if (throwWhenNotFound && referencedSibling == null && (parentToScanFrom == null || parentToScanFrom.getChildrenOfType(101050).length == 1)) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedWithinDetailReference, refDataItemName, summaryDataItemName);
        }
        return referencedSibling;
    }

    public static RSAPIEdgeRowset getRSAPIEdgeRowset(IXQEQueryNode node) {
        RSAPIEdgeRowset rowSet = null;
        rowSet = node.getType() == 101057 ? ((V5ValueSet)node).getRSAPIEdgeRowset() : ((CogMDXGroup)node).getRSAPIEdgeRowset();
        return rowSet;
    }

    public static void removeGroupBodyMeasureGroupsFromDescendant(CogMDXGroup currentGroup) {
        IXQEQueryNode[] descGroups = currentGroup.getDescendantsOfType(1027, false);
        for (int i = 0; i < descGroups.length; ++i) {
            if (descGroups[i].getPropertyValue("nonDetailGroupBodyValue") == null) continue;
            IXQEQueryNode parent = descGroups[i].getParent();
            descGroups[i].detach();
            if (parent.getNumberChildren() != 0) continue;
            parent.detach();
        }
    }

    public static List<IXQEQueryNode> getMemberSetsForV5ValueSet(V5ValueSet valueSet) {
        List<IXQEQueryNode> memberSets = new ArrayList<IXQEQueryNode>();
        String valueSetRef = (String)valueSet.getPropertyValue("refDataItem");
        if (valueSetRef == null) {
            return memberSets;
        }
        V5Query v5Query = (V5Query)valueSet.getAncestorOfType(101006);
        if (v5Query == null) {
            MDXQuery mdxQuery = (MDXQuery)valueSet.getAncestorOfType(1002);
            if (mdxQuery == null) {
                return memberSets;
            }
            v5Query = mdxQuery.getRefV5Query();
            if (v5Query == null) {
                return memberSets;
            }
        }
        memberSets = v5Query.getOriginalV5Query().getDescendantsOfTypeOrdered(101005, false);
        ListIterator<IXQEQueryNode> it = memberSets.listIterator();
        while (it.hasNext()) {
            V5MemberSet memberSet = (V5MemberSet)it.next();
            String memberSetRef = (String)memberSet.getPropertyValue("refDataItem");
            if (memberSetRef.equals(valueSetRef)) continue;
            it.remove();
        }
        return memberSets;
    }

    public static boolean isNodeWithinMDXQuery(Transformation transformation, IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getType() == 1002 || node.isWithinScope(1002, 401005)) {
            status = true;
            transformation.traceQueryCondition(status, "The V5 node is in the context of a MDX query to be planned.", trace);
        } else {
            transformation.traceQueryCondition(status, "The V5 node is not in the context of a MDX query to be planned.", trace);
        }
        return status;
    }

    public static boolean isV5QuerySet(Transformation transformation, IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getType() == 101002) {
            status = true;
            transformation.traceQueryCondition(status, "The V5 node is the V5QuerySet", trace);
        } else {
            transformation.traceQueryCondition(status, "The V5 node is not the V5QuerySet.", trace);
        }
        return status;
    }

    public static void collectSubTree(RSAPIEdgeRowset rowset, Set<RSAPIEdgeRowset> subTree) {
        for (RSAPIEdgeRowset parentRowset = rowset.getParentRowset(); parentRowset != null; parentRowset = parentRowset.getParentRowset()) {
            subTree.add(parentRowset);
        }
        subTree.add(rowset);
        V5ToCogMDXUtilities.collectDescendants(rowset, subTree);
    }

    private static void collectDescendants(RSAPIEdgeRowset rowset, Set<RSAPIEdgeRowset> decendanceSet) {
        ArrayList<RSAPIEdgeRowset> childrenRowset = new ArrayList<RSAPIEdgeRowset>();
        RSAPIEdgeRowset nested = rowset.getNestedRowset();
        if (nested != null) {
            childrenRowset.add(nested);
            for (RSAPIEdgeRowset sibling = nested.getSiblingRowset(); sibling != null; sibling = sibling.getSiblingRowset()) {
                childrenRowset.add(sibling);
            }
        }
        decendanceSet.addAll(childrenRowset);
        for (RSAPIEdgeRowset aChild : childrenRowset) {
            V5ToCogMDXUtilities.collectDescendants(aChild, decendanceSet);
        }
    }

    public static boolean isProjectedNode(IXQEQueryNode node, boolean bFooterHeader) {
        if (node.getParent() == null || node.getParent().getType() != 101003) {
            return false;
        }
        boolean bMeasure = true;
        if (bFooterHeader) {
            IXQEQueryNode exprNode = node;
            while (exprNode.getType() == 101003) {
                exprNode = exprNode.getChild(0);
            }
            boolean bl = bMeasure = !exprNode.isOfCategory(201120) || ((V5SimpleNode)exprNode).getMetadata() != null;
            if (bMeasure) {
                bMeasure = MetadataType.isMeasureDimension(((V5SimpleNode)exprNode).getMetadata());
            }
        }
        IXQEQueryNode nodeParent = node;
        while ((nodeParent = nodeParent.getParent()).getType() == 101003) {
        }
        if (!(nodeParent.getType() != 101015 || nodeParent.getParent().getType() != 101051 && (bMeasure || nodeParent.getParent().getType() != 101052 && nodeParent.getParent().getType() != 101053))) {
            nodeParent = nodeParent.getParent().getParent();
        }
        return nodeParent.getType() == 101057;
    }

    public static boolean isDirectProjectedNode(IXQEQueryNode node) {
        V5RoleValueFunction v5RoleValueFunction;
        V5RollupAggregateEnum rollupValue;
        boolean status = false;
        if (!(node.getType() != 201098 || node.getParent().getType() != 101015 || node.getParent().getParent().getType() != 101053 && node.getParent().getParent().getType() != 101052 || (rollupValue = (v5RoleValueFunction = (V5RoleValueFunction)node).getRollupAggregate()) != V5RollupAggregateEnum.UNKNOWN && rollupValue != V5RollupAggregateEnum.NONE && rollupValue != V5RollupAggregateEnum.UNDEFINED)) {
            return true;
        }
        if (node.getParent().getType() == 101015 && node.getParent().getParent().getType() == 101051) {
            status = true;
        } else if (node.getParent().getType() == 101057) {
            status = true;
        }
        return status;
    }

    public static IXQEQueryNode getChildOverSet(IXQEQueryNode node, int type) {
        IXQEQueryNode newNode = node;
        while (newNode.getType() == type && newNode.getNumberChildren() == 1) {
            newNode = newNode.getChild(0);
        }
        return newNode;
    }

    public static IXQEQueryNode getParentOverSet(IXQEQueryNode node) {
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 201101 && parent.getNumberChildren() == 1) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static boolean isNumericValueExpression(IXQEQueryNode node) {
        boolean isNumeric = false;
        if (node.isOfCategory(201120)) {
            V5SimpleNode valueExpression = (V5SimpleNode)node;
            IDataType dataType = null;
            dataType = valueExpression.getType() == 201085 ? ((V5MemberFunction)valueExpression).getDefinitionDataType() : valueExpression.getDataType();
            isNumeric = dataType == null ? true : dataType.isNumeric();
        } else {
            isNumeric = V5ToCogMDXUtilities.isNumericMDXValueExpression(node);
        }
        return isNumeric;
    }

    public static boolean isNumericMDXValueExpression(IXQEQueryNode node) {
        IMember member;
        boolean isNumeric = false;
        if (node.isOfCategory(1061)) {
            AbstractMDXValueExpression valueExpression = (AbstractMDXValueExpression)node;
            isNumeric = valueExpression.isNumeric();
        } else if (node.getType() == 1013) {
            isNumeric = ((AbstractMDXValueExpression)((MDXCalculatedMemberReference)node).getDefinition().getChild(0)).isNumeric();
        } else if (node.getType() == 1067 && (member = ((BaseMember)node).getMember()) != null) {
            isNumeric = member.isMeasure() && member.getDataType().isNumeric();
        }
        return isNumeric;
    }

    public static V5MemberFunction createV5MemberExpression(IXQEQueryNode node, PlanningEnvironment environment, String mun, String caption) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IHierarchy hierarchy = null;
        if (mdxQuery != null) {
            hierarchy = mdxQuery.getMeasuresHierarchy();
        }
        return V5ToCogMDXUtilities.createV5MemberExpression(node, environment, mun, caption, hierarchy);
    }

    public static V5MemberFunction createV5MemberExpression(IXQEQueryNode node, PlanningEnvironment environment, String mun, String caption, IHierarchy measuresHierarchy) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5MemberFunction memberFn = (V5MemberFunction)factory.createNode(201085);
        memberFn.setPlannerV5MemberFn(true);
        memberFn.setIsCoercion(true);
        node.insertParent(memberFn);
        V5LiteralValue memberName = (V5LiteralValue)factory.createNode(201026);
        memberName.setIsCoercion(true);
        StringType valueDataType = DataTypeFactory.getStringType();
        memberName.setDataType(valueDataType);
        memberName.setValue(mun);
        memberFn.addChild(memberName);
        memberName = (V5LiteralValue)factory.createNode(201026);
        memberName.setIsCoercion(true);
        memberName.setDataType(valueDataType);
        memberName.setValue(caption);
        memberFn.addChild(memberName);
        if (measuresHierarchy != null && (memberFn.getParent().getType() == 101065 || memberFn.getParent().getType() == 201032)) {
            BaseHierarchy measureHier = MDXBuilder.buildMDXBaseHierarchyExpr(factory, measuresHierarchy);
            memberFn.addChild(measureHier);
        }
        if (V5ToCogMDXUtilities.isProjectedNode(memberFn, false)) {
            V5SimpleNode setExpression = (V5SimpleNode)factory.createNode(201101);
            setExpression.setIsCoercion(true);
            memberFn.insertParent(setExpression);
        }
        memberFn.setRollupAggregate(((V5SimpleNode)node).getRollupAggregate());
        return memberFn;
    }

    public static void addV5SortItemToProperValueSet(V5ValueSet valueSet, V5GroupBody groupBody, V5SortItem sortItem, V5DataItemRef dataItemRef) {
        if (groupBody == null) {
            valueSet.addChild(sortItem);
        } else {
            IXQEQueryNode[] dataItems = groupBody.getChildrenOfTypeOrdered(101015);
            IXQEQueryNode[] sortItems = valueSet.getChildrenOfTypeOrdered(101056);
            int sortItemInx = 0;
            Object dataItemStr = dataItemRef.getDataItemRefProperty();
            for (int dataItemInx = 0; dataItemInx < dataItems.length && sortItemInx < sortItems.length && dataItems[dataItemInx] != dataItemRef; ++dataItemInx) {
                dataItemStr = dataItems[dataItemInx].getPropertyValue("refDataItem");
                Object sortItemStr = sortItems[sortItemInx].getPropertyValue("refDataItem");
                if (!sortItemStr.equals(dataItemStr)) continue;
                ++sortItemInx;
            }
            if (sortItemInx >= sortItems.length) {
                valueSet.addChild(sortItem);
            } else {
                valueSet.addChildBeforeNode(sortItem, sortItems[sortItemInx]);
            }
        }
    }

    public static void addV5SortItemToProperValueSet(V5ValueSet valueSet, V5GroupBody groupBody, V5SortItem sortItem) {
        IXQEQueryNode[] sortItems = valueSet.getChildrenOfTypeOrdered(101056);
        if (groupBody == null) {
            valueSet.addChild(sortItem);
        } else if (sortItems.length == 0) {
            valueSet.addChild(sortItem);
        } else {
            ArrayList<V5SortItem> groupSortItems = new ArrayList<V5SortItem>();
            ArrayList<V5SortItem> dataItemSortItems = new ArrayList<V5SortItem>();
            for (int i = 0; i < sortItems.length; ++i) {
                if (sortItems[i].getPropertyValue("sortType") != null && sortItems[i].getPropertyValue("sortType").equals("dataItemSort")) {
                    dataItemSortItems.add((V5SortItem)sortItems[i]);
                    continue;
                }
                groupSortItems.add((V5SortItem)sortItems[i]);
            }
            IXQEQueryNode[] dataItems = groupBody.getChildrenOfTypeOrdered(101015);
            int pos1 = 0;
            int pos2 = 0;
            for (int m = 0; m < dataItems.length; ++m) {
                String s2;
                String string = (String)dataItems[m].getPropertyValue("refDataItem");
                if (!string.equals(s2 = (String)sortItem.getPropertyValue("refDataItem"))) continue;
                pos1 = m;
            }
            for (IXQEQueryNode iXQEQueryNode : dataItemSortItems) {
                String s1 = (String)iXQEQueryNode.getPropertyValue("refDataItem");
                for (int n = 0; n < dataItems.length; ++n) {
                    String s2 = (String)dataItems[n].getPropertyValue("refDataItem");
                    if (s1.equals(s2)) {
                        pos2 = n;
                    }
                    if (pos2 <= pos1) continue;
                    valueSet.addChildBeforeNode(sortItem, iXQEQueryNode);
                    return;
                }
            }
            valueSet.addChild(sortItem);
        }
    }
}

