/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.dmr.ReplaceDMRBoundIdentifierWithExpression;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class UpdateBoundLevelToQueryItem
extends Transformation {
    public UpdateBoundLevelToQueryItem() {
        this.mName = "Update bound level with query item.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5BoundId = (V5BoundModelIdentifier)node;
        UpdateBoundLevelToQueryItem.verifyConsistencyOfMemberComparison(v5BoundId);
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (!mdxDetailFilter.isModelFilter()) {
            IHierarchy hierarchy = v5BoundId.getHierarchy();
            Set<IHierarchy> hierarchies = mdxDetailFilter.getReferencedDMRHierarchies();
            hierarchies.add(hierarchy);
            mdxDetailFilter.setReferencedDMRHierarchies(hierarchies);
            mdxDetailFilter.setPropertyValue("usingDimensionalObjs", "true");
        }
        UpdateBoundLevelToQueryItem.updateBoundLevelToQueryItem(node, environment, false);
    }

    public static void updateBoundLevelToQueryItem(IXQEQueryNode node, PlanningEnvironment environment, boolean dmrtorel) {
        String expr;
        V5BoundModelIdentifier v5BoundId = (V5BoundModelIdentifier)node;
        String roleType = ReplaceDMRBoundIdentifierWithExpression.getRoleTypeFromContextAndExtractParents(v5BoundId);
        if (roleType == null) {
            roleType = RoleTypeEnum.BUSINESS_KEY.toV5Keyword();
        }
        if ((expr = ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpression(environment, (V5BoundToMetadata)node, roleType, true)) != null) {
            if (dmrtorel) {
                IXQEQueryNode[] identifiers;
                IXQEQueryNode itemExpr = RQPUtilities.createV5ValueExpression(expr, environment, node);
                for (IXQEQueryNode v5Identifier : identifiers = itemExpr.getDescendantsOfType(201030, true)) {
                    v5Identifier.setPropertyValue("dmrLevelMetadata", v5BoundId.getMetadata());
                }
                v5BoundId.exchange(itemExpr);
            } else {
                V5MultiPartIdentifier v5Identifier = (V5MultiPartIdentifier)environment.getNodeFactory().createNode(201030);
                v5Identifier.setPropertyValue("dmrLevelMetadata", v5BoundId.getMetadata());
                v5Identifier.setIdentifier(expr);
                v5BoundId.exchange(v5Identifier);
                MetadataContext.flagMetadataObjectIfRequired(((V5BoundModelIdentifier)node).getMetadata(), v5Identifier);
            }
        } else {
            DMRUtilities.convertAllLevelToRootCaptionOrRootMUNKey(v5BoundId, environment, roleType);
        }
    }

    public static void verifyConsistencyOfMemberComparison(V5BoundModelIdentifier v5BoundModelId) {
        List<V5BoundMemberUniqueName> v5BoundMUNlist = UpdateBoundLevelToQueryItem.getMUNFromMembersOfLevelEqMUNExpr(v5BoundModelId);
        if (v5BoundMUNlist != null) {
            ILevel levelOfBoundModel = (ILevel)v5BoundModelId.getMetadata();
            for (int i = 0; i < v5BoundMUNlist.size(); ++i) {
                V5BoundMemberUniqueName v5BoundMUN = v5BoundMUNlist.get(i);
                ILevel levelOfBoundMUN = v5BoundMUN.getLevel();
                if (levelOfBoundModel == null || levelOfBoundMUN == null || levelOfBoundModel.getV5UniqueName().equals(levelOfBoundMUN.getV5UniqueName())) continue;
                String name = "EQ";
                if (v5BoundModelId.getAncestorOfType(201013) == null) {
                    name = "IN";
                }
                throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleHierarchiesDetailFilter, (Object)levelOfBoundModel.getV5UniqueName(), (Object)levelOfBoundMUN.getV5UniqueName(), (Object)name);
            }
        }
    }

    private static List<V5BoundMemberUniqueName> getMUNFromMembersOfLevelEqMUNExpr(V5BoundModelIdentifier v5BoundModelId) {
        V5ComparisonExpression comparisonNode;
        int comparisonSubType;
        IXQEQueryNode parentNode = v5BoundModelId.getParent();
        if (parentNode.getType() == 101003) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() != 201086) {
            return null;
        }
        if ((parentNode = parentNode.getParent()).getType() == 101003) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201013 ? (comparisonSubType = (comparisonNode = (V5ComparisonExpression)parentNode).getSubType()) != 2 : parentNode.getType() != 201011) {
            return null;
        }
        ArrayList<V5BoundMemberUniqueName> result = new ArrayList<V5BoundMemberUniqueName>();
        int iStart = 1;
        if (parentNode.getChild(1).getType() == 201101) {
            parentNode = parentNode.getChild(1);
            --iStart;
        }
        for (int i = iStart; i < parentNode.getNumberChildren(); ++i) {
            IXQEQueryNode secondChild = parentNode.getChild(i);
            IXQEQueryNode v5BoundMUN = null;
            v5BoundMUN = secondChild.getType() == 101003 ? secondChild.getChild(0) : secondChild;
            if (v5BoundMUN == null || v5BoundMUN.getType() != 201117) {
                return null;
            }
            result.add((V5BoundMemberUniqueName)v5BoundMUN);
        }
        return result;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        String[] reason;
        XQETrace trace = environment.getTrace();
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (mdxDetailFilter == null) {
            this.traceNodeCondition(false, "The bound identifier is not within a detail filter.", trace);
            return false;
        }
        if (mdxDetailFilter.pushDetailFilterToRelationalProvider() && UpdateBoundLevelToQueryItem.checkNodeCondition(node, reason = new String[]{""})) {
            this.traceNodeCondition(true, reason[0], trace);
            return true;
        }
        this.traceNodeCondition(false, "The bound identifier does not need any conversion.", trace);
        return false;
    }

    public static boolean checkNodeCondition(IXQEQueryNode node, String[] reason) {
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        if (metaData == null) {
            return false;
        }
        if (metaData instanceof LevelWrapper) {
            reason[0] = "The bound identifier is for a level to be converted.";
            return true;
        }
        if (metaData.getObjectType() == MetadataType.QUERY_ITEM && ((IQueryItem)metaData).getLevel() != null) {
            reason[0] = "The bound identifier is a query item of a level and needs to be converted.";
            return true;
        }
        return false;
    }
}

