/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import java.util.Set;

public final class UpdateBoundMeasureToQueryItem
extends Transformation {
    public UpdateBoundMeasureToQueryItem() {
        this.mName = "Update bound level with query item.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundModelIdentifier v5BoundId = (V5BoundModelIdentifier)node;
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        IHierarchy hierarchy = v5BoundId.getHierarchy();
        Set<IHierarchy> hierarchies = mdxDetailFilter.getReferencedDMRHierarchies();
        hierarchies.add(hierarchy);
        mdxDetailFilter.setReferencedDMRHierarchies(hierarchies);
        mdxDetailFilter.setPropertyValue("usingDimensionalObjs", "true");
        UpdateBoundMeasureToQueryItem.updateBoundMeasureToQueryItem(node, environment);
    }

    public static void updateBoundMeasureToQueryItem(IXQEQueryNode node, PlanningEnvironment environment) {
        String expr;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundModelIdentifier v5BoundId = (V5BoundModelIdentifier)node;
        IMeasure measure = (IMeasure)v5BoundId.getMetadata();
        IXQEQueryNode parentNode = node.getParent();
        if (parentNode.getType() == 101003) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201110) {
            parentNode.extract();
        }
        if ((parentNode = node.getParent()).getType() == 101003) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201113) {
            parentNode.extract();
        }
        if ((expr = (String)measure.getProperty("expression")) == null) {
            expr = measure.getUniqueID();
        }
        IXQEQueryNode tree = RQPUtilities.createV5ValueExpression(expr, environment, null);
        v5BoundId.exchange(tree);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        IMetadata metaData;
        XQETrace trace = environment.getTrace();
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (mdxDetailFilter == null) {
            this.traceNodeCondition(false, "The bound identifier is not within a detail filter.", trace);
            return false;
        }
        if (mdxDetailFilter.pushDetailFilterToRelationalProvider() && (metaData = ((V5BoundModelIdentifier)node).getMetadata()) != null && metaData instanceof MeasureWrapper) {
            this.traceNodeCondition(true, "The bound identifier is for a measure to be converted.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The bound identifier do not need any conversion.", trace);
        return false;
    }
}

