/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.binding;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.ReplaceDMRMemberWithRelationalLiteral;
import com.cognos.xqe.transformation.v5tocogmdx.binding.ExpandDMRMemberFilterExpression;
import java.util.Set;

public final class UpdateBoundMemberToV5Literal
extends Transformation {
    public UpdateBoundMemberToV5Literal() {
        this.mName = "Update bound member unique name with literal value.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{201117};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundMemberUniqueName v5BoundId = (V5BoundMemberUniqueName)node;
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (!mdxDetailFilter.isModelFilter()) {
            IHierarchy hierarchy = v5BoundId.getLevel().getHierarchy();
            Set<IHierarchy> hierarchies = mdxDetailFilter.getReferencedDMRHierarchies();
            hierarchies.add(hierarchy);
            mdxDetailFilter.setReferencedDMRHierarchies(hierarchies);
            mdxDetailFilter.setPropertyValue("usingDimensionalObjs", "true");
        }
        ReplaceDMRMemberWithRelationalLiteral.replaceMemberWithItsBusinessKeyValue(v5BoundId, environment);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node.getAncestorOfType(1010);
        if (mdxDetailFilter == null) {
            this.traceNodeCondition(false, "The bound identifier is not within a detail filter.", trace);
            return false;
        }
        if (mdxDetailFilter.pushDetailFilterToRelationalProvider() || mdxDetailFilter.getPropertyValue("dmrSlicer") != null) {
            String[] reason = new String[]{""};
            boolean b = UpdateBoundMemberToV5Literal.checkNodeCondition(node, reason);
            this.traceNodeCondition(b, reason[0], trace);
            return b;
        }
        this.traceNodeCondition(false, "The bound identifier do not need any conversion.", trace);
        return false;
    }

    public static boolean checkNodeCondition(IXQEQueryNode node, String[] reason) {
        V5BoundMemberUniqueName v5BoundId = (V5BoundMemberUniqueName)node;
        ILevel level = v5BoundId.getLevel();
        if (ExpandDMRMemberFilterExpression.membersRequireMunNormalization(level) && node.getBooleanPropertyValue("updatedInDMRMemberFilter") == null) {
            reason[0] = "This MUN has to be updated first.";
            return false;
        }
        IXQEQueryNode parentNode = node.getParent();
        if (parentNode.getType() == 101003) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201101) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201098) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201011 || parentNode.getType() == 201013) {
            reason[0] = "The bound identifier is for a member to be converted simply to literal value.";
            return true;
        }
        reason[0] = "The bound identifier is not a member to be converted simply to literal value";
        return false;
    }
}

