/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.coercion;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.coercion.AbstractCoerceSetExpression;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;

public final class CoerceSetExpressionOnEdge
extends AbstractV5ToCogMDXTransformation {
    public CoerceSetExpressionOnEdge() {
        this.mName = "Coerce Set Expressions On Edge";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 3;
        this.mTypes = new int[]{201045, 201054, 201057, 201058, 201059, 201061, 201067, 201068, 201076, 201077, 201078, 201080, 201081, 201132, 201085, 201088, 201090, 201093, 201094, 201096, 201110, 201056, 201073, 201082, 201083, 201099, 201127, 201117, 201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractCoerceSetExpression.coerceToSetExpression(node, environment.getNodeFactory());
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesQueryCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        boolean status = false;
        int[] types = new int[]{1006, 101049};
        if (node.getAncestorsOfCategories(types) != null) {
            status = true;
            this.traceQueryCondition(status, "The V5 expression function is within an edge.", trace);
        } else {
            this.traceQueryCondition(status, "The V5 expression function is not within an edge.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        if (node.getParent().getType() != 101003) {
            return false;
        }
        IXQEQueryNode parent = node;
        while ((parent = parent.getParent()).getParent().getType() == 101003) {
        }
        String rollup = ((V5DataItem)parent).getRollupAggregateProperty();
        boolean bFooterHeader = rollup != null && (rollup.equals("countDistinct") || rollup.equals("count"));
        status = V5ToCogMDXUtilities.isProjectedNode(node, bFooterHeader);
        if (status) {
            this.traceNodeCondition(status, "The node is projected.", trace);
        } else {
            this.traceNodeCondition(status, "The node is not projected", trace);
        }
        if (status) {
            status = V5ExpressionCheck.canBeCoercedToSet(node);
        }
        if (status) {
            this.traceNodeCondition(status, "The node is a member/level/hierarchy which is child of a V5DataItem which is within a V5Edge.", trace);
        }
        return status;
    }
}

