/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.crosstabspacer;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.actions.CrosstabSpacerDescriptor;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.crosstabspacer.RemoveNoCellValueCrosstabSpacerReplica;
import java.util.ArrayList;
import java.util.List;

public final class RemoveNoCellValueCrosstabSpacer
extends AbstractV5ToCogMDXTransformation {
    public static final String HAS_SPACERS_BEFORE = "hasSpacersBefore";
    public static final String HAS_SPACERS_AFTER = "hasSpacersAfter";

    public RemoveNoCellValueCrosstabSpacer() {
        this.mName = "Handle valueSets flagged with attribute spacer=noCellValue.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5ValueSet v5ValueSet = (V5ValueSet)node;
        V5EdgeGroup parentV5EdgeGroup = (V5EdgeGroup)v5ValueSet.getParent();
        IXQEQueryNode grandParent = parentV5EdgeGroup.getParent();
        V5Edge v5Edge = (V5Edge)v5ValueSet.getAncestorOfType(101049);
        MDXQuery mdxQuery = (MDXQuery)v5Edge.getAncestorOfType(1002);
        int edgeID = v5Edge.getEdgeID();
        mdxQuery.addEdgeWithCrosstabSpacers(edgeID);
        IXQEQueryNode[] v5MemberSetReferences = mdxQuery.getDescendantsOfType(201138, false);
        if (v5MemberSetReferences.length > 0) {
            mdxQuery.setPropertyValue("hasMemberSetReference", Boolean.TRUE);
            return;
        }
        if (RemoveNoCellValueCrosstabSpacer.isTopSpacerWithGroupBody(v5ValueSet, grandParent)) {
            v5ValueSet.setSpacerCellValue(true);
            v5ValueSet.setSpacerNoCellValue(false);
            return;
        }
        v5ValueSet.getRSAPIEdgeRowset().setIsCrosstabSpace(RSAPIEdgeRowset.CrosstabSpaceType.NOCELLVALUE);
        int parentV5EdgeGroupPosition = -1;
        for (int j = 0; j < grandParent.getNumberChildren(); ++j) {
            if (grandParent.getChild(j) != parentV5EdgeGroup) continue;
            parentV5EdgeGroupPosition = j;
            break;
        }
        ArrayList<V5EdgeGroup> consecutiveSpacerList = new ArrayList<V5EdgeGroup>();
        int crosstabSpacerCoordinatesPosition = -1;
        List<RSAPIEdgeRowset> neighborList1 = this.findPreviousNeighbors(grandParent, parentV5EdgeGroupPosition);
        List<RSAPIEdgeRowset> neighborList2 = this.findFollowingNeighbors(grandParent, parentV5EdgeGroupPosition);
        this.findConsecutiveSpacers(parentV5EdgeGroup, grandParent, parentV5EdgeGroupPosition, consecutiveSpacerList);
        List<RSAPIEdgeRowset> rowsetList1 = null;
        List<RSAPIEdgeRowset> rowsetList2 = null;
        if (neighborList1 == null && neighborList2 != null) {
            crosstabSpacerCoordinatesPosition = 1;
            rowsetList1 = neighborList2;
        } else if (neighborList1 != null && neighborList2 != null) {
            crosstabSpacerCoordinatesPosition = 2;
            rowsetList1 = neighborList1;
            rowsetList2 = neighborList2;
        } else if (neighborList1 != null && neighborList2 == null) {
            crosstabSpacerCoordinatesPosition = 0;
            rowsetList1 = neighborList1;
        }
        if (rowsetList1 == null) {
            if (parentV5EdgeGroup.getParent().getType() != 101050 && parentV5EdgeGroup.getNumberChildren() == 1) {
                v5ValueSet.setSpacerCellValue(true);
                v5ValueSet.setSpacerNoCellValue(false);
                return;
            }
            if (parentV5EdgeGroup.getNumberChildren() == 1) {
                crosstabSpacerCoordinatesPosition = 4;
                CrosstabSpacerDescriptor spacer = new CrosstabSpacerDescriptor();
                spacer.setRSAPIEdgeRowset(v5ValueSet.getRSAPIEdgeRowset());
                ((V5EdgeGroup)grandParent).setSpacer(spacer);
                spacer.setCoordinates(crosstabSpacerCoordinatesPosition, rowsetList1, rowsetList2);
            } else {
                if (RemoveNoCellValueCrosstabSpacerReplica.isSpacerNestingV5EdgeGroups(parentV5EdgeGroup)) {
                    grandParent.setPropertyValue("isNotApplicable.", Boolean.TRUE);
                }
                consecutiveSpacerList.clear();
                consecutiveSpacerList.add(parentV5EdgeGroup);
                this.buildAboveSpacerDescriptors(v5ValueSet, parentV5EdgeGroup, grandParent);
            }
        } else if (parentV5EdgeGroup.getNumberChildren() == 1) {
            for (V5EdgeGroup consecutiveSpacer : consecutiveSpacerList) {
                CrosstabSpacerDescriptor spacer = new CrosstabSpacerDescriptor();
                V5ValueSet spacerV5ValueSet = (V5ValueSet)consecutiveSpacer.getChild(0);
                spacer.setRSAPIEdgeRowset(spacerV5ValueSet.getRSAPIEdgeRowset());
                spacer.setCoordinates(crosstabSpacerCoordinatesPosition, rowsetList1, rowsetList2);
                if (parentV5EdgeGroup.getParent().getType() == 101050) {
                    ((V5EdgeGroup)grandParent).setSpacer(spacer);
                    continue;
                }
                ((V5Edge)grandParent).setSpacer(spacer);
            }
        } else {
            if (RemoveNoCellValueCrosstabSpacerReplica.isSpacerNestingV5EdgeGroups(parentV5EdgeGroup)) {
                grandParent.setPropertyValue("isNotApplicable.", Boolean.TRUE);
            }
            consecutiveSpacerList.clear();
            consecutiveSpacerList.add(parentV5EdgeGroup);
            this.buildAboveSpacerDescriptors(v5ValueSet, parentV5EdgeGroup, grandParent);
        }
        for (V5EdgeGroup consecutiveSpacer : consecutiveSpacerList) {
            if (consecutiveSpacer.getNumberChildren() == 1) {
                consecutiveSpacer.detach();
                continue;
            }
            consecutiveSpacer.detachChild(0);
            consecutiveSpacer.extract();
        }
    }

    private void buildAboveSpacerDescriptors(V5ValueSet v5ValueSet, V5EdgeGroup parentV5EdgeGroup, IXQEQueryNode grandParent) {
        for (int i = 1; i < parentV5EdgeGroup.getNumberChildren(); ++i) {
            CrosstabSpacerDescriptor spacerDescriptor = new CrosstabSpacerDescriptor();
            spacerDescriptor.setRSAPIEdgeRowset(v5ValueSet.getRSAPIEdgeRowset());
            V5ValueSet neighbor = (V5ValueSet)((V5EdgeGroup)parentV5EdgeGroup.getChild(i)).getChild(0);
            ArrayList<RSAPIEdgeRowset> neighborList = new ArrayList<RSAPIEdgeRowset>();
            neighborList.add(neighbor.getRSAPIEdgeRowset());
            spacerDescriptor.setCoordinates(3, neighborList, null);
            if (parentV5EdgeGroup.getParent().getType() == 101050) {
                ((V5EdgeGroup)grandParent).setSpacer(spacerDescriptor);
                continue;
            }
            spacerDescriptor.setTopNode(true);
            ((V5Edge)grandParent).setSpacer(spacerDescriptor);
        }
    }

    private List<RSAPIEdgeRowset> findFollowingNeighbors(IXQEQueryNode grandParent, int parentV5EdgeGroupPosition) {
        int neighneighborIndex = parentV5EdgeGroupPosition + 1;
        ArrayList<RSAPIEdgeRowset> neighborList = null;
        boolean foundNeighbors = false;
        while (neighneighborIndex < grandParent.getNumberChildren()) {
            V5ValueSet neighbor = null;
            neighbor = (V5ValueSet)((V5EdgeGroup)grandParent.getChild(neighneighborIndex)).getChild(0);
            if (neighbor.isSpacerNoCellValue()) {
                if (foundNeighbors) break;
                neighbor = null;
                ++neighneighborIndex;
                continue;
            }
            if (neighbor.getPropertyValue(HAS_SPACERS_BEFORE) == Boolean.TRUE) break;
            foundNeighbors = true;
            if (neighborList == null) {
                neighborList = new ArrayList<RSAPIEdgeRowset>();
            }
            neighborList.add(neighbor.getRSAPIEdgeRowset());
            ++neighneighborIndex;
            neighbor.setPropertyValue(HAS_SPACERS_BEFORE, Boolean.TRUE);
        }
        return neighborList;
    }

    private List<RSAPIEdgeRowset> findPreviousNeighbors(IXQEQueryNode grandParent, int parentV5EdgeGroupPosition) {
        int neighneighborIndex = parentV5EdgeGroupPosition - 1;
        ArrayList<RSAPIEdgeRowset> neighborList = null;
        boolean foundNeighbors = false;
        while (neighneighborIndex >= 0 && neighneighborIndex < grandParent.getNumberChildren()) {
            V5ValueSet neighbor = null;
            if (grandParent.getChild(neighneighborIndex).getType() == 101057) break;
            neighbor = (V5ValueSet)((V5EdgeGroup)grandParent.getChild(neighneighborIndex)).getChild(0);
            if (neighbor.isSpacerNoCellValue()) {
                if (foundNeighbors) break;
                neighbor = null;
                --neighneighborIndex;
                continue;
            }
            if (neighbor.getPropertyValue(HAS_SPACERS_AFTER) == Boolean.TRUE) break;
            foundNeighbors = true;
            if (neighborList == null) {
                neighborList = new ArrayList<RSAPIEdgeRowset>();
            }
            neighborList.add(neighbor.getRSAPIEdgeRowset());
            --neighneighborIndex;
            neighbor.setPropertyValue(HAS_SPACERS_AFTER, Boolean.TRUE);
        }
        return neighborList;
    }

    private void findConsecutiveSpacers(V5EdgeGroup targetV5EdgeGroup, IXQEQueryNode grandParent, int parentV5EdgeGroupPosition, List<V5EdgeGroup> consecutiveSpacerList) {
        V5ValueSet neighbor;
        int neighneighborIndex;
        for (neighneighborIndex = parentV5EdgeGroupPosition - 1; neighneighborIndex >= 0 && neighneighborIndex < grandParent.getNumberChildren(); --neighneighborIndex) {
            neighbor = null;
            if (grandParent.getChild(neighneighborIndex).getType() == 101057 || !(neighbor = (V5ValueSet)((V5EdgeGroup)grandParent.getChild(neighneighborIndex)).getChild(0)).isSpacerNoCellValue()) break;
            neighbor.getRSAPIEdgeRowset().setIsCrosstabSpace(RSAPIEdgeRowset.CrosstabSpaceType.NOCELLVALUE);
            neighbor = null;
            consecutiveSpacerList.add((V5EdgeGroup)grandParent.getChild(neighneighborIndex));
        }
        consecutiveSpacerList.add(targetV5EdgeGroup);
        for (neighneighborIndex = parentV5EdgeGroupPosition + 1; neighneighborIndex < grandParent.getNumberChildren(); ++neighneighborIndex) {
            neighbor = null;
            neighbor = (V5ValueSet)((V5EdgeGroup)grandParent.getChild(neighneighborIndex)).getChild(0);
            if (!neighbor.isSpacerNoCellValue()) break;
            neighbor = null;
            consecutiveSpacerList.add((V5EdgeGroup)grandParent.getChild(neighneighborIndex));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5ValueSet v5ValueSet = (V5ValueSet)node;
        if (!v5ValueSet.isSpacerNoCellValue()) {
            this.traceNodeCondition(false, "The value set is not a crosstab spacer with no cell value.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)v5ValueSet.getAncestorOfType(1002);
        if (mdxQuery.getPropertyValue("hasMemberSetReference") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Found a V5 MemberSet reference.", trace);
            return false;
        }
        V5Edge v5Edge = (V5Edge)v5ValueSet.getAncestorOfType(101049);
        if (!v5Edge.handleCrossTabSpaces()) {
            this.traceNodeCondition(false, "The transformation is not applicable.", trace);
            return false;
        }
        V5EdgeGroup parentV5EdgeGroup = (V5EdgeGroup)v5ValueSet.getParent();
        IXQEQueryNode ancestorV5EdgeGroup = parentV5EdgeGroup.getParent();
        if (RemoveNoCellValueCrosstabSpacerReplica.isSingleSpacerNestingV5EdgeGroups(parentV5EdgeGroup)) {
            this.traceNodeCondition(false, "The spacer value set can be handled as a replica.", trace);
            return false;
        }
        if (!RemoveNoCellValueCrosstabSpacerReplica.isSpacerNestingV5EdgeGroups(parentV5EdgeGroup)) {
            for (IXQEQueryNode child : ancestorV5EdgeGroup.getChildren()) {
                V5ValueSet currValueSet;
                if (child == parentV5EdgeGroup || child.getType() == 101057 || !(currValueSet = (V5ValueSet)((V5EdgeGroup)child).getChild(0)).isSpacerNoCellValue() || !RemoveNoCellValueCrosstabSpacerReplica.isSpacerNestingV5EdgeGroups((V5EdgeGroup)child)) continue;
                this.traceNodeCondition(true, "Spacers nesting edge groups need to be processed first.", trace);
                return false;
            }
        }
        while (ancestorV5EdgeGroup.getType() == 101050) {
            V5ValueSet ancestorV5ValueSet = (V5ValueSet)ancestorV5EdgeGroup.getChild(0);
            if (ancestorV5ValueSet.isSpacerNoCellValue()) {
                this.traceNodeCondition(false, "Nested no cell value spacers, wait.", trace);
                return false;
            }
            ancestorV5EdgeGroup = ancestorV5EdgeGroup.getParent();
        }
        this.traceNodeCondition(true, "The value set is a crosstab spacer with no cell value.", trace);
        return true;
    }

    protected static boolean isTopSpacerWithGroupBody(V5ValueSet v5ValueSet, IXQEQueryNode grandParent) {
        if (grandParent.getType() == 101049) {
            return RemoveNoCellValueCrosstabSpacer.hasGroupBody(v5ValueSet);
        }
        return false;
    }

    private static boolean hasGroupBody(V5ValueSet v5ValueSet) {
        return v5ValueSet.getChildrenOfType(101051).length > 0;
    }
}

