/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.decoration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPHierarchyDecoration;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.decoration.V5DecorationUtils;

public final class InitializeGroupedV5ValueSetDecoration
extends AbstractV5ToCogMDXTransformation {
    public InitializeGroupedV5ValueSetDecoration() {
        this.mName = "Create grouped V5ValueSet decoration.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode query = node.getAncestorOfType(1002);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        RSAPIDataItem rsapiRefDataItem = (RSAPIDataItem)node.getPropertyValue("RSAPIRefDataItem");
        RSAPIEdgeRowset rsapiRowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        OLAPHierarchyDecoration hierDeco = null;
        hierDeco = V5DecorationUtils.insertHierarchyDecorationNode(node, environment, rsapiRowset, rsapiRefDataItem);
        ((V5ValueSet)node).setOLAPHierarchyDecorationProperty(hierDeco);
        boolean includeSelf = false;
        IXQEQueryNode[] allV5Valuesets = query.getDescendantsOfType(101057, includeSelf);
        for (int i = 0; i < allV5Valuesets.length; ++i) {
            V5ValueSet currV5Valueset = (V5ValueSet)allV5Valuesets[i];
            if (!currV5Valueset.isCloneOf().equals(node.getId())) continue;
            V5DecorationUtils.transferV5ValueSetDecoration(nodeFactory, (V5ValueSet)node, currV5Valueset);
        }
    }

    public boolean isDefaultMemberSet(V5ValueSet valueset) {
        boolean isDefaultMemberSet = false;
        if (valueset.getNumberChildren() > 0 && valueset.getChild(0).getType() == 201101) {
            V5SetFunction setFunction = (V5SetFunction)valueset.getChild(0);
            isDefaultMemberSet = setFunction.getNumberChildren() > 0 && setFunction.getChild(0).getType() == 201061;
        }
        return isDefaultMemberSet;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("refDataItem") == null) {
            this.traceNodeCondition(false, "The V5ValueSet node has no refDataItem property.", trace);
            return false;
        }
        if (((V5ValueSet)node).isClonedEdgeGroup()) {
            this.traceNodeCondition(false, "The V5ValueSet node is part of a cloned EdgeGroup.", trace);
            return false;
        }
        if (((V5ValueSet)node).getOLAPHierarchyDecorationProperty() != null) {
            this.traceNodeCondition(false, "The V5ValueSet node has already been processed.", trace);
            return false;
        }
        IHierarchy hierarchy = (IHierarchy)node.getPropertyValue("normalizationHierarchy");
        if (hierarchy == null) {
            RSAPIDataItem rsapiRefDataItem = (RSAPIDataItem)node.getPropertyValue("RSAPIRefDataItem");
            RSAPIEdgeRowset rsapiRowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
            if (rsapiRefDataItem == null || rsapiRowset == null) {
                this.traceNodeCondition(false, "The V5ValueSet node has missing info or do not need to be processed.", trace);
                return false;
            }
        } else {
            IXQEQueryNode parentValueSet = node.getAncestorOfType(101057);
            if (parentValueSet != null && parentValueSet.getPropertyValue("olapDecorationRef") == null) {
                this.traceNodeCondition(false, "ValueSet needs parent ValueSet decoration information which has not been set.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "Need to create the default decoration for this value set.", trace);
        return true;
    }
}

