/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.decoration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPHierarchyDecoration;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.decoration.V5DecorationUtils;

public final class InitializeUnGroupedV5ValueSetDecoration
extends AbstractV5ToCogMDXTransformation {
    public InitializeUnGroupedV5ValueSetDecoration() {
        this.mName = "Create ungrouped V5ValueSet decoration.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5GroupBody groupBody = (V5GroupBody)node.getChildrenOfType(101051)[0];
        IXQEQueryNode[] dataItemRefs = groupBody.getChildrenOfTypeOrdered(101015);
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        for (int i = 0; i < dataItemRefs.length; ++i) {
            RSAPIDataItem rsapiRefDataItem = (RSAPIDataItem)dataItemRefs[i].getPropertyValue("RSAPIRefDataItem");
            OLAPHierarchyDecoration hierDeco = V5DecorationUtils.insertHierarchyDecorationNode(node, environment, rowset, rsapiRefDataItem);
            ((V5DataItemRef)dataItemRefs[i]).setOLAPHierarchyDecorationProperty(hierDeco);
            ((V5DataItemRef)dataItemRefs[i]).setRSAPIEdgeRowset(rowset);
            IXQEQueryNode query = node.getAncestorOfType(1002);
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            boolean includeSelf = false;
            IXQEQueryNode[] allV5Valuesets = query.getDescendantsOfType(101057, includeSelf);
            for (int j = 0; j < allV5Valuesets.length; ++j) {
                V5ValueSet currV5Valueset = (V5ValueSet)allV5Valuesets[j];
                if (!currV5Valueset.isCloneOf().equals(node.getId())) continue;
                V5DecorationUtils.transferV5ValueSetDecoration(nodeFactory, (V5ValueSet)node, currV5Valueset);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue("refDataItem") != null) {
            this.traceNodeCondition(false, "The V5ValueSet node has a refDataItem property.", trace);
            return false;
        }
        if (((V5ValueSet)node).isClonedEdgeGroup()) {
            this.traceNodeCondition(false, "The V5ValueSet node is part of a cloned EdgeGroup.", trace);
            return false;
        }
        IXQEQueryNode[] groupBodyNodes = node.getChildrenOfType(101051);
        if (groupBodyNodes.length != 1) {
            this.traceNodeCondition(false, "The V5ValueSet node does not have a single V5GroupBody child node.", trace);
            return false;
        }
        V5GroupBody groupBody = (V5GroupBody)groupBodyNodes[0];
        IXQEQueryNode[] dataItemRefs = groupBody.getChildrenOfType(101015);
        if (dataItemRefs.length == 0) {
            this.traceNodeCondition(false, "The V5GroupBody child node does not have any V5DataItemRef children.", trace);
            return false;
        }
        RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)node.getPropertyValue("RSAPIEdgeRowset");
        if (rowset == null) {
            this.traceNodeCondition(false, "The RSAPI rowset information is missing.", trace);
            return false;
        }
        for (int i = 0; i < dataItemRefs.length; ++i) {
            RSAPIDataItem rsapiRefDataItem = (RSAPIDataItem)dataItemRefs[i].getPropertyValue("RSAPIRefDataItem");
            if (rsapiRefDataItem == null) {
                this.traceNodeCondition(false, "The RSAPI data item reference information is missing.", trace);
                return false;
            }
            if (((V5DataItemRef)dataItemRefs[i]).getOLAPHierarchyDecorationProperty() == null) continue;
            this.traceNodeCondition(false, "The V5ValueSet node has already been processed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The V5GroupBody child node has at least one V5DataItemRef child node.", trace);
        return true;
    }
}

