/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization.PatternHierInfoNode;
import com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization.PatternHierResolver;
import java.util.ArrayList;
import java.util.List;

public final class CreateV5EdgePatternHierInfo
extends AbstractV5ToCogMDXTransformation {
    public CreateV5EdgePatternHierInfo() {
        this.mName = "Create the V5Edge PatternHierInfo Property.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101049};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXHierInfo patternHierInfo = null;
        IXQEQueryNode[] v5EdgeGroups = node.getChildrenOfType(101050);
        patternHierInfo = v5EdgeGroups.length == 1 && ((V5EdgeGroup)v5EdgeGroups[0]).isDetailGroup() ? new MDXHierInfo() : this.getPatternHierInfo((V5Edge)node);
        if (patternHierInfo == null) {
            Integer edgeId = ((V5Edge)node).getEdgeID();
            throw new XQERuntimeException(XQEMessageKeys.PLN_FailToCreateV5EdgePatternHierInfo, edgeId.toString());
        }
        ((V5Edge)node).setPropertyPatternHierInfo(patternHierInfo);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String traceMsg = "";
        MDXHierInfo patternHierInfo = ((V5Edge)node).getPropertyPatternHierInfo();
        boolean bl = status = patternHierInfo == null;
        if (status) {
            traceMsg = "The V5Edge patternHierInfo property has not been set yet for this node";
            IXQEQueryNode[] v5EdgeGroups = node.getChildrenOfType(101050);
            boolean bl2 = status = v5EdgeGroups.length > 0;
            if (!status) {
                traceMsg = traceMsg + " The V5Edge contains none V5EdgeGroup.";
            } else {
                traceMsg = traceMsg + " The V5Edge contains at least one V5EdgeGroup.";
                Integer hierarchyDepth = ((V5EdgeGroup)v5EdgeGroups[0]).getPropertyHierarchyDepth();
                boolean bl3 = status = hierarchyDepth != null;
                traceMsg = status ? traceMsg + " The V5EdgeGroup hierarchyDepth property has been set already." : traceMsg + " The V5EdgeGroup hierarchyDepth property has not been set yet.";
            }
        } else {
            traceMsg = "The V5Edge patternHierInfo property has been set already for this node";
        }
        this.traceNodeCondition(status, traceMsg, trace);
        return status;
    }

    public MDXHierInfo getPatternHierInfo(V5Edge v5Edge) {
        List<IHierarchy> currHiersAtDepth;
        PatternHierResolver resolver = new PatternHierResolver(v5Edge);
        resolver.buildTree(v5Edge, resolver.getPatternHierInfoRoot(), null);
        resolver.refineTree(v5Edge);
        ArrayList<PatternHierInfoNode> patternHierInfoNodesAboveDepth = new ArrayList<PatternHierInfoNode>();
        patternHierInfoNodesAboveDepth.add(resolver.getPatternHierInfoRoot());
        MDXHierInfo patternHierInfo = new MDXHierInfo();
        int i = 1;
        while (!(currHiersAtDepth = resolver.getPatternHierarchiesAtDepths(i, patternHierInfoNodesAboveDepth)).isEmpty()) {
            for (IHierarchy currHierarchy : currHiersAtDepth) {
                if (patternHierInfo.getProjectedHierarchies().contains(currHierarchy)) continue;
                patternHierInfo.appendProjectedHierarchy(currHierarchy);
            }
            ++i;
        }
        return patternHierInfo;
    }
}

