/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;

public class HandleEdgeGroupWithValueSetsFromDiffHierarchies
extends AbstractV5ToCogMDXTransformation {
    public HandleEdgeGroupWithValueSetsFromDiffHierarchies() {
        this.mName = "Handle V5EdgeGroup With V5ValueSets From Different Hierarchies.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] valueSets = node.getChildrenOfTypeOrdered(101057);
        int firstValueSetPos = node.getPositionOfChild(valueSets[0]);
        for (int i = 0; i < valueSets.length; ++i) {
            node.detachChild(valueSets[i]);
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        int edgeGroupPos = node.getParent().getPositionOfChild(node);
        for (int i = 1; i < valueSets.length; ++i) {
            IXQEQueryNode newEdgeGroup = nodeFactory.deepCopyNode(node);
            newEdgeGroup.addChild(valueSets[i], firstValueSetPos);
            node.getParent().addChild(newEdgeGroup, edgeGroupPos + i);
        }
        node.addChild(valueSets[0], firstValueSetPos);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        StringBuilder traceMsg = new StringBuilder();
        V5EdgeGroup v5EdgeGroup = (V5EdgeGroup)node;
        IXQEQueryNode[] vsets = v5EdgeGroup.getChildrenOfTypeOrdered(101057);
        if (vsets.length > 1) {
            MDXHierInfo hierInfo = ((V5ValueSet)vsets[0]).getHierarchyInfo();
            for (int i = 1; i < vsets.length; ++i) {
                MDXHierInfo aHierInfo = ((V5ValueSet)vsets[i]).getHierarchyInfo();
                hierInfo.unionHierInfo(aHierInfo);
                if (hierInfo.getNumProjectedHierarchies() <= 1) continue;
                status = true;
                break;
            }
        }
        if (status) {
            traceMsg.append("The target node references at least two different hierarchies.");
        } else {
            traceMsg.append("The target node either references a single hierarchy or contains a V5ValueSet with no refDataItem.");
        }
        this.traceNodeCondition(status, traceMsg.toString(), trace);
        return status;
    }
}

