/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5DefaultMemberFunction;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.HashSet;
import java.util.List;

public final class NormalizeEdgeHierarchies
extends AbstractV5ToCogMDXTransformation {
    protected static final String HIERARCHY_NORMALIZATION_DONE = "hierarchyNormalizationDone";
    private static final String APOSTROPHE = "'";
    private static final String PERIOD = ".";
    private static final String COMMA = ",";
    public static final String UNDERSCORE = "_";
    public static final int INSERT_ABOVE = 1;
    public static final int INSERT_BELOW = 2;

    public NormalizeEdgeHierarchies() {
        this.mName = "Normalize edge hierarchies.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101049};
    }

    private static void appendDefaultMemberNode(V5EdgeGroup v5EdgeGroup, MDXHierInfo patternHierInfo, PlanningEnvironment environment) {
        V5EdgeGroup topV5EdgeGroup = v5EdgeGroup;
        V5EdgeGroup parentV5EdgeGroup = (V5EdgeGroup)topV5EdgeGroup.getAncestorOfType(101050);
        IXQEQueryNode[] v5EdgeGroups = topV5EdgeGroup.getChildrenOfType(101050);
        IHierarchy topV5EdgeGroupHierarchy = topV5EdgeGroup.getPropertyHierarchy();
        if (parentV5EdgeGroup != null && topV5EdgeGroupHierarchy != null && parentV5EdgeGroup.getPropertyHierarchy() != null && topV5EdgeGroupHierarchy.equals(parentV5EdgeGroup.getPropertyHierarchy()) && v5EdgeGroups.length > 0) {
            return;
        }
        int patternHierId = 0;
        if (parentV5EdgeGroup != null) {
            IHierarchy parentV5EdgeHierarchy = parentV5EdgeGroup.getPropertyHierarchy();
            patternHierId = parentV5EdgeHierarchy.isShell() ? parentV5EdgeGroup.getPropertyHierarchyDepth() - 1 : patternHierInfo.getProjectedHierarchyIndex(parentV5EdgeHierarchy);
            ++patternHierId;
        }
        if (topV5EdgeGroupHierarchy.isShell() && topV5EdgeGroup.getNumberChildren() == 1) {
            return;
        }
        IXQEQueryNode[] v5EdgeGroups1 = new IXQEQueryNode[]{v5EdgeGroup};
        List<V5EdgeGroup> nestedv5EdgeGroups1 = V5Edge.getDiffHierarchyNestedEdgeGroups(v5EdgeGroups1);
        while (patternHierId < patternHierInfo.getNumProjectedHierarchies()) {
            block6: {
                int patternHierPos;
                int whereToAppend;
                IHierarchy patternHierarchy;
                block7: {
                    block9: {
                        int v5EdgeGroupHierPos;
                        block8: {
                            IHierarchy v5EdgeGroupHierarchy;
                            block5: {
                                patternHierarchy = patternHierInfo.getProjectedHierarchy(patternHierId);
                                v5EdgeGroupHierarchy = v5EdgeGroup.getPropertyHierarchy();
                                whereToAppend = 1;
                                patternHierPos = patternHierInfo.getProjectedHierarchyIndex(patternHierarchy);
                                if (v5EdgeGroupHierarchy != null && (!v5EdgeGroupHierarchy.isShell() || patternHierInfo.projectsHierarchy(v5EdgeGroupHierarchy))) break block5;
                                int depth2 = NormalizeEdgeHierarchies.recomputeHierarchyDepth(v5EdgeGroup, patternHierInfo);
                                if (patternHierPos == depth2) break block6;
                                if (patternHierPos <= depth2) break block7;
                                if (!nestedv5EdgeGroups1.isEmpty()) break;
                                whereToAppend = 2;
                                break block7;
                            }
                            v5EdgeGroupHierPos = patternHierInfo.getProjectedHierarchyIndex(v5EdgeGroupHierarchy);
                            if (patternHierPos >= v5EdgeGroupHierPos) break block8;
                            whereToAppend = 1;
                            break block7;
                        }
                        if (patternHierPos <= v5EdgeGroupHierPos) break block9;
                        if (nestedv5EdgeGroups1.isEmpty()) {
                            whereToAppend = 2;
                        }
                        break block7;
                    }
                    NormalizeEdgeHierarchies.insertCurrentMemberAboveIfRequired(v5EdgeGroup, topV5EdgeGroup, patternHierInfo, environment);
                    if (!nestedv5EdgeGroups1.isEmpty()) break;
                    break block6;
                }
                NormalizeEdgeHierarchies.insertNormalizationEdgeGroup(201061, v5EdgeGroup, whereToAppend, patternHierarchy, patternHierPos, environment);
            }
            ++patternHierId;
        }
    }

    private static int recomputeHierarchyDepth(V5EdgeGroup v5EdgeGroup, MDXHierInfo patternHierInfo) {
        IXQEQueryNode[] nodes;
        IXQEQueryNode[] ancestors = v5EdgeGroup.getAncestorsOfType(v5EdgeGroup.getType());
        HashSet<IHierarchy> hierarchySet = new HashSet<IHierarchy>();
        int i = 0;
        for (i = 0; i < ancestors.length; ++i) {
            IHierarchy edgeGroupHierarchy = ((V5EdgeGroup)ancestors[i]).getPropertyHierarchy();
            if (edgeGroupHierarchy == null) continue;
            hierarchySet.add(edgeGroupHierarchy);
        }
        int depth = hierarchySet.size();
        int measurePos = -1;
        for (i = depth + 1; i < patternHierInfo.getNumProjectedHierarchies(); ++i) {
            IHierarchy patternHierarchy = patternHierInfo.getProjectedHierarchy(i);
            if (patternHierarchy.isShell() || !patternHierarchy.getDimension().isMeasuresDimension()) continue;
            measurePos = i;
            break;
        }
        if (measurePos != -1 && (nodes = v5EdgeGroup.getDescendantsOfType(v5EdgeGroup.getType(), false)).length == 0) {
            depth = measurePos;
        }
        return depth;
    }

    private static boolean insertCurrentMemberAboveIfRequired(V5EdgeGroup v5EdgeGroup, V5EdgeGroup topV5EdgeGroup, MDXHierInfo patternHierInfo, PlanningEnvironment environment) {
        int i;
        V5EdgeGroup parentV5EdgeGroup = (V5EdgeGroup)v5EdgeGroup.getAncestorOfType(101050);
        if (parentV5EdgeGroup == null) {
            return false;
        }
        IHierarchy parentV5EdgeHierarchy = parentV5EdgeGroup.getPropertyHierarchy();
        if (v5EdgeGroup.getPropertyHierarchy().equals(parentV5EdgeHierarchy)) {
            return false;
        }
        IXQEQueryNode[] v5EdgeGroups = parentV5EdgeGroup.getChildrenOfTypeOrdered(101050);
        for (i = 0; i < v5EdgeGroups.length && !parentV5EdgeHierarchy.equals(((V5EdgeGroup)v5EdgeGroups[i]).getPropertyHierarchy()); ++i) {
        }
        if (i == v5EdgeGroups.length) {
            return true;
        }
        int whereToAppend = 1;
        int patternHierPos = 0;
        if (patternHierInfo.projectsHierarchy(parentV5EdgeHierarchy)) {
            patternHierPos = patternHierInfo.getProjectedHierarchyIndex(parentV5EdgeHierarchy);
        }
        NormalizeEdgeHierarchies.insertNormalizationEdgeGroup(201059, v5EdgeGroup, whereToAppend, parentV5EdgeHierarchy, patternHierPos, environment);
        return true;
    }

    public static void insertNormalizationEdgeGroup(int fcn, V5EdgeGroup v5EdgeGroup, int whereToAppend, IHierarchy patternHierarchy, int patternHierPos, PlanningEnvironment environment) {
        boolean setNormalizationHierarchy;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode v5QuerySet = v5EdgeGroup.getAncestorOfType(101002);
        IXQEQueryNode mdxQuery = v5EdgeGroup.getAncestorOfType(1002);
        String refV5Query = ((MDXQuery)mdxQuery).getRefQueryProperty();
        V5Query v5Query = ((V5QuerySet)v5QuerySet).getV5Query(refV5Query);
        V5Selection v5Selection = v5Query.getV5Selection();
        IXQEQueryNode v5DataItem = nodeFactory.createNode(101003);
        Integer iDepth = XQEIntegerPool.getInteger(patternHierPos);
        String fcnName = fcn == 201061 ? "defaultMember" : "currentMember";
        StringBuilder propertyValue = new StringBuilder(fcnName);
        propertyValue.append(UNDERSCORE);
        propertyValue.append(patternHierarchy.getUniqueName());
        propertyValue.append(UNDERSCORE);
        propertyValue.append(v5EdgeGroup.getId().toString());
        propertyValue.append(UNDERSCORE);
        propertyValue.append(iDepth.toString());
        v5DataItem.setPropertyValue("name", propertyValue.toString());
        v5DataItem.setPropertyValue("label", propertyValue.toString());
        v5Selection.addChild(v5DataItem);
        IXQEQueryNode v5Set = nodeFactory.createNode(201101);
        IXQEQueryNode v5DefMember = nodeFactory.createNode(fcn);
        if (fcn == 201061) {
            ((V5DefaultMemberFunction)v5DefMember).setPropertyIsNoMember(true);
        }
        v5Set.addChild(v5DefMember);
        IXQEQueryNode v5Hierarchy = nodeFactory.createNode(201116);
        ((V5BoundModelIdentifier)v5Hierarchy).setMetadata(patternHierarchy);
        v5DefMember.addChild(v5Hierarchy);
        V5ValueSet v5ValueSet = (V5ValueSet)nodeFactory.createNode(101057);
        v5ValueSet.addChild(v5Set);
        v5ValueSet.setRefDataItemProperty(propertyValue.toString());
        boolean bl = setNormalizationHierarchy = whereToAppend == 1;
        if (whereToAppend == 2) {
            V5ValueSet originalValueSet = null;
            IXQEQueryNode edgeGroupChild = v5EdgeGroup.getChild(0);
            while (edgeGroupChild.getType() != 101057) {
                edgeGroupChild = edgeGroupChild.getChild(0);
            }
            originalValueSet = (V5ValueSet)edgeGroupChild;
            boolean bl2 = setNormalizationHierarchy = originalValueSet.getPropertyValue("normalizationHierarchy") != null;
            if (!setNormalizationHierarchy) {
                IXQEQueryNode childExpr = originalValueSet.getChild(0);
                while (!childExpr.isOfCategory(201120)) {
                    childExpr = childExpr.getChild(0);
                }
                boolean isValueExpression = (childExpr = V5ToCogMDXUtilities.getChildOverSet(childExpr, 201101)).isOfCategory(201125) || childExpr.getType() == 201085;
                boolean bl3 = setNormalizationHierarchy = !isValueExpression;
            }
        }
        if (setNormalizationHierarchy) {
            v5ValueSet.setPropertyValue("normalizationHierarchy", patternHierarchy);
        }
        V5EdgeGroup dmV5EdgeGroup = (V5EdgeGroup)nodeFactory.createNode(101050);
        dmV5EdgeGroup.setPropertyHierarchyDepth(iDepth);
        dmV5EdgeGroup.addChild(v5ValueSet);
        v5Set = nodeFactory.deepCopyNode(v5Set);
        v5DataItem.addChild(v5Set);
        dmV5EdgeGroup.setPropertyHierarchy(dmV5EdgeGroup.getEdgeGroupHierarchy());
        IXQEQueryNode v5EdgeGroupParent = v5EdgeGroup.getParent();
        if (whereToAppend == 1) {
            v5EdgeGroupParent.exchangeChildNode(v5EdgeGroup, dmV5EdgeGroup);
            dmV5EdgeGroup.addChild(v5EdgeGroup);
        } else if (whereToAppend == 2) {
            IXQEQueryNode[] v5EdgeGroups2 = new IXQEQueryNode[]{v5EdgeGroup};
            List<V5EdgeGroup> nestedv5EdgeGroups2 = V5Edge.getNextedEdgeGroups(v5EdgeGroups2);
            IXQEQueryNode[] tmpArray = v5EdgeGroups2;
            while (!nestedv5EdgeGroups2.isEmpty()) {
                v5EdgeGroups2 = tmpArray;
                nestedv5EdgeGroups2 = V5Edge.getNextedEdgeGroups(v5EdgeGroups2);
                tmpArray = new IXQEQueryNode[nestedv5EdgeGroups2.size()];
                tmpArray = nestedv5EdgeGroups2.toArray(tmpArray);
            }
            for (int i = 0; i < v5EdgeGroups2.length; ++i) {
                IXQEQueryNode dmV5EdgeGroupCpy = null;
                dmV5EdgeGroupCpy = i == 0 ? dmV5EdgeGroup : nodeFactory.deepCopyNode(dmV5EdgeGroup);
                v5EdgeGroups2[i].addChild(dmV5EdgeGroupCpy);
            }
        }
    }

    private void normalizeHierarchyForV5EdgeGroup(V5EdgeGroup v5EdgeGroup, MDXHierInfo patternHierInfo, PlanningEnvironment environment) {
        IXQEQueryNode[] nestedV5EdgeGroups = v5EdgeGroup.getChildrenOfTypeOrdered(101050);
        NormalizeEdgeHierarchies.appendDefaultMemberNode(v5EdgeGroup, patternHierInfo, environment);
        for (IXQEQueryNode nestedV5EdgeGroup : nestedV5EdgeGroups) {
            this.normalizeHierarchyForV5EdgeGroup((V5EdgeGroup)nestedV5EdgeGroup, patternHierInfo, environment);
        }
        this.insertCurrentMemberNodes(v5EdgeGroup, patternHierInfo, environment);
    }

    private void insertCurrentMemberNodes(V5EdgeGroup v5EdgeGroup, MDXHierInfo patternHierInfo, PlanningEnvironment environment) {
        IXQEQueryNode[] nestedV5EdgeGroups = v5EdgeGroup.getChildrenOfTypeOrdered(101050);
        if (nestedV5EdgeGroups.length <= 1) {
            return;
        }
        IHierarchy v5EdgeGroupHierarchy = this.getV5EdgeGroupFirstHierarchy(v5EdgeGroup);
        boolean currentMemberRequired = false;
        if (v5EdgeGroupHierarchy != null) {
            for (IXQEQueryNode nestedV5EdgeGroup : nestedV5EdgeGroups) {
                IHierarchy nestedV5EdgeGroupHierarchy = this.getV5EdgeGroupFirstHierarchy((V5EdgeGroup)nestedV5EdgeGroup);
                boolean bl = currentMemberRequired = nestedV5EdgeGroupHierarchy != null && nestedV5EdgeGroupHierarchy.equals(v5EdgeGroupHierarchy);
                if (currentMemberRequired) break;
            }
        }
        if (currentMemberRequired) {
            for (IXQEQueryNode nestedV5EdgeGroup : nestedV5EdgeGroups) {
                this.insertCurrentMemeberOrThrowError((V5EdgeGroup)nestedV5EdgeGroup, v5EdgeGroup, patternHierInfo, environment);
            }
        }
    }

    private void insertCurrentMemeberOrThrowError(V5EdgeGroup currentNestedPath, V5EdgeGroup v5EdgeGroup, MDXHierInfo patternHierInfo, PlanningEnvironment environment) {
        IHierarchy valueSetHier;
        MDXHierInfo currHierInfo = currentNestedPath.getHierarchyInfo();
        if (currHierInfo.projectsHierarchy(valueSetHier = this.getV5EdgeGroupFirstHierarchy(v5EdgeGroup))) {
            return;
        }
        boolean foundIssue = true;
        if (!currHierInfo.getProjectedHierarchy(0).isShell()) {
            foundIssue = !NormalizeEdgeHierarchies.insertCurrentMemberAboveIfRequired(currentNestedPath, v5EdgeGroup, patternHierInfo, environment);
        } else if (valueSetHier.isShell()) {
            foundIssue = false;
        } else if (patternHierInfo.projectsHierarchy(valueSetHier) && patternHierInfo.getProjectedHierarchyIndex(valueSetHier) < patternHierInfo.getNumProjectedHierarchies() - 1) {
            boolean bl = foundIssue = !NormalizeEdgeHierarchies.insertCurrentMemberAboveIfRequired(currentNestedPath, v5EdgeGroup, patternHierInfo, environment);
        }
        if (foundIssue) {
            currentNestedPath.throwInternalError("!previousHierInfo.equals(currentHierInfo)");
        }
    }

    private IHierarchy getV5EdgeGroupFirstHierarchy(V5EdgeGroup v5EdgeGroup) {
        V5ValueSet valueSet;
        MDXHierInfo valueSetHierInfo;
        IHierarchy valueSetHier = null;
        IXQEQueryNode[] valueSets = v5EdgeGroup.getChildrenOfType(101057);
        if (valueSets.length > 0 && (valueSetHierInfo = (valueSet = (V5ValueSet)valueSets[0]).getHierarchyInfo()) != null && valueSetHierInfo.getNumProjectedHierarchies() > 0) {
            valueSetHier = valueSetHierInfo.getProjectedHierarchy(0);
        }
        return valueSetHier;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] v5EdgeGroups;
        MDXHierInfo patternHierInfo = ((V5Edge)node).getPropertyPatternHierInfo();
        for (IXQEQueryNode v5EdgeGroup : v5EdgeGroups = node.getChildrenOfTypeOrdered(101050)) {
            this.normalizeHierarchyForV5EdgeGroup((V5EdgeGroup)v5EdgeGroup, patternHierInfo, environment);
        }
        node.setPropertyValue(HIERARCHY_NORMALIZATION_DONE, "true");
    }

    public static boolean compareHierInfoWithDummyHierarchies(MDXHierInfo mdxHierInfo1, MDXHierInfo mdxHierInfo2, boolean tolerateShellLeaf) {
        IHierarchy hierarchy2;
        IHierarchy hierarchy1;
        boolean result;
        MDXHierInfo newHierInfo1 = mdxHierInfo1;
        MDXHierInfo newHierInfo2 = mdxHierInfo2;
        boolean bl = result = newHierInfo1.getNumProjectedHierarchies() == newHierInfo2.getNumProjectedHierarchies();
        if (!result) {
            boolean hasShellInMiddel;
            if (tolerateShellLeaf) {
                if (NormalizeEdgeHierarchies.hierarchiesMatchUpToPositionOfLeafShellInFirst(newHierInfo1, newHierInfo2)) {
                    return true;
                }
                if (NormalizeEdgeHierarchies.hierarchiesMatchUpToPositionOfLeafShellInFirst(newHierInfo2, newHierInfo1)) {
                    return true;
                }
            }
            boolean bl2 = hasShellInMiddel = newHierInfo1.projectsShellHierarchy() || newHierInfo2.projectsShellHierarchy();
            if (hasShellInMiddel) {
                boolean bl3 = hasShellInMiddel = !newHierInfo1.getProjectedHierarchy(newHierInfo1.getNumProjectedHierarchies() - 1).isShell() && !newHierInfo2.getProjectedHierarchy(newHierInfo2.getNumProjectedHierarchies() - 1).isShell();
            }
            if (hasShellInMiddel) {
                newHierInfo1 = new MDXHierInfo();
                newHierInfo1.appendProjectedHierarchies(mdxHierInfo1);
                newHierInfo2 = new MDXHierInfo();
                newHierInfo2.appendProjectedHierarchies(mdxHierInfo2);
                block0: while (newHierInfo1.projectsShellHierarchy()) {
                    for (IHierarchy hier1 : newHierInfo1.getProjectedHierarchies()) {
                        if (!hier1.isShell()) continue;
                        newHierInfo1.removeProjectedHierarchy(hier1);
                        continue block0;
                    }
                }
                block2: while (newHierInfo2.projectsShellHierarchy()) {
                    for (IHierarchy hier2 : newHierInfo2.getProjectedHierarchies()) {
                        if (!hier2.isShell()) continue;
                        newHierInfo2.removeProjectedHierarchy(hier2);
                        continue block2;
                    }
                }
                boolean bl4 = result = newHierInfo1.getNumProjectedHierarchies() == newHierInfo2.getNumProjectedHierarchies();
            }
            if (!result) {
                return result;
            }
        }
        int i = 0;
        for (i = 0; i < newHierInfo1.getNumProjectedHierarchies() && ((hierarchy1 = newHierInfo1.getProjectedHierarchy(i)).equals(hierarchy2 = newHierInfo2.getProjectedHierarchy(i)) || !hierarchy1.isShell() && hierarchy2.isShell() || hierarchy1.isShell() && !hierarchy2.isShell()); ++i) {
        }
        result = i == newHierInfo1.getNumProjectedHierarchies();
        return result;
    }

    private static boolean hierarchiesMatchUpToPositionOfLeafShellInFirst(MDXHierInfo newHierInfo1, MDXHierInfo newHierInfo2) {
        if (newHierInfo1.projectsShellHierarchy() && newHierInfo1.getProjectedHierarchy(newHierInfo1.getNumProjectedHierarchies() - 1).isShell() && newHierInfo1.getNumProjectedHierarchies() < newHierInfo2.getNumProjectedHierarchies()) {
            for (int i = 0; i < newHierInfo1.getNumProjectedHierarchies() - 1; ++i) {
                if (newHierInfo1.getProjectedHierarchy(i).equals(newHierInfo2.getProjectedHierarchy(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkHierarchyNormalization(IXQEQueryNode node, StringBuilder reason, boolean tolerateShellLeaf) {
        boolean normal = true;
        IXQEQueryNode[] v5EdgeGroups = node.getChildrenOfTypeOrdered(101050);
        int i = 0;
        for (i = 0; i < v5EdgeGroups.length && ((V5EdgeGroup)v5EdgeGroups[i]).checkHierarchies(tolerateShellLeaf); ++i) {
        }
        if (i < v5EdgeGroups.length) {
            if (reason != null) {
                reason.append("Found abnormal hierarchies under V5EdgeGroup ");
                reason.append(APOSTROPHE);
                reason.append(v5EdgeGroups[i].getId().toString());
                reason.append(APOSTROPHE);
                reason.append(PERIOD);
            }
            normal = false;
        } else {
            MDXHierInfo hierInfo = ((V5EdgeGroup)v5EdgeGroups[0]).getHierarchyInfo();
            for (i = 1; i < v5EdgeGroups.length; ++i) {
                Integer hierarchyDepth = ((V5EdgeGroup)v5EdgeGroups[i]).getPropertyHierarchyDepth();
                if (hierarchyDepth == null) {
                    if (reason != null) {
                        reason.append("Found an internal error. The hierarchyDepth property of V5EdgeGroup ");
                        reason.append(APOSTROPHE);
                        reason.append(v5EdgeGroups[i].getId().toString());
                        reason.append(APOSTROPHE);
                        reason.append(" is missing");
                        reason.append(PERIOD);
                    }
                    normal = false;
                    break;
                }
                MDXHierInfo currentHierInfo = ((V5EdgeGroup)v5EdgeGroups[i]).getHierarchyInfo();
                if (hierInfo.equals(currentHierInfo) || NormalizeEdgeHierarchies.compareHierInfoWithDummyHierarchies(hierInfo, currentHierInfo, tolerateShellLeaf)) continue;
                if (reason != null) {
                    reason.append("Found two V5EdgeGroups (");
                    reason.append(APOSTROPHE);
                    reason.append(v5EdgeGroups[0].getId().toString());
                    reason.append(APOSTROPHE);
                    reason.append(COMMA);
                    reason.append(APOSTROPHE);
                    reason.append(v5EdgeGroups[i].getId().toString());
                    reason.append(APOSTROPHE);
                    reason.append(") with different hierarchy infos");
                    reason.append(PERIOD);
                }
                normal = false;
                break;
            }
        }
        return normal;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((V5Edge)node).getPropertyValue(HIERARCHY_NORMALIZATION_DONE) != null) {
            this.traceNodeCondition(false, "Hierarchy normalization is done.", trace);
            return false;
        }
        boolean status = false;
        MDXHierInfo patternHierInfo = ((V5Edge)node).getPropertyPatternHierInfo();
        boolean bl = status = patternHierInfo != null;
        if (!status) {
            this.traceNodeCondition(status, "The V5Edge patternHierInfo property has not been created yet for this node", trace);
            return status;
        }
        IXQEQueryNode[] withindetails = node.getDescendantsOfType(201039, false);
        for (int i = 1; i < withindetails.length; ++i) {
            V5AggregateWithinClause withinClause = (V5AggregateWithinClause)withindetails[i];
            if (withinClause.getWithinClauseType() != 1) continue;
            boolean isApplied = false;
            Boolean propValue = (Boolean)withinClause.getPropertyValue("errorCellUpdateDecoApplied");
            if (propValue != null) {
                isApplied = propValue;
            }
            if (isApplied) continue;
            this.traceNodeCondition(false, "InsertErrorCellUpdateDecorationForNoneRollup has not been applied.", trace);
            return false;
        }
        int[] types = new int[]{101051, 101052, 101053};
        IXQEQueryNode[] v5ListGroupingNodes = node.getDescendantsOfTypes(types, false);
        status = v5ListGroupingNodes.length == 0;
        MDXQuery mdQuerySpec = (MDXQuery)node.getAncestorOfType(1002);
        String msgStr = null;
        if (!status && mdQuerySpec.isListReport()) {
            msgStr = "List reports do not requiere edge hierarchy normalization.";
        } else {
            IXQEQueryNode[] v5EdgeGroups = node.getChildrenOfTypeOrdered(101050);
            boolean bl2 = status = v5EdgeGroups.length > 0;
            if (!status) {
                msgStr = " The V5Edge contains none V5EdgeGroup.";
            } else {
                StringBuilder buffer = null;
                if (trace.getTraceLevel() != 0) {
                    buffer = new StringBuilder();
                    buffer.append(" The V5Edge contains at least one V5EdgeGroup. ");
                }
                if (!this.checkHierarchyNormalization(node, buffer, false)) {
                    status = true;
                } else {
                    status = false;
                    if (buffer != null) {
                        buffer.append("Nested V5EdgeGroups individualy have normal hierarchies. The hierarchy info is identical in all the V5Edge branches.");
                    }
                }
                if (buffer != null) {
                    msgStr = buffer.toString();
                }
            }
        }
        this.traceNodeCondition(status, msgStr, trace);
        return status;
    }
}

