/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.shell.ShellHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization.NormalizeEdgeHierarchies;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;

public class NormalizeInnermostCalcGroup
extends AbstractV5ToCogMDXTransformation {
    private static final String GET_PROPERTY_HIERARCHY_NULL = "getPropertyHierarchy() == null";
    protected static final String HIERARCHY_NORMALIZATION_DONE = "hierarchyNormalizationDone";

    public NormalizeInnermostCalcGroup() {
        this.mName = "Normalize an edge path projecting a floating calculation in the innermost V5EdgeGroup.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(HIERARCHY_NORMALIZATION_DONE, Boolean.TRUE);
        V5EdgeGroup innermostShellHierV5EdgeGroup = (V5EdgeGroup)node;
        V5Edge v5Edge = (V5Edge)node.getAncestorOfType(101049);
        MDXQuery mdxQuery = (MDXQuery)v5Edge.getAncestorOfType(1002);
        MDXHierInfo patternHierInfo = v5Edge.getPropertyPatternHierInfo();
        V5EdgeGroup ancestorGroup = (V5EdgeGroup)innermostShellHierV5EdgeGroup.getAncestorOfType(101050);
        ShellHierarchy innermostV5EdgeGroupShellHier = (ShellHierarchy)innermostShellHierV5EdgeGroup.getPropertyHierarchy();
        if (innermostV5EdgeGroupShellHier == null) {
            innermostShellHierV5EdgeGroup.throwInternalError(GET_PROPERTY_HIERARCHY_NULL);
        }
        if (ancestorGroup == null) {
            if (patternHierInfo.projectsShellHierarchy()) {
                if (patternHierInfo.projectsHierarchy(innermostV5EdgeGroupShellHier)) {
                    NormalizeInnermostCalcGroup.insertDMNormalizationEdgeGroup(environment, innermostShellHierV5EdgeGroup, patternHierInfo);
                } else {
                    ShellHierarchy innerMostShellInPattern = null;
                    for (IHierarchy currHier : patternHierInfo.getProjectedHierarchies()) {
                        if (!currHier.isShell()) continue;
                        innerMostShellInPattern = (ShellHierarchy)currHier;
                    }
                    innermostV5EdgeGroupShellHier = innerMostShellInPattern;
                    innermostShellHierV5EdgeGroup.setPropertyHierarchy(innermostV5EdgeGroupShellHier);
                    innermostShellHierV5EdgeGroup.setPropertyHierarchyDepth(XQEIntegerPool.getInteger(innermostV5EdgeGroupShellHier.getDepth()));
                    NormalizeInnermostCalcGroup.insertDMNormalizationEdgeGroup(environment, innermostShellHierV5EdgeGroup, patternHierInfo);
                }
            } else {
                ShellHierarchy innerMostShellInEdge;
                MDXHierInfo tempPatternHierInfo = new MDXHierInfo();
                tempPatternHierInfo.appendProjectedHierarchies(patternHierInfo);
                tempPatternHierInfo.removeProjectedHierarchy(patternHierInfo.getProjectedHierarchy(patternHierInfo.getNumProjectedHierarchies() - 1));
                innermostV5EdgeGroupShellHier = innerMostShellInEdge = this.getInnermostShellHierarchy(v5Edge);
                innermostShellHierV5EdgeGroup.setPropertyHierarchy(innermostV5EdgeGroupShellHier);
                innermostShellHierV5EdgeGroup.setPropertyHierarchyDepth(XQEIntegerPool.getInteger(innermostV5EdgeGroupShellHier.getDepth()));
                NormalizeInnermostCalcGroup.insertDMNormalizationEdgeGroup(environment, innermostShellHierV5EdgeGroup, tempPatternHierInfo);
            }
        } else {
            IHierarchy ancestorHier = ancestorGroup.getPropertyHierarchy();
            if (ancestorHier == null) {
                ancestorGroup.throwInternalError(GET_PROPERTY_HIERARCHY_NULL);
            }
            if (patternHierInfo.projectsHierarchy(ancestorHier)) {
                if (!patternHierInfo.projectsHierarchy(innermostV5EdgeGroupShellHier)) {
                    MDXHierInfo tempPatternHierInfo = new MDXHierInfo();
                    boolean start = false;
                    for (IHierarchy pHier : patternHierInfo.getProjectedHierarchies()) {
                        if (pHier.equals(ancestorHier)) {
                            start = true;
                            continue;
                        }
                        if (!start) continue;
                        tempPatternHierInfo.appendProjectedHierarchy(pHier);
                    }
                    if (tempPatternHierInfo.getNumProjectedHierarchies() > 0) {
                        tempPatternHierInfo.removeProjectedHierarchy(patternHierInfo.getProjectedHierarchy(patternHierInfo.getNumProjectedHierarchies() - 1));
                    }
                    if (tempPatternHierInfo.getNumProjectedHierarchies() > 1 && patternHierInfo.getProjectedHierarchy(patternHierInfo.getNumProjectedHierarchies() - 1).isShell()) {
                        tempPatternHierInfo.removeProjectedHierarchy(tempPatternHierInfo.getProjectedHierarchy(tempPatternHierInfo.getNumProjectedHierarchies() - 1));
                    }
                    innermostV5EdgeGroupShellHier = this.getInnermostShellHierarchy(v5Edge);
                    innermostShellHierV5EdgeGroup.setPropertyHierarchy(innermostV5EdgeGroupShellHier);
                    innermostShellHierV5EdgeGroup.setPropertyHierarchyDepth(XQEIntegerPool.getInteger(innermostV5EdgeGroupShellHier.getDepth()));
                    NormalizeInnermostCalcGroup.insertDMNormalizationEdgeGroup(environment, innermostShellHierV5EdgeGroup, tempPatternHierInfo);
                } else {
                    int ancestorHierPosition = patternHierInfo.getProjectedHierarchyIndex(ancestorHier);
                    MDXHierInfo tempPatternHierInfo = new MDXHierInfo();
                    tempPatternHierInfo.appendProjectedHierarchies(patternHierInfo);
                    for (int i = 0; i < ancestorHierPosition + 1; ++i) {
                        tempPatternHierInfo.removeProjectedHierarchy(patternHierInfo.getProjectedHierarchy(i));
                    }
                    NormalizeInnermostCalcGroup.insertDMNormalizationEdgeGroup(environment, innermostShellHierV5EdgeGroup, tempPatternHierInfo);
                }
            } else if (!patternHierInfo.projectsHierarchy(innermostV5EdgeGroupShellHier)) {
                if (!ancestorHier.isShell()) {
                    ancestorGroup.throwInternalError("!ancestorHier.isShell()");
                }
                ShellHierarchy innerMostShellHierForEdge = this.getInnermostShellHierarchy(v5Edge);
                int currDepth = innerMostShellHierForEdge.getDepth();
                IHierarchy nearestNoneShellAncestorHierarchy = null;
                boolean branchedAncestorShell = false;
                while (ancestorHier.isShell()) {
                    --currDepth;
                    if (ancestorGroup.getNumberChildren() != 2) {
                        branchedAncestorShell = true;
                        break;
                    }
                    String hierName = MDXQuery.getShellHierarchyName(v5Edge, XQEIntegerPool.getInteger(currDepth));
                    ShellHierarchy newAncestorHierarchy = (ShellHierarchy)mdxQuery.getShellHierarchy(hierName, currDepth);
                    ancestorGroup.setPropertyHierarchy(newAncestorHierarchy);
                    ancestorGroup.setPropertyHierarchyDepth(XQEIntegerPool.getInteger(newAncestorHierarchy.getDepth()));
                    V5EdgeGroup tempAncestorGroup = (V5EdgeGroup)ancestorGroup.getAncestorOfType(101050);
                    if (tempAncestorGroup == null) break;
                    if (tempAncestorGroup.getPropertyHierarchy() == null) {
                        tempAncestorGroup.throwInternalError(GET_PROPERTY_HIERARCHY_NULL);
                    }
                    if (!tempAncestorGroup.getPropertyHierarchy().isShell()) {
                        nearestNoneShellAncestorHierarchy = tempAncestorGroup.getPropertyHierarchy();
                        break;
                    }
                    ancestorGroup = tempAncestorGroup;
                    ancestorHier = ancestorGroup.getPropertyHierarchy();
                }
                MDXHierInfo tempPatternHierInfo = new MDXHierInfo();
                if (branchedAncestorShell) {
                    ArrayList<V5EdgeGroup> siblingNoShellGroups = new ArrayList<V5EdgeGroup>();
                    for (IXQEQueryNode child : ancestorGroup.getChildren()) {
                        if (child.getType() != 101050 || ((V5EdgeGroup)child).getPropertyHierarchy() == null || ((V5EdgeGroup)child).getPropertyHierarchy().isShell()) continue;
                        siblingNoShellGroups.add((V5EdgeGroup)child);
                    }
                    int siblingMaxDepth = -1;
                    for (V5EdgeGroup siblingNoShellGroup : siblingNoShellGroups) {
                        if (siblingNoShellGroup.getPropertyHierarchyDepth() == null) continue;
                        if (siblingMaxDepth == -1) {
                            siblingMaxDepth = siblingNoShellGroup.getPropertyHierarchyDepth();
                            continue;
                        }
                        if (siblingMaxDepth <= siblingNoShellGroup.getPropertyHierarchyDepth()) continue;
                        siblingMaxDepth = siblingNoShellGroup.getPropertyHierarchyDepth();
                    }
                    if (siblingMaxDepth > -1) {
                        for (int i = siblingMaxDepth - 1; i < patternHierInfo.getNumProjectedHierarchies() - 1; ++i) {
                            tempPatternHierInfo.appendProjectedHierarchy(patternHierInfo.getProjectedHierarchy(i));
                        }
                    }
                } else {
                    boolean start = false;
                    int patternHierIndex = 0;
                    for (IHierarchy pHier : patternHierInfo.getProjectedHierarchies()) {
                        if (patternHierIndex != patternHierInfo.getNumProjectedHierarchies() - currDepth) {
                            ++patternHierIndex;
                            if (nearestNoneShellAncestorHierarchy != null && pHier.equals(nearestNoneShellAncestorHierarchy)) {
                                start = true;
                                continue;
                            }
                            if (nearestNoneShellAncestorHierarchy == null) {
                                start = true;
                            }
                            if (!start) continue;
                            tempPatternHierInfo.appendProjectedHierarchy(pHier);
                            continue;
                        }
                        break;
                    }
                }
                innermostV5EdgeGroupShellHier = innerMostShellHierForEdge;
                innermostShellHierV5EdgeGroup.setPropertyHierarchy(innermostV5EdgeGroupShellHier);
                innermostShellHierV5EdgeGroup.setPropertyHierarchyDepth(XQEIntegerPool.getInteger(innermostV5EdgeGroupShellHier.getDepth()));
                if (branchedAncestorShell) {
                    NormalizeInnermostCalcGroup.insertDMNormalizationEdgeGroup(environment, innermostShellHierV5EdgeGroup, tempPatternHierInfo);
                } else {
                    NormalizeInnermostCalcGroup.insertDMNormalizationEdgeGroup(environment, ancestorGroup, tempPatternHierInfo);
                }
            } else {
                V5EdgeGroup tempAncestorGroup = ancestorGroup;
                IHierarchy tempAncestorHier = tempAncestorGroup.getPropertyHierarchy();
                if (tempAncestorHier == null) {
                    tempAncestorGroup.throwInternalError(GET_PROPERTY_HIERARCHY_NULL);
                }
                IHierarchy nearestNoneShellAncestorHierarchy = null;
                V5EdgeGroup nearestNoneShellAncestorV5EdgeGroup = null;
                V5EdgeGroup topShellAncestorV5EdgeGroup = tempAncestorGroup;
                int numOfConsecutiveShell = 2;
                while (tempAncestorHier.isShell() && (tempAncestorGroup = (V5EdgeGroup)ancestorGroup.getAncestorOfType(101050)) != null) {
                    if (tempAncestorGroup.getPropertyHierarchy() == null) {
                        tempAncestorGroup.throwInternalError(GET_PROPERTY_HIERARCHY_NULL);
                    }
                    if ((tempAncestorHier = tempAncestorGroup.getPropertyHierarchy()).isShell()) {
                        ++numOfConsecutiveShell;
                        topShellAncestorV5EdgeGroup = tempAncestorGroup;
                        continue;
                    }
                    nearestNoneShellAncestorHierarchy = tempAncestorHier;
                    nearestNoneShellAncestorV5EdgeGroup = tempAncestorGroup;
                }
                String errMsg = "Invalid nesting of flating calculations.";
                if (nearestNoneShellAncestorV5EdgeGroup != null) {
                    ancestorGroup = nearestNoneShellAncestorV5EdgeGroup;
                    int nearestNoneShellAncestorHierarchyPositionInPattern = patternHierInfo.getProjectedHierarchyIndex(nearestNoneShellAncestorHierarchy);
                    if (patternHierInfo.getNumProjectedHierarchies() < nearestNoneShellAncestorHierarchyPositionInPattern + 1 + numOfConsecutiveShell) {
                        innermostShellHierV5EdgeGroup.throwInternalError("Invalid nesting of flating calculations.");
                    }
                    MDXHierInfo tempPatternHierInfo = new MDXHierInfo();
                    for (IXQEQueryNode siblingV5EdgeGroup : nearestNoneShellAncestorV5EdgeGroup.getChildren()) {
                        IHierarchy siblingHier;
                        if (siblingV5EdgeGroup.getType() == 101057 || (siblingHier = ((V5EdgeGroup)siblingV5EdgeGroup).getPropertyHierarchy()) == null || !siblingHier.equals(nearestNoneShellAncestorHierarchy)) continue;
                        tempPatternHierInfo.appendProjectedHierarchy(siblingHier);
                        break;
                    }
                    NormalizeInnermostCalcGroup.insertDMNormalizationEdgeGroup(environment, topShellAncestorV5EdgeGroup, tempPatternHierInfo);
                } else if (patternHierInfo.getNumProjectedHierarchies() < numOfConsecutiveShell) {
                    innermostShellHierV5EdgeGroup.throwInternalError("Invalid nesting of flating calculations.");
                }
            }
            if (ancestorGroup.getNumberChildren() > 2) {
                boolean isAncestorNestingOwnHierarchy = false;
                for (IXQEQueryNode child : ancestorGroup.getChildren()) {
                    if (child.getType() != 101050 || !((V5EdgeGroup)child).getPropertyHierarchy().equals(ancestorHier)) continue;
                    isAncestorNestingOwnHierarchy = true;
                    break;
                }
                if (isAncestorNestingOwnHierarchy) {
                    String refDataItemName;
                    V5EdgeGroup topNormalizationGroup;
                    for (topNormalizationGroup = (V5EdgeGroup)innermostShellHierV5EdgeGroup.getParent(); topNormalizationGroup != null && topNormalizationGroup.getParent().getType() == 101050 && BuildXOLAPEdgeMappingUtilities.isDMForNormalization(refDataItemName = ((V5ValueSet)topNormalizationGroup.getParent().getChild(0)).getRefDataItemProperty()); topNormalizationGroup = (V5EdgeGroup)topNormalizationGroup.getParent()) {
                    }
                    MDXHierInfo tempPatternHierInfo = new MDXHierInfo();
                    tempPatternHierInfo.appendProjectedHierarchy(ancestorHier);
                    NormalizeInnermostCalcGroup.insertCMNormalizationEdgeGroup(environment, topNormalizationGroup, tempPatternHierInfo);
                }
            }
        }
    }

    private ShellHierarchy getInnermostShellHierarchy(V5Edge v5Edge) {
        IXQEQueryNode[] edgeGroups;
        int highestDepth = -1;
        for (IXQEQueryNode edgeGroup : edgeGroups = v5Edge.getDescendantsOfType(101050, false)) {
            V5EdgeGroup currEdgeGroup = (V5EdgeGroup)edgeGroup;
            if (currEdgeGroup.getNumberChildren() != 1 || currEdgeGroup.getPropertyHierarchyDepth() == null) continue;
            if (highestDepth == -1) {
                highestDepth = currEdgeGroup.getPropertyHierarchyDepth();
                continue;
            }
            if (highestDepth >= currEdgeGroup.getPropertyHierarchyDepth()) continue;
            highestDepth = currEdgeGroup.getPropertyHierarchyDepth();
        }
        MDXQuery mdxQuery = (MDXQuery)v5Edge.getAncestorOfType(1002);
        String hierName = MDXQuery.getShellHierarchyName(v5Edge, XQEIntegerPool.getInteger(highestDepth));
        ShellHierarchy newShellHierarchy = (ShellHierarchy)mdxQuery.getShellHierarchy(hierName, highestDepth);
        return newShellHierarchy;
    }

    private static void insertDMNormalizationEdgeGroup(PlanningEnvironment environment, V5EdgeGroup v5EdgeGroup, MDXHierInfo patternHierInfo) {
        IHierarchy v5EdgeGroupHier = v5EdgeGroup.getPropertyHierarchy();
        int patternHierPos = -1;
        for (IHierarchy patternHierarchy : patternHierInfo.getProjectedHierarchies()) {
            ++patternHierPos;
            if (patternHierarchy.equals(v5EdgeGroupHier)) break;
            NormalizeEdgeHierarchies.insertNormalizationEdgeGroup(201061, v5EdgeGroup, 1, patternHierarchy, patternHierPos, environment);
        }
    }

    private static void insertCMNormalizationEdgeGroup(PlanningEnvironment environment, V5EdgeGroup v5EdgeGroup, MDXHierInfo patternHierInfo) {
        IHierarchy v5EdgeGroupHier = v5EdgeGroup.getPropertyHierarchy();
        int patternHierPos = -1;
        for (IHierarchy patternHierarchy : patternHierInfo.getProjectedHierarchies()) {
            ++patternHierPos;
            if (patternHierarchy.equals(v5EdgeGroupHier)) break;
            NormalizeEdgeHierarchies.insertNormalizationEdgeGroup(201059, v5EdgeGroup, 1, patternHierarchy, patternHierPos, environment);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(HIERARCHY_NORMALIZATION_DONE) == null) {
            boolean isInnerMostShellHierGroup;
            V5EdgeGroup v5EdgeGroup = (V5EdgeGroup)node;
            boolean bl = isInnerMostShellHierGroup = v5EdgeGroup.getNumberChildren() == 1 && v5EdgeGroup.getPropertyHierarchy() != null && v5EdgeGroup.getPropertyHierarchy().isShell();
            if (isInnerMostShellHierGroup) {
                boolean isCalculationGroup = v5EdgeGroup.getChild(0).getChild(0).getType() == 201101 && v5EdgeGroup.getChild(0).getChild(0).getChild(0).getType() == 201085;
                IXQEQueryNode v5Edge = node.getAncestorOfType(101049);
                if (isCalculationGroup && v5Edge.getPropertyValue(HIERARCHY_NORMALIZATION_DONE) != null) {
                    this.traceNodeCondition(true, "Trandformation is applicable.", trace);
                    return true;
                }
            }
        }
        this.traceNodeCondition(false, "Trandformation is not applicable.", trace);
        return false;
    }
}

