/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public final class PatternHierInfoNode {
    public static final String HIERARCHY = "hierarchy";
    public static final String DEPTH = "depth";
    public static final String INDENT_STRING = "  ";
    private ArrayList<PatternHierInfoNode> children = new ArrayList();
    private PatternHierInfoNode parent = null;
    private IHierarchy hierarchy = null;
    private int numShellChildren = 0;
    private int depth = -1;
    private ArrayList<V5EdgeGroup> v5EdgeGroups = new ArrayList();

    public ArrayList<PatternHierInfoNode> getChildren() {
        return this.children;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public int getNumShellChildren() {
        return this.numShellChildren;
    }

    public void addChild(PatternHierInfoNode aChild) {
        this.children.add(aChild);
        aChild.setParent(this);
        if (aChild.getHierarchy().isShell()) {
            ++this.numShellChildren;
        }
    }

    public void removeChild(PatternHierInfoNode aChild) {
        this.children.remove(aChild);
        aChild.removeParent();
        if (aChild.getHierarchy().isShell()) {
            --this.numShellChildren;
        }
    }

    public void moveChild(PatternHierInfoNode aChild, PatternHierInfoNode newParent) {
        this.removeChild(aChild);
        newParent.addChild(aChild);
    }

    public PatternHierInfoNode getParent() {
        return this.parent;
    }

    public void removeParent() {
        this.parent = null;
    }

    public void setParent(PatternHierInfoNode aParent) {
        this.parent = aParent;
        if (this.parent != null) {
            this.setDepth(this.parent.getDepth() + 1);
        } else {
            this.setDepth(0);
        }
    }

    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(IHierarchy aHierarchy) {
        this.hierarchy = aHierarchy;
    }

    public void addV5EdgeGroup(V5EdgeGroup aV5EdgeGroups) {
        this.v5EdgeGroups.add(aV5EdgeGroups);
    }

    public int getNumV5EdgeGroups() {
        return this.v5EdgeGroups.size();
    }

    public V5EdgeGroup getV5EdgeGroup(int pos) {
        if (this.v5EdgeGroups.isEmpty()) {
            return null;
        }
        if (pos > this.v5EdgeGroups.size() - 1) {
            return null;
        }
        return this.v5EdgeGroups.get(pos);
    }

    public ArrayList<V5EdgeGroup> extractV5EdgeGroups() {
        ArrayList<V5EdgeGroup> list = this.v5EdgeGroups;
        this.v5EdgeGroups = new ArrayList();
        return list;
    }

    private void moveV5EdgeGroups(PatternHierInfoNode node) {
        this.v5EdgeGroups.addAll(node.extractV5EdgeGroups());
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int aDepth) {
        this.depth = aDepth;
        if (aDepth != 0 && this.getHierarchy().isShell()) {
            this.getHierarchy().getLevel(aDepth);
        }
        for (PatternHierInfoNode child : this.getChildren()) {
            child.setDepth(this.depth + 1);
        }
    }

    public void merge(PatternHierInfoNode node, V5Edge v5Edge) {
        PatternHierInfoNode parentNode = node.getParent();
        parentNode.removeChild(node);
        ArrayList<PatternHierInfoNode> forMoving = new ArrayList<PatternHierInfoNode>();
        forMoving.addAll(node.getChildren());
        for (PatternHierInfoNode aChild : forMoving) {
            for (PatternHierInfoNode currParent = this.getParent(); currParent != null; currParent = currParent.getParent()) {
                if (currParent != aChild && currParent != node) continue;
                IHierarchy thisHierarchy = this.getHierarchy();
                V5EdgeGroup thisV5EdgeGroup = this.getV5EdgeGroup(0);
                V5ValueSet thisV5ValueSet = (V5ValueSet)thisV5EdgeGroup.getChild(0);
                V5EdgeGroup nodeV5EdgeGroup = node.getV5EdgeGroup(0);
                V5ValueSet nodeV5ValueSet = (V5ValueSet)nodeV5EdgeGroup.getChild(0);
                MDXQuery mdxQuery = (MDXQuery)thisV5EdgeGroup.getAncestorOfType(1002);
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidHierarchyDistributionOnEdge, thisHierarchy.getName(), (Object)thisV5ValueSet.getRefDataItemProperty(), (Object)nodeV5ValueSet.getRefDataItemProperty(), (Object)mdxQuery.getRefQueryProperty());
            }
            node.moveChild(aChild, this);
        }
        this.moveV5EdgeGroups(node);
    }

    public void dumpToXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement(this.getClass().getSimpleName(), -1);
        String sHierarchy = null;
        if (this.getHierarchy() != null) {
            sHierarchy = this.getHierarchy().toString();
        }
        xmlWriter.attribute(HIERARCHY, sHierarchy);
        xmlWriter.attribute(DEPTH, this.getDepth());
        for (PatternHierInfoNode child : this.getChildren()) {
            child.dumpToXML(xmlWriter);
        }
        xmlWriter.endElement();
    }

    public String toString() {
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.setIndentString(INDENT_STRING);
        StringWriter stringWriter = new StringWriter();
        xmlWriter.addStream(stringWriter);
        this.dumpToXML(xmlWriter);
        return stringWriter.toString();
    }

    public List<PatternHierInfoNode> getPatternHierInfoNodesAtDepth(int aDepth) {
        ArrayList<PatternHierInfoNode> nodesAtDepth = new ArrayList<PatternHierInfoNode>();
        if (this.getDepth() < aDepth) {
            for (PatternHierInfoNode child : this.getChildren()) {
                List<PatternHierInfoNode> tmpNodesAtDepth = child.getPatternHierInfoNodesAtDepth(aDepth);
                nodesAtDepth.addAll(tmpNodesAtDepth);
            }
        } else if (this.getDepth() == aDepth) {
            nodesAtDepth.add(this);
        }
        return nodesAtDepth;
    }

    public void getPatternHierInfoNodesAtDepth(int aDepth, List<PatternHierInfoNode> nodesAtDepth, List<IHierarchy> hierarchiesAtDepth) {
        if (this.getDepth() < aDepth) {
            for (PatternHierInfoNode child : this.getChildren()) {
                child.getPatternHierInfoNodesAtDepth(aDepth, nodesAtDepth, hierarchiesAtDepth);
            }
        } else if (this.getDepth() == aDepth) {
            nodesAtDepth.add(this);
            hierarchiesAtDepth.add(this.getHierarchy());
        }
    }
}

