/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.hierarchynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5MemberFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class SetValueSetDetailPropertyForMeasures
extends Transformation {
    public SetValueSetDetailPropertyForMeasures() {
        this.mName = "Set measure valueSet 'detail' property value.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5ValueSet v5ValueSet = (V5ValueSet)node;
        String refDataItemName = v5ValueSet.getRefDataItemProperty();
        if (refDataItemName != null) {
            MDXQuery mdxQuery = (MDXQuery)v5ValueSet.getAncestorOfType(1002);
            String refQueryName = mdxQuery.getRefQueryProperty();
            if (v5ValueSet.getIsDetailAutomatic()) {
                v5ValueSet.setIsReportDetail(false);
                return;
            }
            if (v5ValueSet.isReportDetail()) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidDetailAttributeOnMeasure, refQueryName, refDataItemName);
            }
        } else {
            v5ValueSet.setIsReportDetail(false);
            return;
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXHierInfo hierInfo;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The target V5ValueSet is not under a MDXQuery.", trace);
            return false;
        }
        V5Edge v5Edge = (V5Edge)node.getAncestorOfType(101049);
        if (v5Edge != null && v5Edge.getPropertyValue("hierarchyNormalizationDone") == null) {
            this.traceNodeCondition(false, "Hierarchy normalization is not done.", trace);
            return false;
        }
        V5ValueSet v5ValueSet = (V5ValueSet)node;
        if (v5ValueSet.isReportDetail() && v5ValueSet.getIsDetailAutomatic() && (hierInfo = v5ValueSet.getHierarchyInfo()).getNumProjectedHierarchies() != 0) {
            IDimension dimension = hierInfo.getProjectedHierarchy(0).getDimension();
            if (dimension.isMeasuresDimension()) {
                this.traceNodeCondition(true, "The target V5ValueSet is a detail measure.", trace);
                return true;
            }
            if (dimension.isShell() && this.measureDimensionInContext(v5ValueSet.getChild(0))) {
                this.traceNodeCondition(true, "The target V5ValueSet is a detail calculation with measures.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The target V5ValueSet is not a detail measure.", trace);
        return false;
    }

    private boolean measureDimensionInContext(IXQEQueryNode expression) {
        return expression.getType() == 201101 && expression.getNumberChildren() == 1 && expression.getChild(0).getType() == 201085 && this.hasMeasureInContext((V5MemberFunction)expression.getChild(0));
    }

    private boolean hasMeasureInContext(V5MemberFunction member) {
        boolean measureInContext = false;
        if (member.getNumberChildren() < 4) {
            IXQEQueryNode firstChild = member.getChild(0);
            switch (firstChild.getType()) {
                case 201014: {
                    measureInContext = this.hasMeasureInContext((V5ValueExpression)firstChild);
                    break;
                }
                case 201113: {
                    measureInContext = this.hasMeasureInContext((V5ValueFunction)firstChild);
                    break;
                }
            }
        }
        return measureInContext;
    }

    private boolean hasMeasureInContext(V5ValueFunction valueFunction) {
        boolean measureInContext = false;
        if (valueFunction.getNumberChildren() == 1 && valueFunction.getChild(0).getType() == 201110) {
            IXQEQueryNode tupleFunction = valueFunction.getChild(0);
            block4: for (int i = 0; i < tupleFunction.getNumberChildren() && !measureInContext; ++i) {
                IXQEQueryNode tupleChild = tupleFunction.getChild(i);
                switch (tupleChild.getType()) {
                    case 201116: {
                        measureInContext = this.hasMeasureInContext((V5BoundModelIdentifier)tupleChild);
                        continue block4;
                    }
                    case 201085: {
                        measureInContext = this.hasMeasureInContext((V5MemberFunction)tupleChild);
                        continue block4;
                    }
                }
            }
        }
        return measureInContext;
    }

    private boolean hasMeasureInContext(V5ValueExpression valueExpression) {
        boolean measureInContext = false;
        if (valueExpression.getSubType() != 0) {
            block4: for (int i = 0; i < valueExpression.getNumberChildren() && !measureInContext; ++i) {
                IXQEQueryNode child = valueExpression.getChild(i);
                switch (child.getType()) {
                    case 201014: {
                        measureInContext = this.hasMeasureInContext((V5ValueExpression)child);
                        continue block4;
                    }
                    case 201113: {
                        measureInContext = this.hasMeasureInContext((V5ValueFunction)child);
                        continue block4;
                    }
                }
            }
        }
        return measureInContext;
    }

    private boolean hasMeasureInContext(V5BoundModelIdentifier modelIdentifier) {
        return modelIdentifier.isMeasure();
    }
}

