/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.provider.sapbw;

import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ConfigException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.VariableEntryTypeEnum;
import com.cognos.xqe.metadata.VariablePromptTypeEnum;
import com.cognos.xqe.metadata.VariableSelectionTypeEnum;
import com.cognos.xqe.metadata.VariableTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterCapabilities;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.List;
import org.apache.commons.configuration.ConversionException;

public class GetSAPVariables
extends Transformation {
    public GetSAPVariables() {
        this.mName = "Get SAP variables from model.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1007};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery != null && mdxQuery.isConstantQuery() && mdxQuery.getUseLocalQueryProcessing()) {
            this.traceNodeCondition(false, "SAP Variables are not required for constant query supported by LOLAP.", trace);
            return false;
        }
        MDXFromCube mdxFromCube = (MDXFromCube)node;
        ICube cube = mdxFromCube.getCube();
        boolean passes = false;
        if (cube.getVariables() != null) {
            if (!mdxFromCube.getHaveVariablesBeenRead()) {
                boolean bl = passes = cube.getVariables().size() > 0;
                if (passes) {
                    this.traceNodeCondition(true, "SAP Variables have been defined for this data source.", trace);
                } else {
                    this.traceNodeCondition(false, "No SAP Variables have been defined for this data source.", trace);
                }
            } else {
                this.traceNodeCondition(false, "SAP Variables have already been read.", trace);
            }
        } else {
            this.traceNodeCondition(false, "Datasource information is not available.", trace);
        }
        return passes;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query;
        MDXQuery mdxQuery;
        String queryName;
        IXQEQueryNode rootNode;
        MDXFromCube mdxFromCube = (MDXFromCube)node;
        ICube cube = mdxFromCube.getCube();
        List<IVariable> variables = cube.getVariables();
        if (variables.size() > 0 && (rootNode = environment.getRoot()).getType() == 101002) {
            ((V5QuerySet)rootNode).setNonReusable(true);
        }
        if ((queryName = (mdxQuery = (MDXQuery)mdxFromCube.getAncestorOfType(1002)).getRefQueryProperty()) == null) {
            queryName = new String();
        }
        RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        Parameters parameters = requestEnvironment.getRequestParameters();
        if (environment.isMultimodelCase() && (v5Query = mdxQuery.getRefV5Query()) != null) {
            environment.pushMetadataConnectionContext(v5Query);
        }
        mdxFromCube.setHaveVariablesBeenRead(true);
        for (IVariable variable : variables) {
            String variableUniqueName = variable.getUniqueName();
            Parameter parameter = parameters.getParameter(variableUniqueName);
            if (parameter == null && this.getDetectSAPVariableUniquenessFromConfigFile(requestEnvironment)) {
                variableUniqueName = variable.getDisambiguatedUniqueName(environment.getMetadataConnection().getCubes(), cube);
                parameter = parameters.getParameter(variableUniqueName);
            }
            if (parameter != null) {
                parameter.setVariableInfo(environment, variable);
                this.setPromptType(parameter, variable);
                parameter.setProviderName(environment, cube);
            } else {
                V5Query v5Query2;
                parameter = new Parameter(variableUniqueName, queryName);
                this.setParameterInfo(parameter, variable, environment, node);
                if (environment.isMultimodelCase() && (v5Query2 = mdxQuery.getRefV5Query()) != null) {
                    String modelPath = v5Query2.getMetadataPathInSource();
                    parameter.setModelPath(modelPath);
                }
                parameters.addParameter(variableUniqueName, parameter);
            }
            parameter.bindToRequest((RequestEnvironment)environment.getRequestEnvironment());
        }
    }

    private boolean getDetectSAPVariableUniquenessFromConfigFile(RequestEnvironment requestEnvironment) {
        if (requestEnvironment.getdetectSAPVariableUniqueness() == null) {
            XQESubConfiguration sapConfig;
            XQEConfiguration config;
            block8: {
                config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP);
                if (config == null) {
                    try {
                        config = XQECCLConfigurationAdapter.createDefaultConfigurationForService(ServiceEnumeration.XQEODP);
                        XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQEODP, config);
                    }
                    catch (ConfigException ce) {
                        if (!XQEMessageKeys.CFG_FileExistError.equals(ce.getMessageKey()) && !XQEMessageKeys.CFG_FileLoadError.equals(ce.getMessageKey())) break block8;
                        requestEnvironment.setdetectSAPVariableUniqueness(true);
                        return true;
                    }
                }
            }
            if ((sapConfig = config.getConfigForXQEODPComponent("SBWODP")) != null) {
                sapConfig.next();
                try {
                    requestEnvironment.setdetectSAPVariableUniqueness(sapConfig.getBoolean("detectSAPVariableUniqueness[@value]", Boolean.TRUE));
                }
                catch (ConversionException conversionException) {}
            } else {
                requestEnvironment.setdetectSAPVariableUniqueness(true);
                return true;
            }
        }
        return requestEnvironment.getdetectSAPVariableUniqueness();
    }

    public void setParameterInfo(Parameter parameter, IVariable variable, PlanningEnvironment environment, IXQEQueryNode node) {
        parameter.setVariableInfo(environment, variable);
        parameter.setCaptionLocale(((RequestEnvironment)environment.getRequestEnvironment()).getRunLocale());
        VariableEntryTypeEnum entryType = variable.getEntryType();
        VariableSelectionTypeEnum selectionType = variable.getSelectionType();
        ParameterCapabilities capabilities = parameter.getCapabilities();
        if (entryType == VariableEntryTypeEnum.OPTIONAL) {
            capabilities.setOptional(true);
        }
        if (selectionType == VariableSelectionTypeEnum.MULTIVALUED || variable.getDataType() == DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE) {
            capabilities.setMultivalued(true);
        } else if (selectionType == VariableSelectionTypeEnum.INTERVAL) {
            capabilities.setRangeSupport(ParameterCapabilityEnum.boundRange);
        } else {
            capabilities.setRangeSupport(ParameterCapabilityEnum.discreteValue);
        }
        if (selectionType == VariableSelectionTypeEnum.COMPLEX) {
            capabilities.setExcludeValues(true);
        }
        ParameterValues parameterValues = parameter.getDefaultValues();
        String defaultLowString = null;
        if (variable.getDefaultLow() != null) {
            defaultLowString = this.getV5Value(variable, variable.getDefaultLow().toString(), environment, node);
        }
        String defaultHighString = null;
        if (variable.getDefaultHigh() != null) {
            defaultHighString = this.getV5Value(variable, variable.getDefaultHigh().toString(), environment, node);
        }
        parameterValues.addValue(capabilities.isBoundRange(), defaultLowString, variable.getLowCaption(), defaultHighString, variable.getHighCaption());
        if (variable.isFixedValue()) {
            parameter.getParameterValueItems().addValue(capabilities.isBoundRange(), defaultLowString, variable.getLowCaption(), defaultHighString, variable.getHighCaption());
            parameter.setSAPVariableHasFixedValue(true);
        } else if (variable.getType() == VariableTypeEnum.HIERARCHY && variable.getHierarchy() != null) {
            IDimension dimension = variable.getDimension();
            IHierarchy hierarchy = variable.getHierarchy();
            IHierarchy defaultHierarchy = dimension.getDefaultHierarchy();
            for (IHierarchy itHierarchy : dimension.getHierarchies()) {
                if (itHierarchy.equals(defaultHierarchy)) continue;
                hierarchy = itHierarchy;
                break;
            }
            parameter.getParameterValueItems().addValue(false, hierarchy.getUniqueName(), hierarchy.getUniqueName(), null, null);
        }
        this.setPromptType(parameter, variable);
    }

    private void setPromptType(Parameter parameter, IVariable variable) {
        VariablePromptTypeEnum promptType = variable.getPromptType();
        if (variable.getType() == VariableTypeEnum.MEMBER && promptType == VariablePromptTypeEnum.TYPEIN) {
            parameter.setPromptType(VariablePromptTypeEnum.HIERARCHY_PICKLIST.getFaultPromptType());
        } else {
            parameter.setPromptType(promptType.getFaultPromptType());
        }
    }

    public String getV5Value(IVariable variable, String value, PlanningEnvironment environment, IXQEQueryNode node) {
        IHierarchy hierarchy;
        if (value.contains("#")) {
            MacroExpander expander = new MacroExpander();
            value = expander.expand(node, environment, value);
        }
        IXQEQueryNode v5Node = V5ExpressionProcessor.parse(value, environment, environment.getMetadataConnection().getDefaultLocale(null));
        String v5Value = value;
        if (v5Node instanceof V5MultiPartIdentifier && (hierarchy = variable.getHierarchy()) != null) {
            v5Value = UniqueNameGenerator.createMemberV5UniqueName(hierarchy, value);
        }
        return v5Value;
    }
}

