/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.querynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AllocationRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.DynamicDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.binding.ConvertV5ExpressionToBinary;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class DMRDynamicScopedTo
extends AbstractV5ToCogMDXTransformation {
    private static final String STR_DYNAMIC_SCOPED_TO_APPLIED = "dynamicScopedToApplied";

    public DMRDynamicScopedTo() {
        this.mName = "DMR Dynamic scoped to.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Object hier;
        MDXQuery mdxQuery = (MDXQuery)node;
        V5Query v5Query = mdxQuery.getRefV5Query();
        Map globalMap = (Map)v5Query.getPropertyValue("DynamicScopedTo");
        mdxQuery.setPropertyValue(STR_DYNAMIC_SCOPED_TO_APPLIED, Boolean.TRUE);
        CubeWrapper cube = this.getCubeWrapper(mdxQuery);
        HashMap dynamicsHiers = new HashMap();
        HashMap<String, ArrayList<V5BoundToMetadata>> dynamicsMeasures = new HashMap<String, ArrayList<V5BoundToMetadata>>();
        boolean bHasAppliedTo = false;
        List<IXQEQueryNode> nodes = mdxQuery.getDescendantsOfCategory(201029, false);
        for (IXQEQueryNode iXQEQueryNode : nodes) {
            V5BoundToMetadata v5BoundToMetadata;
            if (iXQEQueryNode.getPropertyValue("applyToDSQS") != null) {
                bHasAppliedTo = true;
            }
            if (globalMap == null || (hier = V5BoundModelIdentifier.getHierarchyFromIMetadata((v5BoundToMetadata = (V5BoundToMetadata)iXQEQueryNode).getMetadata())) == null) continue;
            String ns = "";
            if (v5BoundToMetadata.getPropertyValue("DynamicScopedTo") != null) {
                ns = (String)v5BoundToMetadata.getPropertyValue("DynamicScopedTo");
            }
            if (!hier.getDimension().isMeasuresDimension()) {
                ArrayList<V5BoundToMetadata> m;
                TreeMap<String, ArrayList<V5BoundToMetadata>> p = (TreeMap<String, ArrayList<V5BoundToMetadata>>)dynamicsHiers.get(hier);
                if (p == null) {
                    p = new TreeMap<String, ArrayList<V5BoundToMetadata>>();
                    dynamicsHiers.put(hier, p);
                }
                if ((m = (ArrayList<V5BoundToMetadata>)p.get(ns = this.getDynamicScopeGroupName(globalMap, ns, v5BoundToMetadata))) == null) {
                    m = new ArrayList<V5BoundToMetadata>();
                    p.put(ns, m);
                }
                m.add(v5BoundToMetadata);
                continue;
            }
            if (ns.isEmpty()) continue;
            ArrayList<V5BoundToMetadata> ms = (ArrayList<V5BoundToMetadata>)dynamicsMeasures.get(ns);
            if (ms == null) {
                ms = new ArrayList<V5BoundToMetadata>();
                dynamicsMeasures.put(ns, ms);
            }
            ms.add(v5BoundToMetadata);
        }
        if (globalMap != null) {
            TreeMap conceptHier = new TreeMap();
            for (Map.Entry entry : dynamicsHiers.entrySet()) {
                Set contextSet;
                Object contextKey;
                hier = (IHierarchy)entry.getKey();
                Object m = (TreeMap)entry.getValue();
                if (((TreeMap)m).size() <= 1 && (((TreeMap)m).size() == 0 || ((TreeMap)m).size() == 1 && ((String)(contextKey = (String)(contextSet = ((TreeMap)m).keySet()).iterator().next())).isEmpty())) continue;
                int i = 0;
                contextKey = ((TreeMap)m).entrySet().iterator();
                while (contextKey.hasNext()) {
                    Map.Entry e1 = contextKey.next();
                    String conceptKey = (String)e1.getKey();
                    if (i > 0) {
                        DynamicDimensionWrapper sc = cube.cloneToDynamicDimension((HierarchyWrapper)hier, conceptKey);
                        for (V5BoundToMetadata aM : (List)e1.getValue()) {
                            this.rebind(aM, sc);
                        }
                    }
                    ++i;
                    for (V5BoundToMetadata v5BoundToMetadata : (List)e1.getValue()) {
                        IHierarchy h;
                        ArrayList<V5BoundToMetadata> l;
                        String ns = (String)v5BoundToMetadata.getPropertyValue("DynamicScopedTo");
                        if (ns == null) continue;
                        HashMap<IHierarchy, ArrayList<V5BoundToMetadata>> hierMp = (HashMap<IHierarchy, ArrayList<V5BoundToMetadata>>)conceptHier.get(ns = this.getDynamicScopeGroupName(globalMap, ns, v5BoundToMetadata));
                        if (hierMp == null) {
                            hierMp = new HashMap<IHierarchy, ArrayList<V5BoundToMetadata>>();
                            conceptHier.put(ns, hierMp);
                        }
                        if ((l = (ArrayList<V5BoundToMetadata>)hierMp.get(h = V5BoundModelIdentifier.getHierarchyFromIMetadata(v5BoundToMetadata.getMetadata()))) == null) {
                            l = new ArrayList<V5BoundToMetadata>();
                            hierMp.put(h, l);
                        }
                        l.add(v5BoundToMetadata);
                    }
                }
            }
            for (Map.Entry entry : dynamicsMeasures.entrySet()) {
                for (Object m : (List)entry.getValue()) {
                    IMetadata mt = ((V5BoundToMetadata)m).getMetadata();
                    if (!(mt instanceof MeasureWrapper)) continue;
                    MeasureWrapper mr = (MeasureWrapper)mt;
                    mr.setAllocationRule(AllocationRule.CONSTANT);
                    Map allDynamicGroups = (Map)globalMap.get(entry.getKey());
                    if (allDynamicGroups == null) continue;
                    HashMap<String, String> applyTo = new HashMap<String, String>();
                    for (String string : allDynamicGroups.keySet()) {
                        HashMap<IDimension, Integer> dynScope = this.getDynamicScopes(environment, (Pair)allDynamicGroups.get(string), (HashMap)conceptHier.get(string), applyTo);
                        for (Map.Entry<IDimension, Integer> e2 : dynScope.entrySet()) {
                            mr.setOverrideScope(e2.getKey(), e2.getValue());
                        }
                    }
                    for (Map.Entry entry2 : applyTo.entrySet()) {
                        mr.addLevelApplyTo((String)entry2.getKey(), (String)entry2.getValue());
                    }
                }
            }
        }
        if (bHasAppliedTo) {
            for (IXQEQueryNode iXQEQueryNode : nodes) {
                V5BoundToMetadata v5BoundToMetadata = (V5BoundToMetadata)iXQEQueryNode;
                ILevel level = V5BoundModelIdentifier.getLevelFromIMetadata(v5BoundToMetadata.getMetadata());
                if (!(level instanceof LevelWrapper)) continue;
                LevelWrapper levelWrapper = (LevelWrapper)level;
                String applyTo = (String)iXQEQueryNode.getPropertyValue("applyToDSQS");
                if (applyTo != null) {
                    levelWrapper.setApplyTo(applyTo);
                    continue;
                }
                if (levelWrapper.getApplyTo() != null) continue;
                levelWrapper.setApplyTo("apply_To_All_DSQS");
            }
        }
    }

    protected HashMap<IDimension, Integer> getDynamicScopes(PlanningEnvironment environment, Pair def, HashMap<IHierarchy, List<V5BoundToMetadata>> mp, HashMap<String, String> applyTo) {
        HashMap<IDimension, Integer> rt = new HashMap<IDimension, Integer>();
        for (Map.Entry<IHierarchy, List<V5BoundToMetadata>> e : mp.entrySet()) {
            IDimension dim = e.getKey().getDimension();
            List<V5BoundToMetadata> nodes = e.getValue();
            Integer dynamicScopedTo = new Integer(0);
            for (V5BoundToMetadata aM : nodes) {
                ILevel l;
                String[] atRt;
                Set incl;
                IMetadata metadataObj = aM.getMetadata();
                String ns = (String)aM.getPropertyValue("DynamicScopedTo");
                if (!this.containsDataItemName(ns, incl = (Set)def.getFirst(), atRt = new String[]{null}) || (l = V5BoundModelIdentifier.getLevelFromIMetadata(metadataObj)) == null) continue;
                int lvlPos = l.getIndex();
                if (dynamicScopedTo < lvlPos) {
                    dynamicScopedTo = new Integer(lvlPos);
                }
                if (atRt[0] == null) continue;
                String lvlUName = l.getUniqueName();
                String atValue = ConvertV5ExpressionToBinary.getApplyToValue(environment, atRt[0]);
                applyTo.put(lvlUName, atValue);
            }
            rt.put(dim, dynamicScopedTo);
        }
        return rt;
    }

    protected String getDynamicScopeGroupName(Map<String, Map<String, Pair>> globalMap, String ns, V5BoundToMetadata metaNode) {
        for (Map<String, Pair> m : globalMap.values()) {
            for (Map.Entry<String, Pair> entry : m.entrySet()) {
                Pair p = entry.getValue();
                Set incl = (Set)p.getFirst();
                Set excl = (Set)p.getSecond();
                if (!this.containsDataItemName(ns, incl, null) && !this.containsDataItemName(ns, excl, null)) continue;
                return entry.getKey();
            }
        }
        return ns;
    }

    private boolean containsDataItemName(String diName, Set<Pair> s, String[] atRt) {
        for (Pair p : s) {
            if (!diName.equals(p.getFirst())) continue;
            if (atRt != null) {
                atRt[0] = (String)p.getSecond();
            }
            return true;
        }
        return false;
    }

    protected void rebind(V5BoundToMetadata m, DynamicDimensionWrapper sc) {
        V5BoundMemberUniqueName mun;
        String sMun;
        IMetadata metadataObj = m.getMetadata();
        IMetadata dynamicMeta = null;
        MetadataType objectType = metadataObj.getObjectType();
        switch (objectType) {
            case HIERARCHY: {
                dynamicMeta = sc.getDefaultHierarchy();
                break;
            }
            case LEVEL: {
                dynamicMeta = sc.getLevel(metadataObj.getName());
                break;
            }
            case DIMENSION: {
                dynamicMeta = sc;
                break;
            }
            case QUERY_ITEM: {
                ILevel level;
                ILevel srcLevel;
                if (!(metadataObj instanceof IProperty) || (srcLevel = sc.getLevel((level = ((IProperty)metadataObj).getLevel()).getName())) == null) break;
                dynamicMeta = MetadataUtil.getPropertyByRole(srcLevel, metadataObj.getName());
            }
        }
        if (dynamicMeta == null) {
            return;
        }
        m.setMetadata(dynamicMeta);
        if (m instanceof V5BoundMemberUniqueName && (sMun = (mun = (V5BoundMemberUniqueName)m).getExternalMemberUniqueName()) != null) {
            String dimName;
            String[] parts;
            try {
                parts = UniqueNameParser.parse(sMun, -1);
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(e);
            }
            IHierarchy hier = V5BoundModelIdentifier.getHierarchyFromIMetadata(dynamicMeta);
            parts[0] = dimName = hier.getDimension().getName();
            String newMun = UniqueNameGenerator.createUniqueName(parts);
            mun.setExternalMemberUniqueName(newMun);
            mun.setNativeName(newMun);
        }
    }

    private CubeWrapper getCubeWrapper(MDXQuery mdxQuery) {
        MDXFromCube fromCube = mdxQuery.getMDXFrom();
        ICube cube = fromCube.getCube();
        if (cube instanceof CubeWrapper) {
            return (CubeWrapper)cube;
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        Object applied = mdxQuery.getPropertyValue(STR_DYNAMIC_SCOPED_TO_APPLIED);
        if (applied != null || !mdxQuery.isDMR() || mdxQuery.isDMRCubeReuseEnabled() || this.getCubeWrapper(mdxQuery) == null) {
            this.traceQueryCondition(false, "The transformation applies only to non-reusable DMR.", trace);
            return false;
        }
        boolean b = false;
        List<IXQEQueryNode> nodes = mdxQuery.getDescendantsOfCategory(201029, false);
        for (IXQEQueryNode n : nodes) {
            V5BoundToMetadata metaNode = (V5BoundToMetadata)n;
            if (metaNode.getPropertyValue("DynamicScopedTo") == null && metaNode.getPropertyValue("applyToDSQS") == null) continue;
            b = true;
            break;
        }
        if (!b) {
            this.traceQueryCondition(false, "MDXQuery does not have DynamicScopedTo.", trace);
            return false;
        }
        this.traceQueryCondition(true, "MDXQuery has DynamicScopedTo.", trace);
        return true;
    }
}

