/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.querynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import java.util.List;

public final class ReplaceSecondaryLevelWithPrimaryLevelProperty
extends AbstractV5ToCogMDXTransformation {
    public static final String K_W = "PRIMARY=";
    public static final String DYNAMIC_DATAITEMREF_NAME = "reservedDynamicPropertyName";

    public ReplaceSecondaryLevelWithPrimaryLevelProperty() {
        this.mName = "Replace Secondary Level With Primary Level Property.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{101050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5EdgeGroup currentEdgeGroup;
        ILevel projectedLevel;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        mdxQuery.setDMRCubeReuseEnabled(false);
        IXQEQueryNode parent = node.getParent();
        V5EdgeGroup parentEdgeGroup = (V5EdgeGroup)parent;
        ILevel projectedLevelParent = this.getSingleProjectedLevel(parentEdgeGroup);
        if (projectedLevelParent instanceof MDXLevelInfo.LevelInfo) {
            projectedLevelParent = ((MDXLevelInfo.LevelInfo)projectedLevelParent).getLevel();
        }
        if ((projectedLevel = this.getSingleProjectedLevel(currentEdgeGroup = (V5EdgeGroup)node)) instanceof MDXLevelInfo.LevelInfo) {
            projectedLevel = ((MDXLevelInfo.LevelInfo)projectedLevel).getLevel();
        }
        V5ValueSet vs = ((V5EdgeGroup)node).getV5ValueSet();
        RSAPIEdgeRowset rowset = vs.getRSAPIEdgeRowset();
        IProperty dynamic = ((LevelWrapper)projectedLevelParent).wrapToDynamicProperty(projectedLevel, rowset.getRowsetId());
        rowset.setReplacedWithDynamicPropertyName(dynamic.getName());
        IHierarchy parentGrpHier = parentEdgeGroup.getPropertyHierarchy();
        if (parentGrpHier != null) {
            currentEdgeGroup.setPropertyHierarchy(parentGrpHier);
        } else {
            currentEdgeGroup.removePropertyHierarchy();
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode members = nodeFactory.createNode(201086);
        V5BoundModelIdentifier levelObj = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        levelObj.setMetadata(projectedLevelParent);
        members.addChild(levelObj);
        vs.exchangeChildNode(vs.getChild(0), members);
        IXQEQueryNode gb = nodeFactory.createNode(101051);
        IXQEQueryNode ref = nodeFactory.createNode(101015);
        ref.setPropertyValue("refDataItem", DYNAMIC_DATAITEMREF_NAME);
        gb.addChild(ref);
        V5BoundModelIdentifier propertyObj = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        propertyObj.setMetadata(dynamic);
        ref.addChild(propertyObj);
        vs.addChild(gb);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (!mdxQuery.isDMR()) {
            this.traceQueryCondition(false, "Not a DMR.", trace);
            return false;
        }
        if (((V5EdgeGroup)node).isDetailGroup()) {
            this.traceQueryCondition(false, "detail edge group.", trace);
            return false;
        }
        V5ValueSet vs = ((V5EdgeGroup)node).getV5ValueSet();
        IXQEQueryNode gb = vs.getFirstChildByType(101051);
        if (gb != null) {
            this.traceQueryCondition(false, "not yet.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() != 101050) {
            this.traceQueryCondition(false, "parent is not a edge group.", trace);
            return false;
        }
        ILevel projectedLevelParent = this.getSingleProjectedLevel((V5EdgeGroup)parent);
        ILevel projectedLevel = this.getSingleProjectedLevel((V5EdgeGroup)node);
        if (projectedLevel == null || projectedLevelParent == null || projectedLevel.getHierarchy().equals(projectedLevelParent.getHierarchy())) {
            this.traceQueryCondition(false, "not a single projected regular level.", trace);
            return false;
        }
        if (this.isPrimaryScondaryLevel(projectedLevelParent, projectedLevel)) {
            this.traceQueryCondition(true, "parent edge group is primary level.", trace);
            return true;
        }
        this.traceQueryCondition(false, "parent edge group is not primary level.", trace);
        return false;
    }

    private ILevel getSingleProjectedLevel(V5EdgeGroup grp) {
        IHierarchy hier = grp.getEdgeGroupHierarchy();
        if (hier == null || hier.getDimension().isMeasuresDimension()) {
            return null;
        }
        V5ValueSet vs = grp.getV5ValueSet();
        IXQEQueryNode[] children = vs.getChildren();
        MDXLevelInfo contextLevel = new MDXLevelInfo();
        contextLevel.addProjectedHierarchy(hier);
        ArrayList<V5SimpleNode> fncs = new ArrayList<V5SimpleNode>();
        MDXLevelInfo levelInfo = ((V5SimpleNode)children[0]).getHierarchyLevelInfo(contextLevel, fncs);
        if (levelInfo == null || levelInfo.isEmpty() || levelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            return null;
        }
        List<ILevel> lvls = levelInfo.getProjectedLevels(hier);
        if (lvls.size() != 1) {
            return null;
        }
        return lvls.get(0);
    }

    private boolean isPrimaryScondaryLevel(ILevel primaryLevel, ILevel secondaryLevel) {
        String primaryDefinition = null;
        for (ILevel currentSecondary = secondaryLevel; currentSecondary != null; currentSecondary = currentSecondary.getNextLevel()) {
            String desc = secondaryLevel.getDescription();
            int idx = desc.indexOf(K_W);
            if (idx == -1) continue;
            primaryDefinition = desc.substring(idx + K_W.length());
            break;
        }
        if (primaryDefinition == null) {
            return false;
        }
        int idx = primaryDefinition.indexOf("{");
        if (idx == -1) {
            return false;
        }
        if ((idx = (primaryDefinition = primaryDefinition.substring(idx + 1)).indexOf("}")) == -1) {
            return false;
        }
        primaryDefinition = primaryDefinition.substring(0, idx);
        String[] v5UNames = primaryDefinition.split(",");
        IDimension secondaryDim = secondaryLevel.getDimension();
        if (!(secondaryDim instanceof AbstractDimensionWrapper)) {
            return false;
        }
        for (String aUName : v5UNames) {
            try {
                String[] parts = UniqueNameParser.parse(aUName);
                if (parts.length != 4 || !this.isPrimaryLevel(primaryLevel, parts, (AbstractDimensionWrapper)secondaryDim)) continue;
                return true;
            }
            catch (UniqueNameParserException uniqueNameParserException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isPrimaryLevel(ILevel level, String[] parts, AbstractDimensionWrapper secondaryDim) {
        IDimension dim = level.getDimension();
        if (!(dim instanceof AbstractDimensionWrapper)) {
            return false;
        }
        AbstractDimensionWrapper primaryDim = (AbstractDimensionWrapper)dim;
        MetadataContext pc = primaryDim.getMetadataContext();
        MetadataContext sc = secondaryDim.getMetadataContext();
        if (sc != null && !sc.compatibleWithPrimaryMetadataContext(pc)) {
            return false;
        }
        String dimUName = primaryDim.getShortcutTargetV5UniqueName();
        String[] dimNameparts = null;
        try {
            dimNameparts = UniqueNameParser.parse(dimUName);
            if (dimNameparts.length != 2) {
                return false;
            }
        }
        catch (UniqueNameParserException e) {
            return false;
        }
        if (!parts[0].equals(dimNameparts[0])) {
            return false;
        }
        if (!parts[1].equals(dimNameparts[1])) {
            return false;
        }
        if (!parts[2].equals(level.getHierarchy().getName())) {
            return false;
        }
        if (parts[3].equals(level.getName())) {
            return true;
        }
        for (ILevel currentLevel = level.getPreviousLevel(); currentLevel != null; currentLevel = currentLevel.getPreviousLevel()) {
            if (!parts[3].equals(currentLevel.getName())) continue;
            return true;
        }
        return false;
    }
}

