/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogmdx.querynormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogmdx.AbstractV5ToCogMDXTransformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class WrapCalculationToMeasure
extends AbstractV5ToCogMDXTransformation {
    private static final String STR_CALCULATION_TO_MEASURE_APPLIED = "calculationToMeasureApplied";

    public WrapCalculationToMeasure() {
        this.mName = "Wrap Calculation To Measure.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ArrayList<IXQEQueryNode> calcs = new ArrayList<IXQEQueryNode>();
        ArrayList<IMeasure> measuresCalc = new ArrayList<IMeasure>();
        this.canApply(node, environment, calcs, measuresCalc, false);
        MDXQuery mdxQuery = (MDXQuery)node;
        mdxQuery.setPropertyValue(STR_CALCULATION_TO_MEASURE_APPLIED, Boolean.TRUE);
        V5Query v5Query = mdxQuery.getRefV5Query();
        CubeWrapper cube = this.getCubeWrapper(mdxQuery);
        for (int i = 0; i < calcs.size(); ++i) {
            IXQEQueryNode[] v5Parameters;
            IXQEQueryNode calc = calcs.get(i);
            MeasureWrapper wrapper = (MeasureWrapper)measuresCalc.get(i);
            V5DataItem v5dataItem = this.getDataItem(v5Query, calc);
            String aggregate = v5dataItem.getAggregateProperty();
            wrapper = cube.createMeasureWrapper(wrapper);
            wrapper.setV5AggregateAttribute(aggregate);
            wrapper.setReUseable(false);
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            IXQEQueryNode set = nodeFactory.createNode(201101);
            IXQEQueryNode copy = nodeFactory.deepCopyNode(calc);
            set.addChild(copy);
            this.removeIsCoerce(set);
            copy = set.detachChild(0);
            for (IXQEQueryNode p : v5Parameters = copy.getDescendantsOfType(201024, true)) {
                V5Parameter v5Parameter = (V5Parameter)p;
                v5Parameter.setMetadata(null);
            }
            wrapper.setBinaryExpression(copy);
            ((V5SimpleNode)set).setIsCoercion(true);
            V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            newNode.setIdentifier(v5dataItem.getNameProperty());
            newNode.setMetadata(wrapper);
            set.addChild(newNode);
            calc.exchange(set);
        }
    }

    private void removeIsCoerce(IXQEQueryNode node) {
        IXQEQueryNode[] children;
        ArrayList<IXQEQueryNode> coerceChildren = new ArrayList<IXQEQueryNode>();
        this.getCoerceChildren(node, coerceChildren);
        while (!coerceChildren.isEmpty()) {
            for (IXQEQueryNode c : coerceChildren) {
                c.extract();
            }
            this.getCoerceChildren(node, coerceChildren);
        }
        for (IXQEQueryNode c : children = node.getChildren()) {
            this.removeIsCoerce(c);
        }
    }

    private void getCoerceChildren(IXQEQueryNode node, ArrayList<IXQEQueryNode> coerceChildren) {
        IXQEQueryNode[] children;
        coerceChildren.clear();
        for (IXQEQueryNode c : children = node.getChildren()) {
            V5SimpleNode n;
            if (!c.isOfCategory(201120) || !(n = (V5SimpleNode)c).isCoercion()) continue;
            coerceChildren.add(c);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        ArrayList<IXQEQueryNode> calcs = new ArrayList<IXQEQueryNode>();
        ArrayList<IMeasure> measuresCalc = new ArrayList<IMeasure>();
        if (this.canApply(node, environment, calcs, measuresCalc, true)) {
            this.traceQueryCondition(true, "Need to wrap calculation to measure.", trace);
            return true;
        }
        this.traceQueryCondition(false, "No need to wrap calculation to measure.", trace);
        return false;
    }

    private CubeWrapper getCubeWrapper(MDXQuery mdxQuery) {
        MDXFromCube fromCube = mdxQuery.getMDXFrom();
        ICube cube = fromCube.getCube();
        if (cube instanceof CubeWrapper) {
            return (CubeWrapper)cube;
        }
        return null;
    }

    private boolean canApply(IXQEQueryNode node, PlanningEnvironment environment, ArrayList<IXQEQueryNode> calcs, ArrayList<IMeasure> measuresCalc, boolean check) {
        IXQEQueryNode[] vSets;
        Object applied;
        String reqType;
        if (check && "getParameters".equals(reqType = ((RequestEnvironment)environment.getRequestEnvironment()).getOperationName())) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        if (check && ((applied = mdxQuery.getPropertyValue(STR_CALCULATION_TO_MEASURE_APPLIED)) != null || !mdxQuery.isDMR() || this.getCubeWrapper(mdxQuery) == null)) {
            return false;
        }
        HashSet<IHierarchy> hiers = new HashSet<IHierarchy>();
        HashSet<IHierarchy> propHiers = new HashSet<IHierarchy>();
        HashSet<IMeasure> measures = new HashSet<IMeasure>();
        for (IXQEQueryNode vs : vSets = mdxQuery.getDescendantsOfType(101057, false)) {
            for (IXQEQueryNode c : vs.getChildren()) {
                int tp = c.getType();
                if (tp == 101051 || tp == 101053 || tp == 101052) {
                    for (IXQEQueryNode cc : c.getChildren()) {
                        IXQEQueryNode exp = this.skipDataItemRef(cc);
                        if (!this.isCalculationWithMeasureAndLevelProps(exp, measures, propHiers)) continue;
                        calcs.add(exp);
                        measuresCalc.add(measures.iterator().next());
                        hiers.addAll(propHiers);
                    }
                    continue;
                }
                IXQEQueryNode exp = this.skipDataItemRef(c);
                if (!this.isCalculationWithMeasureAndLevelProps(exp, measures, propHiers)) continue;
                calcs.add(exp);
                measuresCalc.add(measures.iterator().next());
                hiers.addAll(propHiers);
            }
        }
        if (!check) {
            return true;
        }
        if (calcs.isEmpty() || hiers.isEmpty()) {
            return false;
        }
        V5Query v5Query = mdxQuery.getRefV5Query();
        for (IXQEQueryNode calc : calcs) {
            if (this.getDataItem(v5Query, calc) != null) continue;
            return false;
        }
        return this.unprojected(mdxQuery, calcs, hiers);
    }

    private V5DataItem getDataItem(V5Query v5Query, IXQEQueryNode calc) {
        if (v5Query == null) {
            return null;
        }
        String dataItemName = null;
        IXQEQueryNode parent = calc.getParent();
        int tp = parent.getType();
        if (tp == 101057) {
            dataItemName = ((V5ValueSet)parent).getRefDataItemProperty();
        } else if (tp == 101015) {
            dataItemName = ((V5DataItemRef)parent).getDataItemRefProperty();
        }
        if (dataItemName == null) {
            return null;
        }
        return v5Query.getDataItemByName(dataItemName);
    }

    private boolean exclude(ArrayList<IXQEQueryNode> calcs, IXQEQueryNode node) {
        for (IXQEQueryNode c : calcs) {
            if (!node.isAncestor(c)) continue;
            return true;
        }
        return false;
    }

    private boolean unprojected(MDXQuery mdxQuery, ArrayList<IXQEQueryNode> calcs, HashSet<IHierarchy> hiers) {
        List<IXQEQueryNode> allMetadatas = mdxQuery.getDescendantsOfCategory(201029, false);
        HashSet<IHierarchy> referencedHierarchies = new HashSet<IHierarchy>();
        for (IXQEQueryNode xqeQueryNode : allMetadatas) {
            V5BoundToMetadata metaNode;
            IMetadata metaObj;
            IHierarchy h;
            if (this.exclude(calcs, xqeQueryNode) || (h = V5BoundModelIdentifier.getHierarchyFromIMetadata(metaObj = (metaNode = (V5BoundToMetadata)xqeQueryNode).getMetadata())) == null) continue;
            referencedHierarchies.add(h);
        }
        HashSet<IHierarchy> intersection = new HashSet<IHierarchy>(hiers);
        intersection.retainAll(referencedHierarchies);
        return intersection.isEmpty();
    }

    private IXQEQueryNode skipDataItemRef(IXQEQueryNode node) {
        IXQEQueryNode rt = node;
        while (rt.getType() == 101015) {
            rt = rt.getChild(0);
        }
        return rt;
    }

    private boolean isCalculationWithMeasureAndLevelProps(IXQEQueryNode node, HashSet<IMeasure> measures, HashSet<IHierarchy> propHiers) {
        if (!node.isOfCategory(201120)) {
            return false;
        }
        V5SimpleNode exp = (V5SimpleNode)node;
        MDXHierInfo hierInfo = exp.getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1 || !hierInfo.getProjectedHierarchy(0).isShell()) {
            return false;
        }
        measures.clear();
        propHiers.clear();
        List<IXQEQueryNode> metas = node.getDescendantsOfCategory(201029, true);
        for (IXQEQueryNode n : metas) {
            V5BoundToMetadata metaNode = (V5BoundToMetadata)n;
            IMetadata metaObj = metaNode.getMetadata();
            if (metaObj instanceof IMeasure) {
                measures.add((IMeasure)metaObj);
                continue;
            }
            if (V5ExpressionCheck.isExplicitProperty(metaNode)) {
                IHierarchy h = ((IQueryItem)metaObj).getHierarchy();
                if (h != null) {
                    propHiers.add(h);
                    continue;
                }
                return false;
            }
            return false;
        }
        return measures.size() == 1 && !propHiers.isEmpty();
    }
}

